/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestHandler;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.threadpool.ScheduledExecutorServiceScheduler;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.xcontent.XContentType;

public class BulkProcessor
implements Closeable {
    static final String FLUSH_SCHEDULER_NAME_SUFFIX = "-flush-scheduler";
    static final String RETRY_SCHEDULER_NAME_SUFFIX = "-retry-scheduler";
    private final int bulkActions;
    private final long bulkSize;
    private final Scheduler.Cancellable cancellableFlushTask;
    private final AtomicLong executionIdGen = new AtomicLong();
    private BulkRequest bulkRequest;
    private final Supplier<BulkRequest> bulkRequestSupplier;
    private final Supplier<Boolean> flushSupplier;
    private final BulkRequestHandler bulkRequestHandler;
    private final Runnable onClose;
    private volatile boolean closed = false;
    private final ReentrantLock lock = new ReentrantLock();

    public static Builder builder(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, Listener listener, String name) {
        Objects.requireNonNull(consumer, "consumer");
        Objects.requireNonNull(listener, "listener");
        ScheduledThreadPoolExecutor flushScheduler = Scheduler.initScheduler(Settings.EMPTY, name + FLUSH_SCHEDULER_NAME_SUFFIX);
        ScheduledThreadPoolExecutor retryScheduler = Scheduler.initScheduler(Settings.EMPTY, name + RETRY_SCHEDULER_NAME_SUFFIX);
        return new Builder(consumer, listener, BulkProcessor.buildScheduler(flushScheduler), BulkProcessor.buildScheduler(retryScheduler), () -> {
            Scheduler.terminate(flushScheduler, 10L, TimeUnit.SECONDS);
            Scheduler.terminate(retryScheduler, 10L, TimeUnit.SECONDS);
        });
    }

    private static Scheduler buildScheduler(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return new ScheduledExecutorServiceScheduler(scheduledThreadPoolExecutor);
    }

    BulkProcessor(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, Listener listener, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval, Scheduler flushScheduler, Scheduler retryScheduler, Runnable onClose, Supplier<BulkRequest> bulkRequestSupplier, Supplier<Boolean> flushSupplier) {
        this.bulkActions = bulkActions;
        this.bulkSize = bulkSize.getBytes();
        this.bulkRequest = bulkRequestSupplier.get();
        this.bulkRequestSupplier = bulkRequestSupplier;
        this.flushSupplier = flushSupplier;
        this.bulkRequestHandler = new BulkRequestHandler(consumer, backoffPolicy, listener, retryScheduler, concurrentRequests);
        this.cancellableFlushTask = this.startFlushTask(flushInterval, flushScheduler);
        this.onClose = onClose;
    }

    BulkProcessor(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, Listener listener, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval, Scheduler flushScheduler, Scheduler retryScheduler, Runnable onClose, Supplier<BulkRequest> bulkRequestSupplier) {
        this(consumer, backoffPolicy, listener, concurrentRequests, bulkActions, bulkSize, flushInterval, flushScheduler, retryScheduler, onClose, bulkRequestSupplier, () -> true);
    }

    @Deprecated
    BulkProcessor(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, Listener listener, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval, Scheduler scheduler, Runnable onClose, Supplier<BulkRequest> bulkRequestSupplier) {
        this(consumer, backoffPolicy, listener, concurrentRequests, bulkActions, bulkSize, flushInterval, scheduler, scheduler, onClose, bulkRequestSupplier);
    }

    @Override
    public void close() {
        try {
            this.awaitClose(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.closed) {
                boolean bl = true;
                return bl;
            }
            this.closed = true;
            this.cancellableFlushTask.cancel();
            if (this.bulkRequest.numberOfActions() > 0) {
                this.execute();
            }
            try {
                boolean bl = this.bulkRequestHandler.awaitClose(timeout, unit);
                this.onClose.run();
                return bl;
            }
            catch (Throwable throwable) {
                this.onClose.run();
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public BulkProcessor add(IndexRequest request) {
        return this.add((DocWriteRequest<?>)request);
    }

    public BulkProcessor add(DeleteRequest request) {
        return this.add((DocWriteRequest<?>)request);
    }

    public BulkProcessor add(DocWriteRequest<?> request) {
        this.internalAdd(request);
        return this;
    }

    boolean isOpen() {
        return !this.closed;
    }

    protected void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("bulk process already closed");
        }
    }

    private void internalAdd(DocWriteRequest<?> request) {
        Tuple<BulkRequest, Long> bulkRequestToExecute = null;
        this.lock.lock();
        try {
            this.ensureOpen();
            this.bulkRequest.add(request);
            bulkRequestToExecute = this.newBulkRequestIfNeeded();
        }
        finally {
            this.lock.unlock();
        }
        if (bulkRequestToExecute != null) {
            this.execute((BulkRequest)bulkRequestToExecute.v1(), (Long)bulkRequestToExecute.v2());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultPipeline, XContentType xContentType) throws Exception {
        Tuple<BulkRequest, Long> bulkRequestToExecute = null;
        this.lock.lock();
        try {
            this.ensureOpen();
            this.bulkRequest.add(data, defaultIndex, null, null, defaultPipeline, null, true, xContentType, RestApiVersion.current());
            bulkRequestToExecute = this.newBulkRequestIfNeeded();
        }
        finally {
            this.lock.unlock();
        }
        if (bulkRequestToExecute != null) {
            this.execute((BulkRequest)bulkRequestToExecute.v1(), (Long)bulkRequestToExecute.v2());
        }
        return this;
    }

    private Scheduler.Cancellable startFlushTask(TimeValue flushInterval, Scheduler scheduler) {
        if (flushInterval == null) {
            return new Scheduler.Cancellable(){

                @Override
                public boolean cancel() {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return true;
                }
            };
        }
        return scheduler.scheduleWithFixedDelay(new Flush(), flushInterval, EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    private Tuple<BulkRequest, Long> newBulkRequestIfNeeded() {
        this.ensureOpen();
        if (!this.isOverTheLimit()) {
            return null;
        }
        BulkRequest bulkRequest = this.bulkRequest;
        this.bulkRequest = this.bulkRequestSupplier.get();
        return new Tuple((Object)bulkRequest, (Object)this.executionIdGen.incrementAndGet());
    }

    private void execute(BulkRequest bulkRequest, long executionId) {
        this.bulkRequestHandler.execute(bulkRequest, executionId);
    }

    private void execute() {
        if (this.flushSupplier.get().booleanValue()) {
            BulkRequest bulkRequest = this.bulkRequest;
            long executionId = this.executionIdGen.incrementAndGet();
            this.bulkRequest = this.bulkRequestSupplier.get();
            this.execute(bulkRequest, executionId);
        }
    }

    private boolean isOverTheLimit() {
        if (this.bulkActions != -1 && this.bulkRequest.numberOfActions() >= this.bulkActions) {
            return true;
        }
        return this.bulkSize != -1L && this.bulkRequest.estimatedSizeInBytes() >= this.bulkSize;
    }

    public void flush() {
        this.lock.lock();
        try {
            this.ensureOpen();
            if (this.bulkRequest.numberOfActions() > 0) {
                this.execute();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class Builder {
        private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
        private final Listener listener;
        private final Scheduler flushScheduler;
        private final Scheduler retryScheduler;
        private final Runnable onClose;
        private int concurrentRequests = 1;
        private int bulkActions = 1000;
        private ByteSizeValue bulkSize = new ByteSizeValue(5L, ByteSizeUnit.MB);
        private TimeValue flushInterval = null;
        private BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff();
        private String globalIndex;
        private String globalRouting;
        private String globalPipeline;
        private Supplier<Boolean> flushCondition = () -> true;

        private Builder(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, Listener listener, Scheduler flushScheduler, Scheduler retryScheduler, Runnable onClose) {
            this.consumer = consumer;
            this.listener = listener;
            this.flushScheduler = flushScheduler;
            this.retryScheduler = retryScheduler;
            this.onClose = onClose;
        }

        public Builder setConcurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        public Builder setBulkActions(int bulkActions) {
            this.bulkActions = bulkActions;
            return this;
        }

        public Builder setBulkSize(ByteSizeValue bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder setFlushInterval(TimeValue flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public Builder setGlobalIndex(String globalIndex) {
            this.globalIndex = globalIndex;
            return this;
        }

        public Builder setGlobalRouting(String globalRouting) {
            this.globalRouting = globalRouting;
            return this;
        }

        public Builder setGlobalPipeline(String globalPipeline) {
            this.globalPipeline = globalPipeline;
            return this;
        }

        public Builder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == null) {
                throw new NullPointerException("'backoffPolicy' must not be null. To disable backoff, pass BackoffPolicy.noBackoff()");
            }
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public BulkProcessor build() {
            return new BulkProcessor(this.consumer, this.backoffPolicy, this.listener, this.concurrentRequests, this.bulkActions, this.bulkSize, this.flushInterval, this.flushScheduler, this.retryScheduler, this.onClose, this.createBulkRequestWithGlobalDefaults(), this.flushCondition);
        }

        private Supplier<BulkRequest> createBulkRequestWithGlobalDefaults() {
            return () -> new BulkRequest(this.globalIndex).pipeline(this.globalPipeline).routing(this.globalRouting);
        }

        public Builder setFlushCondition(Supplier<Boolean> flushCondition) {
            this.flushCondition = flushCondition;
            return this;
        }
    }

    public static interface Listener {
        public void beforeBulk(long var1, BulkRequest var3);

        public void afterBulk(long var1, BulkRequest var3, BulkResponse var4);

        public void afterBulk(long var1, BulkRequest var3, Throwable var4);
    }

    class Flush
    implements Runnable {
        Flush() {
        }

        @Override
        public void run() {
            BulkProcessor.this.lock.lock();
            try {
                if (BulkProcessor.this.closed) {
                    return;
                }
                if (BulkProcessor.this.bulkRequest.numberOfActions() == 0) {
                    return;
                }
                BulkProcessor.this.execute();
            }
            finally {
                BulkProcessor.this.lock.unlock();
            }
        }
    }
}

