/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ReloadAnalyzersRequest
extends BroadcastRequest<ReloadAnalyzersRequest> {
    private final String resource;
    private final boolean preview;
    private static final TransportVersion PREVIEW_OPTION_TRANSPORT_VERSION = TransportVersions.V_8_500_034;

    public ReloadAnalyzersRequest(String resource, boolean preview, String ... indices) {
        super(indices);
        this.resource = resource;
        this.preview = preview;
    }

    public ReloadAnalyzersRequest(StreamInput in) throws IOException {
        super(in);
        this.resource = in.readOptionalString();
        this.preview = in.getTransportVersion().onOrAfter(PREVIEW_OPTION_TRANSPORT_VERSION) && in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.resource);
        if (out.getTransportVersion().onOrAfter(PREVIEW_OPTION_TRANSPORT_VERSION)) {
            out.writeBoolean(this.preview);
        }
    }

    public String resource() {
        return this.resource;
    }

    public boolean preview() {
        return this.preview;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReloadAnalyzersRequest that = (ReloadAnalyzersRequest)o;
        return this.preview == that.preview && Objects.equals(this.resource, that.resource);
    }

    public int hashCode() {
        return Objects.hash(this.indicesOptions(), Arrays.hashCode(this.indices), this.resource, this.preview);
    }
}

