/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportGetAliasesAction
extends TransportMasterNodeReadAction<GetAliasesRequest, GetAliasesResponse> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportGetAliasesAction.class);
    private final SystemIndices systemIndices;

    @Inject
    public TransportGetAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/aliases/get", transportService, clusterService, threadPool, actionFilters, GetAliasesRequest::new, indexNameExpressionResolver, GetAliasesResponse::new, threadPool.executor("management"));
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(GetAliasesRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, request));
    }

    @Override
    protected void masterOperation(Task task, GetAliasesRequest request, ClusterState state, ActionListener<GetAliasesResponse> listener) {
        assert (Transports.assertNotTransportThread("no need to avoid the context switch and may be expensive if there are many aliases"));
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, request);
        SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel = this.indexNameExpressionResolver.getSystemIndexAccessLevel();
        Map<String, List<AliasMetadata>> aliases = state.metadata().findAliases(request.aliases(), concreteIndices);
        listener.onResponse(new GetAliasesResponse(TransportGetAliasesAction.postProcess(request, concreteIndices, aliases, state, systemIndexAccessLevel, this.threadPool.getThreadContext(), this.systemIndices), TransportGetAliasesAction.postProcess(this.indexNameExpressionResolver, request, state)));
    }

    static Map<String, List<AliasMetadata>> postProcess(GetAliasesRequest request, String[] concreteIndices, Map<String, List<AliasMetadata>> aliases, ClusterState state, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, ThreadContext threadContext, SystemIndices systemIndices) {
        boolean noAliasesSpecified = request.getOriginalAliases() == null || request.getOriginalAliases().length == 0;
        HashMap<String, List<AliasMetadata>> mapBuilder = new HashMap<String, List<AliasMetadata>>(aliases);
        for (String index : concreteIndices) {
            IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(index);
            assert (ia.getType() == IndexAbstraction.Type.CONCRETE_INDEX);
            if (ia.getParentDataStream() != null || aliases.get(index) != null || !noAliasesSpecified) continue;
            List previous = mapBuilder.put(index, Collections.emptyList());
            assert (previous == null);
        }
        Map<String, List<AliasMetadata>> finalResponse = Collections.unmodifiableMap(mapBuilder);
        if (systemIndexAccessLevel != SystemIndices.SystemIndexAccessLevel.ALL) {
            TransportGetAliasesAction.checkSystemIndexAccess(request, systemIndices, state, finalResponse, systemIndexAccessLevel, threadContext);
        }
        return finalResponse;
    }

    static Map<String, List<DataStreamAlias>> postProcess(IndexNameExpressionResolver resolver, GetAliasesRequest request, ClusterState state) {
        HashMap<String, List<DataStreamAlias>> result = new HashMap<String, List<DataStreamAlias>>();
        boolean noAliasesSpecified = request.getOriginalAliases() == null || request.getOriginalAliases().length == 0;
        List<String> requestedDataStreams = resolver.dataStreamNames(state, request.indicesOptions(), request.indices());
        for (String requestedDataStream : requestedDataStreams) {
            List<DataStreamAlias> aliases = state.metadata().dataStreamAliases().values().stream().filter(alias -> alias.getDataStreams().contains(requestedDataStream)).filter(alias -> noAliasesSpecified || Regex.simpleMatch(request.aliases(), alias.getName())).toList();
            if (aliases.isEmpty()) continue;
            result.put(requestedDataStream, aliases);
        }
        return result;
    }

    private static void checkSystemIndexAccess(GetAliasesRequest request, SystemIndices systemIndices, ClusterState state, Map<String, List<AliasMetadata>> aliasesMap, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, ThreadContext threadContext) {
        Predicate<String> systemIndexAccessAllowPredicate;
        if (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.NONE) {
            systemIndexAccessAllowPredicate = indexName -> false;
        } else if (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.RESTRICTED) {
            systemIndexAccessAllowPredicate = systemIndices.getProductSystemIndexNamePredicate(threadContext);
        } else {
            throw new IllegalArgumentException("Unexpected system index access level: " + systemIndexAccessLevel);
        }
        ArrayList<String> netNewSystemIndices = new ArrayList<String>();
        ArrayList systemIndicesNames = new ArrayList();
        aliasesMap.keySet().forEach(indexName -> {
            IndexMetadata index = state.metadata().index((String)indexName);
            if (index != null && index.isSystem() && !systemIndexAccessAllowPredicate.test((String)indexName)) {
                if (systemIndices.isNetNewSystemIndex((String)indexName)) {
                    netNewSystemIndices.add((String)indexName);
                } else {
                    systemIndicesNames.add(indexName);
                }
            }
        });
        if (!systemIndicesNames.isEmpty()) {
            deprecationLogger.warn(DeprecationCategory.API, "open_system_index_access", "this request accesses system indices: {}, but in a future major version, direct access to system indices will be prevented by default", systemIndicesNames);
        }
        if (!netNewSystemIndices.isEmpty()) {
            throw SystemIndices.netNewSystemIndexAccessException(threadContext, netNewSystemIndices);
        }
    }
}

