/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetAliasesResponse
extends ActionResponse {
    private final Map<String, List<AliasMetadata>> aliases;
    private final Map<String, List<DataStreamAlias>> dataStreamAliases;

    public GetAliasesResponse(Map<String, List<AliasMetadata>> aliases, Map<String, List<DataStreamAlias>> dataStreamAliases) {
        this.aliases = aliases;
        this.dataStreamAliases = dataStreamAliases;
    }

    public GetAliasesResponse(StreamInput in) throws IOException {
        super(in);
        this.aliases = in.readImmutableOpenMap(StreamInput::readString, i -> i.readCollectionAsList(AliasMetadata::new));
        this.dataStreamAliases = in.readMap(in1 -> in1.readCollectionAsList(DataStreamAlias::new));
    }

    public Map<String, List<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    public Map<String, List<DataStreamAlias>> getDataStreamAliases() {
        return this.dataStreamAliases;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.aliases, StreamOutput::writeCollection);
        out.writeMap(this.dataStreamAliases, StreamOutput::writeCollection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAliasesResponse that = (GetAliasesResponse)o;
        return Objects.equals(this.aliases, that.aliases) && Objects.equals(this.dataStreamAliases, that.dataStreamAliases);
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.dataStreamAliases);
    }
}

