/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class SearchUsageStats
implements Writeable,
ToXContentFragment {
    private long totalSearchCount;
    private final Map<String, Long> queries;
    private final Map<String, Long> sections;

    public SearchUsageStats() {
        this.totalSearchCount = 0L;
        this.queries = new HashMap<String, Long>();
        this.sections = new HashMap<String, Long>();
    }

    public SearchUsageStats(Map<String, Long> queries, Map<String, Long> sections, long totalSearchCount) {
        this.totalSearchCount = totalSearchCount;
        this.queries = queries;
        this.sections = sections;
    }

    public SearchUsageStats(StreamInput in) throws IOException {
        this.queries = in.readMap(StreamInput::readLong);
        this.sections = in.readMap(StreamInput::readLong);
        this.totalSearchCount = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.queries, StreamOutput::writeLong);
        out.writeMap(this.sections, StreamOutput::writeLong);
        out.writeVLong(this.totalSearchCount);
    }

    public void add(SearchUsageStats stats) {
        stats.queries.forEach((query, count) -> this.queries.merge((String)query, (Long)count, Long::sum));
        stats.sections.forEach((query, count) -> this.sections.merge((String)query, (Long)count, Long::sum));
        this.totalSearchCount += stats.totalSearchCount;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search");
        builder.field("total", this.totalSearchCount);
        builder.field("queries");
        builder.map(this.queries);
        builder.field("sections");
        builder.map(this.sections);
        builder.endObject();
        return builder;
    }

    public Map<String, Long> getQueryUsage() {
        return Collections.unmodifiableMap(this.queries);
    }

    public Map<String, Long> getSectionsUsage() {
        return Collections.unmodifiableMap(this.sections);
    }

    public long getTotalSearchCount() {
        return this.totalSearchCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchUsageStats that = (SearchUsageStats)o;
        return this.totalSearchCount == that.totalSearchCount && this.queries.equals(that.queries) && this.sections.equals(that.sections);
    }

    public int hashCode() {
        return Objects.hash(this.totalSearchCount, this.queries, this.sections);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

