/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskGroup;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class ListTasksResponse
extends BaseTasksResponse {
    private static final String TASKS = "tasks";
    private final List<TaskInfo> tasks;
    private Map<String, List<TaskInfo>> perNodeTasks;
    private List<TaskGroup> groups;
    private static final ConstructingObjectParser<ListTasksResponse, Void> PARSER = ListTasksResponse.setupParser("list_tasks_response", ListTasksResponse::new);

    public ListTasksResponse(List<TaskInfo> tasks, List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures) {
        super(taskFailures, nodeFailures);
        this.tasks = tasks == null ? List.of() : List.copyOf(tasks);
    }

    public ListTasksResponse(StreamInput in) throws IOException {
        super(in);
        this.tasks = in.readCollectionAsImmutableList(TaskInfo::from);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.tasks);
    }

    protected static <T> ConstructingObjectParser<T, Void> setupParser(String name, TriFunction<List<TaskInfo>, List<TaskOperationFailure>, List<ElasticsearchException>, T> ctor) {
        ConstructingObjectParser parser = new ConstructingObjectParser(name, true, constructingObjects -> {
            int i = 0;
            List tasks = (List)constructingObjects[i++];
            List tasksFailures = (List)constructingObjects[i++];
            List nodeFailures = (List)constructingObjects[i];
            return ctor.apply(tasks, tasksFailures, nodeFailures);
        });
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), TaskInfo.PARSER, new ParseField(TASKS, new String[0]));
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TaskOperationFailure.fromXContent(p), new ParseField("task_failures", new String[0]));
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("node_failures", new String[0]));
        return parser;
    }

    public Map<String, List<TaskInfo>> getPerNodeTasks() {
        if (this.perNodeTasks == null) {
            this.perNodeTasks = this.tasks.stream().collect(Collectors.groupingBy(t -> t.taskId().getNodeId()));
        }
        return this.perNodeTasks;
    }

    public List<TaskGroup> getTaskGroups() {
        if (this.groups == null) {
            this.buildTaskGroups();
        }
        return this.groups;
    }

    private void buildTaskGroups() {
        HashMap<TaskId, TaskGroup.Builder> taskGroups = new HashMap<TaskId, TaskGroup.Builder>();
        ArrayList<TaskGroup.Builder> topLevelTasks = new ArrayList<TaskGroup.Builder>();
        for (TaskInfo taskInfo : this.tasks) {
            taskGroups.put(taskInfo.taskId(), TaskGroup.builder(taskInfo));
        }
        for (TaskGroup.Builder taskGroup : taskGroups.values()) {
            TaskId parentTaskId = taskGroup.getTaskInfo().parentTaskId();
            if (parentTaskId.isSet()) {
                TaskGroup.Builder parentTask = (TaskGroup.Builder)taskGroups.get(parentTaskId);
                if (parentTask != null) {
                    parentTask.addGroup(taskGroup);
                    continue;
                }
                topLevelTasks.add(taskGroup);
                continue;
            }
            topLevelTasks.add(taskGroup);
        }
        this.groups = topLevelTasks.stream().map(TaskGroup.Builder::build).toList();
    }

    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    public ChunkedToXContentObject groupedByNode(Supplier<DiscoveryNodes> nodesInCluster) {
        return ignored -> {
            DiscoveryNodes discoveryNodes = (DiscoveryNodes)nodesInCluster.get();
            return Iterators.concat(Iterators.single((builder, params) -> {
                builder.startObject();
                this.toXContentCommon(builder, params);
                builder.startObject("nodes");
                return builder;
            }), Iterators.flatMap(this.getPerNodeTasks().entrySet().iterator(), entry -> {
                DiscoveryNode node = discoveryNodes.get((String)entry.getKey());
                return Iterators.concat(Iterators.single((builder, params) -> {
                    builder.startObject((String)entry.getKey());
                    if (node != null) {
                        builder.field("name", node.getName());
                        builder.field("transport_address", node.getAddress().toString());
                        builder.field("host", node.getHostName());
                        builder.field("ip", (ToXContent)node.getAddress());
                        builder.startArray("roles");
                        for (DiscoveryNodeRole discoveryNodeRole : node.getRoles()) {
                            builder.value(discoveryNodeRole.roleName());
                        }
                        builder.endArray();
                        if (!node.getAttributes().isEmpty()) {
                            builder.startObject("attributes");
                            for (Map.Entry entry2 : node.getAttributes().entrySet()) {
                                builder.field((String)entry2.getKey(), (String)entry2.getValue());
                            }
                            builder.endObject();
                        }
                    }
                    builder.startObject(TASKS);
                    return builder;
                }), Iterators.map(((List)entry.getValue()).iterator(), task -> (builder, params) -> {
                    builder.startObject(task.taskId().toString());
                    task.toXContent(builder, params);
                    builder.endObject();
                    return builder;
                }), Iterators.single((builder, params) -> {
                    builder.endObject();
                    builder.endObject();
                    return builder;
                }));
            }), Iterators.single((builder, params) -> {
                builder.endObject();
                builder.endObject();
                return builder;
            }));
        };
    }

    public ChunkedToXContentObject groupedByParent() {
        return ignored -> Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.startObject(TASKS);
            return builder;
        }), Iterators.map(this.getTaskGroups().iterator(), group -> (builder, params) -> {
            builder.field(group.taskInfo().taskId().toString());
            group.toXContent(builder, params);
            return builder;
        }), Iterators.single((builder, params) -> {
            builder.endObject();
            builder.endObject();
            return builder;
        }));
    }

    public ChunkedToXContentObject groupedByNone() {
        return ignored -> Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.startArray(TASKS);
            return builder;
        }), Iterators.map(this.getTasks().iterator(), taskInfo -> (builder, params) -> {
            builder.startObject();
            taskInfo.toXContent(builder, params);
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> {
            builder.endArray();
            builder.endObject();
            return builder;
        }));
    }

    public static ListTasksResponse fromXContent(XContentParser parser) {
        return (ListTasksResponse)PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString(ChunkedToXContent.wrapAsToXContent(this.groupedByNone()), true, true);
    }
}

