/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.hotthreads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CheckedConsumer;

public class NodesHotThreadsResponse
extends BaseNodesResponse<NodeHotThreads> {
    public NodesHotThreadsResponse(StreamInput in) throws IOException {
        super(in);
    }

    public NodesHotThreadsResponse(ClusterName clusterName, List<NodeHotThreads> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public Iterator<CheckedConsumer<Writer, IOException>> getTextChunks() {
        return Iterators.flatMap(this.getNodes().iterator(), node -> Iterators.concat(Iterators.single(writer -> writer.append("::: ").append(node.getNode().toString()).append('\n')), Iterators.map(new LinesIterator(node.getHotThreads()), line -> writer -> writer.append("   ").append((CharSequence)line).append('\n')), Iterators.single(writer -> writer.append('\n'))));
    }

    @Override
    protected List<NodeHotThreads> readNodesFrom(StreamInput in) throws IOException {
        return in.readCollectionAsList(NodeHotThreads::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeHotThreads> nodes) throws IOException {
        out.writeCollection(nodes);
    }

    private static class LinesIterator
    implements Iterator<String> {
        final BufferedReader reader;
        String nextLine;

        private LinesIterator(String input) {
            this.reader = new BufferedReader(new StringReader(Objects.requireNonNull(input)));
            this.advance();
        }

        private void advance() {
            block2: {
                try {
                    this.nextLine = this.reader.readLine();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)e);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public String next() {
            if (this.nextLine == null) {
                throw new NoSuchElementException();
            }
            try {
                String string = this.nextLine;
                return string;
            }
            finally {
                this.advance();
            }
        }
    }
}

