/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ServiceLoader;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.internal.BuildExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public record Build(String flavor, Type type, String hash, String date, boolean isSnapshot, String version, String minWireCompatVersion, String minIndexCompatVersion, String displayString) {
    private static Build findLocalBuild() {
        String version;
        boolean isSnapshot;
        String date;
        String hash;
        Type type;
        block15: {
            String urlStr;
            type = Type.fromDisplayName(System.getProperty("es.distribution.type", "unknown"), true);
            String esPrefix = "elasticsearch-" + Version.CURRENT;
            URL url = Build.getElasticsearchCodeSourceLocation();
            String string = urlStr = url == null ? "" : url.toString();
            if (urlStr.startsWith("file:/") && (urlStr.endsWith(esPrefix + ".jar") || urlStr.matches("(.*)" + esPrefix + "(-)?((alpha|beta|rc)[0-9]+)?(-SNAPSHOT)?.jar"))) {
                try (JarInputStream jar = new JarInputStream(FileSystemUtils.openFileURLStream(url));){
                    Manifest manifest = jar.getManifest();
                    hash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    isSnapshot = "true".equals(manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Snapshot"));
                    version = manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Version");
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            hash = "unknown";
            date = "unknown";
            version = Version.CURRENT.toString();
            String buildSnapshot = System.getProperty("build.snapshot");
            if (buildSnapshot != null) {
                try {
                    Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("build.snapshot set to [" + buildSnapshot + "] but not running tests");
                }
                isSnapshot = Booleans.parseBoolean((String)buildSnapshot);
            } else {
                isSnapshot = true;
            }
        }
        if (hash == null) {
            throw new IllegalStateException("Error finding the build hash. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (date == null) {
            throw new IllegalStateException("Error finding the build date. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (version == null) {
            throw new IllegalStateException("Error finding the build version. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        String flavor = "default";
        String minWireCompat = Version.CURRENT.minimumCompatibilityVersion().toString();
        String minIndexCompat = Build.minimumCompatString(IndexVersion.MINIMUM_COMPATIBLE);
        String displayString = Build.defaultDisplayString(type, hash, date, version);
        return new Build("default", type, hash, date, isSnapshot, version, minWireCompat, minIndexCompat, displayString);
    }

    public static String minimumCompatString(IndexVersion minimumCompatible) {
        if (minimumCompatible.before(IndexVersion.V_8_500_000)) {
            return Version.fromId(minimumCompatible.id()).toString();
        }
        return minimumCompatible.toString();
    }

    public static Build current() {
        return CurrentHolder.CURRENT;
    }

    static URL getElasticsearchCodeSourceLocation() {
        CodeSource codeSource = Build.class.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    public static Build readBuild(StreamInput in) throws IOException {
        String displayString;
        String minIndexVersion;
        String minWireVersion;
        String flavor = in.getTransportVersion().before(TransportVersions.V_8_3_0) || in.getTransportVersion().onOrAfter(TransportVersions.V_8_500_039) ? in.readString() : "default";
        Type type = Type.fromDisplayName(in.readString(), false);
        String hash = in.readString();
        String date = in.readString();
        boolean snapshot = in.readBoolean();
        String version = in.readString();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_500_041)) {
            minWireVersion = in.readString();
            minIndexVersion = in.readString();
            displayString = in.readString();
        } else {
            int dashNdx = version.indexOf(45);
            Version versionConstant = Version.fromString(dashNdx == -1 ? version : version.substring(0, dashNdx));
            minWireVersion = versionConstant.minimumCompatibilityVersion().toString();
            minIndexVersion = Build.minimumCompatString(IndexVersion.getMinimumCompatibleIndexVersion(versionConstant.id()));
            displayString = Build.defaultDisplayString(type, hash, date, version);
        }
        return new Build(flavor, type, hash, date, snapshot, version, minWireVersion, minIndexVersion, displayString);
    }

    public static void writeBuild(Build build, StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_3_0) || out.getTransportVersion().onOrAfter(TransportVersions.V_8_500_039)) {
            out.writeString(build.flavor());
        }
        out.writeString(build.type().displayName());
        out.writeString(build.hash());
        out.writeString(build.date());
        out.writeBoolean(build.isSnapshot());
        out.writeString(build.qualifiedVersion());
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_500_041)) {
            out.writeString(build.minWireCompatVersion());
            out.writeString(build.minIndexCompatVersion());
            out.writeString(build.displayString());
        }
    }

    public String qualifiedVersion() {
        return this.version;
    }

    public boolean isProductionRelease() {
        return !this.isSnapshot() && !this.version.matches(".*(-alpha\\d+)|(-beta\\d+)|(-rc\\d+)");
    }

    public static String defaultDisplayString(Type type, String hash, String date, String version) {
        return "[" + type.displayName + "][" + hash + "][" + date + "][" + version + "]";
    }

    @Override
    public String toString() {
        return this.displayString();
    }

    public static enum Type {
        DEB("deb"),
        DOCKER("docker"),
        RPM("rpm"),
        TAR("tar"),
        ZIP("zip"),
        UNKNOWN("unknown");

        final String displayName;

        public String displayName() {
            return this.displayName;
        }

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public static Type fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "deb": {
                    return DEB;
                }
                case "docker": {
                    return DOCKER;
                }
                case "rpm": {
                    return RPM;
                }
                case "tar": {
                    return TAR;
                }
                case "zip": {
                    return ZIP;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                throw new IllegalStateException("unexpected distribution type [" + displayName + "]; your distribution is broken");
            }
            return UNKNOWN;
        }
    }

    private static class CurrentHolder {
        private static final Build CURRENT = CurrentHolder.findCurrent();

        private CurrentHolder() {
        }

        private static Build findCurrent() {
            BuildExtension buildExtension = ExtensionLoader.loadSingleton(ServiceLoader.load(BuildExtension.class), () -> Build::findLocalBuild);
            return buildExtension.getCurrentBuild();
        }
    }
}

