/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;
import org.elasticsearch.xpack.ml.utils.persistence.BatchedIterator;

public class WrappedBatchedJobsIterator
implements Iterator<Job> {
    private final BatchedIterator<Job.Builder> batchedIterator;
    private VolatileCursorIterator<Job> currentBatch;

    public WrappedBatchedJobsIterator(BatchedIterator<Job.Builder> batchedIterator) {
        this.batchedIterator = batchedIterator;
    }

    @Override
    public boolean hasNext() {
        return this.currentBatch != null && this.currentBatch.hasNext() || this.batchedIterator.hasNext();
    }

    @Override
    public Job next() {
        if (this.currentBatch != null && this.currentBatch.hasNext()) {
            return this.currentBatch.next();
        }
        this.currentBatch = this.createBatchIteratorFromBatch(this.batchedIterator.next());
        return this.currentBatch.hasNext() ? this.currentBatch.next() : null;
    }

    private VolatileCursorIterator<Job> createBatchIteratorFromBatch(Deque<Job.Builder> builders) {
        List jobs = builders.stream().map(Job.Builder::build).collect(Collectors.toList());
        return new VolatileCursorIterator<Job>(jobs);
    }
}

