/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.snapshot.upgrader;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.task.AbstractJobPersistentTasksExecutor;

public class SnapshotUpgradeTaskExecutor
extends AbstractJobPersistentTasksExecutor<SnapshotUpgradeTaskParams> {
    private static final Logger logger = LogManager.getLogger(SnapshotUpgradeTaskExecutor.class);
    private final AutodetectProcessManager autodetectProcessManager;
    private final AnomalyDetectionAuditor auditor;
    private final JobResultsProvider jobResultsProvider;
    private final XPackLicenseState licenseState;
    private volatile ClusterState clusterState;
    private final Client client;

    public SnapshotUpgradeTaskExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager, MlMemoryTracker memoryTracker, IndexNameExpressionResolver expressionResolver, Client client, XPackLicenseState licenseState, boolean includeNodeInfo) {
        super("xpack/ml/job/snapshot/upgrade", "ml_utility", settings, clusterService, memoryTracker, expressionResolver);
        this.autodetectProcessManager = autodetectProcessManager;
        this.auditor = new AnomalyDetectionAuditor(client, clusterService, includeNodeInfo);
        this.jobResultsProvider = new JobResultsProvider(client, settings, expressionResolver);
        this.client = client;
        this.licenseState = licenseState;
        clusterService.addListener(event -> {
            this.clusterState = event.state();
        });
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(SnapshotUpgradeTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
        Optional<PersistentTasksCustomMetadata.Assignment> optionalAssignment = this.getPotentialAssignment(params, clusterState, isMemoryTrackerRecentlyRefreshed);
        if (optionalAssignment.isPresent()) {
            return optionalAssignment.get();
        }
        JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, candidateNodes, params.getJobId(), "xpack/ml/job", this.memoryTracker, this.maxLazyMLNodes, node -> null);
        return jobNodeSelector.selectNode(this.maxOpenJobs, Integer.MAX_VALUE, this.maxMachineMemoryPercent, this.maxNodeMemory, this.useAutoMemoryPercentage);
    }

    protected void nodeOperation(AllocatedPersistentTask task, SnapshotUpgradeTaskParams params, PersistentTaskState state) {
        SnapshotUpgradeTaskState jobTaskState = (SnapshotUpgradeTaskState)state;
        SnapshotUpgradeState jobState = jobTaskState == null ? null : jobTaskState.getState();
        logger.info("[{}] [{}] starting to execute task", (Object)params.getJobId(), (Object)params.getSnapshotId());
        if (SnapshotUpgradeState.SAVING_NEW_STATE.equals((Object)jobState)) {
            this.deleteSnapshotAndFailTask(task, params.getJobId(), params.getSnapshotId());
            return;
        }
        if (SnapshotUpgradeState.FAILED.equals((Object)jobState)) {
            logger.warn("[{}] [{}] upgrade task reassigned to another node while failed", (Object)params.getJobId(), (Object)params.getSnapshotId());
            task.markAsFailed((Exception)((Object)new ElasticsearchStatusException("Task to upgrade job [{}] snapshot [{}] got reassigned while failed. Reason [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{params.getJobId(), params.getSnapshotId(), jobTaskState.getReason() == null ? "__unknown__" : jobTaskState.getReason()})));
            return;
        }
        String jobId = params.getJobId();
        String snapshotId = params.getSnapshotId();
        ActionListener stateAliasHandler = ActionListener.wrap(r -> this.autodetectProcessManager.upgradeSnapshot((SnapshotUpgradeTask)task, e -> {
            if (e == null) {
                this.auditor.info(jobId, "Finished upgrading snapshot [" + snapshotId + "]");
                logger.info("[{}] [{}] finished upgrading snapshot", (Object)jobId, (Object)snapshotId);
                task.markAsCompleted();
            } else {
                logger.warn(() -> Strings.format((String)"[%s] failed upgrading snapshot [%s]", (Object[])new Object[]{jobId, snapshotId}), (Throwable)e);
                this.auditor.warning(jobId, "failed upgrading snapshot [" + snapshotId + "] with exception " + ExceptionsHelper.unwrapCause((Throwable)e).getMessage());
                task.markAsFailed(e);
            }
        }), e -> {
            logger.warn(() -> Strings.format((String)"[%s] failed upgrading snapshot [%s] as ml state alias creation failed", (Object[])new Object[]{jobId, snapshotId}), (Throwable)e);
            this.auditor.warning(jobId, "failed upgrading snapshot [" + snapshotId + "] with exception " + ExceptionsHelper.unwrapCause((Throwable)e).getMessage());
            task.updatePersistentTaskState((PersistentTaskState)new SnapshotUpgradeTaskState(SnapshotUpgradeState.FAILED, -1L, e.getMessage()), ActionListener.wrap(r -> task.markAsFailed(e), failure -> {
                logger.warn(() -> Strings.format((String)"[%s] [%s] failed to set task to failed", (Object[])new Object[]{jobId, snapshotId}), (Throwable)failure);
                task.markAsFailed(e);
            }));
        });
        ActionListener resultsMappingUpdateHandler = ActionListener.wrap(ack -> AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessary((Client)this.client, (ClusterState)this.clusterState, (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT, (ActionListener)stateAliasHandler), arg_0 -> ((AllocatedPersistentTask)task).markAsFailed(arg_0));
        ActionListener annotationsIndexUpdateHandler = ActionListener.wrap(ack -> ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId), AnomalyDetectorsIndex::wrappedResultsMapping, (Client)this.client, (ClusterState)this.clusterState, (TimeValue)MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT, (ActionListener)resultsMappingUpdateHandler, (int)1), e -> {
            logger.warn(() -> "[" + jobId + "] ML annotations index could not be updated with latest mappings", (Throwable)e);
            ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId), AnomalyDetectorsIndex::wrappedResultsMapping, (Client)this.client, (ClusterState)this.clusterState, (TimeValue)MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT, (ActionListener)resultsMappingUpdateHandler, (int)1);
        });
        AnnotationIndex.createAnnotationsIndexIfNecessaryAndWaitForYellow((Client)this.client, (ClusterState)this.clusterState, (TimeValue)MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT, (ActionListener)annotationsIndexUpdateHandler);
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<SnapshotUpgradeTaskParams> persistentTask, Map<String, String> headers) {
        return new SnapshotUpgradeTask(((SnapshotUpgradeTaskParams)persistentTask.getParams()).getJobId(), ((SnapshotUpgradeTaskParams)persistentTask.getParams()).getSnapshotId(), id, type, action, parentTaskId, headers, this.licenseState);
    }

    @Override
    protected boolean allowsMissingIndices() {
        return false;
    }

    @Override
    protected String[] indicesOfInterest(SnapshotUpgradeTaskParams params) {
        return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), MlConfigIndex.indexName(), AnomalyDetectorsIndex.resultsWriteAlias((String)params.getJobId())};
    }

    @Override
    protected String getJobId(SnapshotUpgradeTaskParams params) {
        return params.getJobId();
    }

    private void deleteSnapshotAndFailTask(AllocatedPersistentTask task, String jobId, String snapshotId) {
        ActionListener modelSnapshotListener = ActionListener.wrap(result -> {
            if (result == null) {
                task.markAsFailed((Exception)((Object)new ElasticsearchStatusException("Task to upgrade job [{}] snapshot [{}] got reassigned while running leaving an unknown snapshot state. Snapshot is deleted", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{jobId, snapshotId})));
                return;
            }
            ModelSnapshot snapshot = (ModelSnapshot)result.result;
            JobDataDeleter jobDataDeleter = new JobDataDeleter(this.client, jobId);
            jobDataDeleter.deleteModelSnapshots(Collections.singletonList(snapshot), (ActionListener<BulkByScrollResponse>)ActionListener.wrap(deleteResponse -> {
                this.auditor.warning(jobId, "Task to upgrade snapshot exited in unknown state. Deleted snapshot [" + snapshotId + "]");
                task.markAsFailed((Exception)((Object)new ElasticsearchStatusException("Task to upgrade job [{}] snapshot [{}] got reassigned while running leaving an unknown snapshot state. Corrupted snapshot deleted", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{jobId, snapshotId})));
            }, failure -> {
                logger.warn(() -> Strings.format((String)"[%s] [%s] failed to clean up potentially bad snapshot", (Object[])new Object[]{jobId, snapshotId}), (Throwable)failure);
                task.markAsFailed((Exception)((Object)new ElasticsearchStatusException("Task to upgrade job [{}] snapshot [{}] got reassigned while running leaving an unknown snapshot state. Unable to cleanup potentially corrupted snapshot", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{jobId, snapshotId})));
            }));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                task.markAsFailed((Exception)((Object)new ElasticsearchStatusException("Task to upgrade job [{}] snapshot [{}] got reassigned while running leaving an unknown snapshot state. Snapshot is deleted", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{jobId, snapshotId})));
                return;
            }
            logger.warn(() -> Strings.format((String)"[%s] [%s] failed to load bad snapshot for deletion", (Object[])new Object[]{jobId, snapshotId}), (Throwable)e);
            task.markAsFailed((Exception)((Object)new ElasticsearchStatusException("Task to upgrade job [{}] snapshot [{}] got reassigned while running leaving an unknown snapshot state. Unable to cleanup potentially corrupted snapshot", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{jobId, snapshotId})));
        });
        this.jobResultsProvider.getModelSnapshot(jobId, snapshotId, arg_0 -> ((ActionListener)modelSnapshotListener).onResponse(arg_0), arg_0 -> ((ActionListener)modelSnapshotListener).onFailure(arg_0));
    }
}

