/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class JobResultsPersister {
    private static final Logger logger = LogManager.getLogger(JobResultsPersister.class);
    private final OriginSettingClient client;
    private final ResultsPersisterService resultsPersisterService;

    public JobResultsPersister(OriginSettingClient client, ResultsPersisterService resultsPersisterService) {
        this.client = client;
        this.resultsPersisterService = resultsPersisterService;
    }

    public Builder bulkPersisterBuilder(String jobId) {
        return new Builder(jobId, () -> true);
    }

    public Builder bulkPersisterBuilder(String jobId, Supplier<Boolean> shouldRetry) {
        return new Builder(jobId, shouldRetry);
    }

    public void persistQuantiles(Quantiles quantiles, Supplier<Boolean> shouldRetry) {
        String jobId = quantiles.getJobId();
        String quantilesDocId = Quantiles.documentId((String)jobId);
        SearchRequest searchRequest = JobResultsPersister.buildQuantilesDocIdSearch(quantilesDocId);
        SearchResponse searchResponse = this.resultsPersisterService.searchWithRetry(searchRequest, jobId, shouldRetry, retryMessage -> logger.debug("[{}] {} {}", (Object)jobId, (Object)quantilesDocId, retryMessage));
        String indexOrAlias = searchResponse.getHits().getHits().length > 0 ? searchResponse.getHits().getHits()[0].getIndex() : AnomalyDetectorsIndex.jobStateIndexWriteAlias();
        Persistable persistable = new Persistable(indexOrAlias, quantiles.getJobId(), (ToXContent)quantiles, quantilesDocId);
        persistable.persist(shouldRetry, AnomalyDetectorsIndex.jobStateIndexWriteAlias().equals(indexOrAlias));
    }

    public void persistQuantiles(Quantiles quantiles, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DocWriteResponse> listener) {
        String quantilesDocId = Quantiles.documentId((String)quantiles.getJobId());
        ActionListener searchFormerQuantilesDocListener = ActionListener.wrap(searchResponse -> {
            String indexOrAlias = searchResponse.getHits().getHits().length > 0 ? searchResponse.getHits().getHits()[0].getIndex() : AnomalyDetectorsIndex.jobStateIndexWriteAlias();
            Persistable persistable = new Persistable(indexOrAlias, quantiles.getJobId(), (ToXContent)quantiles, quantilesDocId);
            persistable.setRefreshPolicy(refreshPolicy);
            persistable.persistWithoutRetries(listener, AnomalyDetectorsIndex.jobStateIndexWriteAlias().equals(indexOrAlias));
        }, arg_0 -> listener.onFailure(arg_0));
        SearchRequest searchRequest = JobResultsPersister.buildQuantilesDocIdSearch(quantilesDocId);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)searchFormerQuantilesDocListener, (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    private static SearchRequest buildQuantilesDocIdSearch(String quantilesDocId) {
        return new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).allowPartialSearchResults(false).source(new SearchSourceBuilder().size(1).fetchSource(false).trackTotalHits(false).query((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{quantilesDocId}))));
    }

    public BulkResponse persistModelSnapshot(ModelSnapshot modelSnapshot, WriteRequest.RefreshPolicy refreshPolicy, Supplier<Boolean> shouldRetry) {
        Persistable persistable = new Persistable(AnomalyDetectorsIndex.resultsWriteAlias((String)modelSnapshot.getJobId()), modelSnapshot.getJobId(), (ToXContent)modelSnapshot, ModelSnapshot.documentId((ModelSnapshot)modelSnapshot));
        persistable.setRefreshPolicy(refreshPolicy);
        return persistable.persist(shouldRetry, true);
    }

    public void persistModelSizeStats(ModelSizeStats modelSizeStats, Supplier<Boolean> shouldRetry) {
        String jobId = modelSizeStats.getJobId();
        logger.trace("[{}] Persisting model size stats, for size {}", (Object)jobId, (Object)modelSizeStats.getModelBytes());
        Persistable persistable = new Persistable(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId), jobId, (ToXContent)modelSizeStats, modelSizeStats.getId());
        persistable.persist(shouldRetry, true);
    }

    public void persistModelSizeStatsWithoutRetries(ModelSizeStats modelSizeStats, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DocWriteResponse> listener) {
        String jobId = modelSizeStats.getJobId();
        logger.trace("[{}] Persisting model size stats, for size {}", (Object)jobId, (Object)modelSizeStats.getModelBytes());
        Persistable persistable = new Persistable(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId), jobId, (ToXContent)modelSizeStats, modelSizeStats.getId());
        persistable.setRefreshPolicy(refreshPolicy);
        persistable.persistWithoutRetries(listener, true);
    }

    public void deleteInterimResults(String jobId) {
        new JobDataDeleter((Client)this.client, jobId).deleteInterimResults();
    }

    public void commitWrites(String jobId, CommitType commitType) {
        this.commitWrites(jobId, EnumSet.of(commitType));
    }

    public void commitWrites(String jobId, Set<CommitType> commitTypes) {
        if (commitTypes.isEmpty()) {
            return;
        }
        ArrayList<String> indexNames = new ArrayList<String>();
        if (commitTypes.contains((Object)CommitType.RESULTS)) {
            indexNames.add(AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId));
        }
        if (commitTypes.contains((Object)CommitType.STATE)) {
            indexNames.add(AnomalyDetectorsIndex.jobStateIndexPattern());
        }
        if (commitTypes.contains((Object)CommitType.ANNOTATIONS)) {
            indexNames.add(".ml-annotations-read");
        }
        logger.trace("[{}] ES API CALL: refresh indices {}", (Object)jobId, indexNames);
        RefreshRequest refreshRequest = new RefreshRequest((String[])indexNames.toArray(String[]::new));
        refreshRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            this.client.admin().indices().refresh(refreshRequest).actionGet();
        }
        logger.trace("[{}] ES API CALL: finished refresh indices {}", (Object)jobId, indexNames);
    }

    public void persistDatafeedTimingStats(DatafeedTimingStats timingStats, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<BulkResponse> listener) {
        String jobId = timingStats.getJobId();
        logger.trace("[{}] Persisting datafeed timing stats", (Object)jobId);
        Persistable persistable = new Persistable(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId), jobId, (ToXContent)timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true")), DatafeedTimingStats.documentId((String)timingStats.getJobId()));
        persistable.setRefreshPolicy(refreshPolicy);
        persistable.persist(() -> true, true, listener);
    }

    private static XContentBuilder toXContentBuilder(ToXContent obj, ToXContent.Params params) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        obj.toXContent(builder, params);
        return builder;
    }

    public class Builder {
        private final Map<String, IndexRequest> items = new LinkedHashMap<String, IndexRequest>();
        private final String jobId;
        private final String indexName;
        private final Supplier<Boolean> shouldRetry;

        private Builder(String jobId, Supplier<Boolean> shouldRetry) {
            this.jobId = Objects.requireNonNull(jobId);
            this.indexName = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
            this.shouldRetry = shouldRetry;
        }

        public synchronized Builder persistBucket(Bucket bucket) {
            Bucket bucketWithoutRecords = bucket;
            if (!bucketWithoutRecords.getRecords().isEmpty()) {
                bucketWithoutRecords = new Bucket(bucket);
                bucketWithoutRecords.setRecords(Collections.emptyList());
            }
            String id = bucketWithoutRecords.getId();
            logger.trace("[{}] ES API CALL: index bucket to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)id);
            this.indexResult(id, (ToXContent)bucketWithoutRecords, "bucket");
            this.persistBucketInfluencersStandalone(this.jobId, bucketWithoutRecords.getBucketInfluencers());
            return this;
        }

        private synchronized void persistBucketInfluencersStandalone(String jobId, List<BucketInfluencer> bucketInfluencers) {
            if (bucketInfluencers != null && !bucketInfluencers.isEmpty()) {
                for (BucketInfluencer bucketInfluencer : bucketInfluencers) {
                    String id = bucketInfluencer.getId();
                    logger.trace("[{}] ES BULK ACTION: index bucket influencer to index [{}] with ID [{}]", (Object)jobId, (Object)this.indexName, (Object)id);
                    this.indexResult(id, (ToXContent)bucketInfluencer, "bucket influencer");
                }
            }
        }

        public synchronized Builder persistTimingStats(TimingStats timingStats) {
            this.indexResult(TimingStats.documentId((String)timingStats.getJobId()), (ToXContent)timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true")), TimingStats.TYPE.getPreferredName());
            return this;
        }

        public synchronized Builder persistRecords(List<AnomalyRecord> records) {
            for (AnomalyRecord record : records) {
                logger.trace("[{}] ES BULK ACTION: index record to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)record.getId());
                this.indexResult(record.getId(), (ToXContent)record, "record");
            }
            return this;
        }

        public synchronized Builder persistInfluencers(List<Influencer> influencers) {
            for (Influencer influencer : influencers) {
                logger.trace("[{}] ES BULK ACTION: index influencer to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)influencer.getId());
                this.indexResult(influencer.getId(), (ToXContent)influencer, "influencer");
            }
            return this;
        }

        public synchronized Builder persistModelPlot(ModelPlot modelPlot) {
            logger.trace("[{}] ES BULK ACTION: index model plot to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)modelPlot.getId());
            this.indexResult(modelPlot.getId(), (ToXContent)modelPlot, "model plot");
            return this;
        }

        public synchronized Builder persistCategorizerStats(CategorizerStats categorizerStats) {
            logger.trace("[{}] ES BULK ACTION: index categorizer stats to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)categorizerStats.getId());
            this.indexResult(categorizerStats.getId(), (ToXContent)categorizerStats, "categorizer stats");
            return this;
        }

        public synchronized Builder persistCategoryDefinition(CategoryDefinition categoryDefinition) {
            logger.trace("[{}] ES BULK ACTION: index category definition to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)categoryDefinition.getId());
            this.indexResult(categoryDefinition.getId(), (ToXContent)categoryDefinition, "category definition");
            return this;
        }

        public synchronized Builder persistModelSizeStats(ModelSizeStats modelSizeStats) {
            logger.trace("[{}] ES BULK ACTION: index model size stats to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)modelSizeStats.getId());
            this.indexResult(modelSizeStats.getId(), (ToXContent)modelSizeStats, "model size stats");
            return this;
        }

        public synchronized Builder persistForecast(Forecast forecast) {
            logger.trace("[{}] ES BULK ACTION: index forecast to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)forecast.getId());
            this.indexResult(forecast.getId(), (ToXContent)forecast, "model_forecast");
            return this;
        }

        public synchronized Builder persistForecastRequestStats(ForecastRequestStats forecastRequestStats) {
            logger.trace("[{}] ES BULK ACTION: index forecast request stats to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)forecastRequestStats.getId());
            this.indexResult(forecastRequestStats.getId(), (ToXContent)forecastRequestStats, "forecast request stats");
            return this;
        }

        private void indexResult(String id, ToXContent resultDoc, String resultType) {
            this.indexResult(id, resultDoc, ToXContent.EMPTY_PARAMS, resultType);
        }

        private void indexResult(String id, ToXContent resultDoc, ToXContent.Params params, String resultType) {
            try (XContentBuilder content = JobResultsPersister.toXContentBuilder(resultDoc, params);){
                this.items.put(id, new IndexRequest(this.indexName).id(id).source(content));
            }
            catch (IOException e) {
                logger.error(() -> Strings.format((String)"[%s] Error serialising %s", (Object[])new Object[]{this.jobId, resultType}), (Throwable)e);
            }
            if (this.items.size() >= 10000) {
                this.executeRequest();
            }
        }

        public synchronized void executeRequest() {
            if (this.items.isEmpty()) {
                return;
            }
            logger.trace("[{}] ES API CALL: bulk request with {} actions", (Object)this.jobId, (Object)this.items.size());
            JobResultsPersister.this.resultsPersisterService.bulkIndexWithRetry(this.buildBulkRequest(), this.jobId, this.shouldRetry, retryMessage -> logger.debug("[{}] Bulk indexing of results failed {}", (Object)this.jobId, retryMessage));
            this.clear();
        }

        private BulkRequest buildBulkRequest() {
            BulkRequest bulkRequest = new BulkRequest();
            for (IndexRequest item : this.items.values()) {
                bulkRequest.add(item);
            }
            return bulkRequest;
        }

        public synchronized void clear() {
            this.items.clear();
        }

        synchronized BulkRequest getBulkRequest() {
            return this.buildBulkRequest();
        }
    }

    private class Persistable {
        private final String indexName;
        private final String jobId;
        private final ToXContent object;
        private final ToXContent.Params params;
        private final String id;
        private WriteRequest.RefreshPolicy refreshPolicy;

        Persistable(String indexName, String jobId, ToXContent object, String id) {
            this(indexName, jobId, object, ToXContent.EMPTY_PARAMS, id);
        }

        Persistable(String indexName, String jobId, ToXContent object, ToXContent.Params params, String id) {
            this.indexName = indexName;
            this.jobId = jobId;
            this.object = object;
            this.params = params;
            this.id = id;
            this.refreshPolicy = WriteRequest.RefreshPolicy.NONE;
        }

        void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
        }

        BulkResponse persist(Supplier<Boolean> shouldRetry, boolean requireAlias) {
            PlainActionFuture getResponseFuture = PlainActionFuture.newFuture();
            this.persist(shouldRetry, requireAlias, (ActionListener<BulkResponse>)getResponseFuture);
            return (BulkResponse)getResponseFuture.actionGet();
        }

        void persist(Supplier<Boolean> shouldRetry, boolean requireAlias, ActionListener<BulkResponse> listener) {
            this.logCall();
            try {
                JobResultsPersister.this.resultsPersisterService.indexWithRetry(this.jobId, this.indexName, this.object, this.params, this.refreshPolicy, this.id, requireAlias, shouldRetry, retryMessage -> logger.debug("[{}] {} {}", (Object)this.jobId, (Object)this.id, retryMessage), listener);
            }
            catch (IOException e) {
                logger.error(() -> Strings.format((String)"[%s] Error writing [%s]", (Object[])new Object[]{this.jobId, this.id == null ? "auto-generated ID" : this.id}), (Throwable)e);
                IndexResponse.Builder notCreatedResponse = new IndexResponse.Builder();
                notCreatedResponse.setResult(DocWriteResponse.Result.NOOP);
                listener.onResponse((Object)new BulkResponse(new BulkItemResponse[]{BulkItemResponse.success((int)0, (DocWriteRequest.OpType)DocWriteRequest.OpType.INDEX, (DocWriteResponse)notCreatedResponse.build())}, 0L));
            }
        }

        void persistWithoutRetries(ActionListener<DocWriteResponse> listener, boolean requireAlias) {
            this.logCall();
            try (XContentBuilder content = JobResultsPersister.toXContentBuilder(this.object, this.params);){
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest(this.indexName).id(this.id).source(content).setRefreshPolicy(this.refreshPolicy)).setRequireAlias(requireAlias);
                ClientHelper.executeAsyncWithOrigin((ThreadContext)JobResultsPersister.this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)indexRequest, listener, (arg_0, arg_1) -> ((OriginSettingClient)JobResultsPersister.this.client).index(arg_0, arg_1));
            }
            catch (IOException e) {
                logger.error(() -> Strings.format((String)"[%s] Error writing [%s]", (Object[])new Object[]{this.jobId, this.id == null ? "auto-generated ID" : this.id}), (Throwable)e);
                IndexResponse.Builder notCreatedResponse = new IndexResponse.Builder();
                notCreatedResponse.setResult(DocWriteResponse.Result.NOOP);
                listener.onResponse((Object)notCreatedResponse.build());
            }
        }

        private void logCall() {
            if (logger.isTraceEnabled()) {
                if (this.id != null) {
                    logger.trace("[{}] ES API CALL: to index {} with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)this.id);
                } else {
                    logger.trace("[{}] ES API CALL: to index {} with auto-generated ID", (Object)this.jobId, (Object)this.indexName);
                }
            }
        }
    }

    public static enum CommitType {
        RESULTS,
        STATE,
        ANNOTATIONS;

    }
}

