/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class JobConfigProvider {
    private static final Logger logger = LogManager.getLogger(JobConfigProvider.class);
    public static final Map<String, String> TO_XCONTENT_PARAMS = Collections.singletonMap("for_internal_storage", "true");
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public JobConfigProvider(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void putJob(Job job, ActionListener<DocWriteResponse> listener) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder source = job.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(MlConfigIndex.indexName()).id(Job.documentId((String)job.getId())).source(source).opType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                    listener.onFailure((Exception)ExceptionsHelper.jobAlreadyExists((String)job.getId()));
                } else {
                    listener.onFailure(e);
                }
            }));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)new ElasticsearchParseException("Failed to serialise job with id [" + job.getId() + "]", (Throwable)e2, new Object[0]));
        }
    }

    public void getJob(final String jobId, @Nullable TaskId parentTaskId, final ActionListener<Job.Builder> jobListener) {
        GetRequest getRequest = new GetRequest(MlConfigIndex.indexName(), Job.documentId((String)jobId));
        if (parentTaskId != null) {
            getRequest.setParentTask(parentTaskId);
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (!getResponse.isExists()) {
                    jobListener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                    return;
                }
                BytesReference source = getResponse.getSourceAsBytesRef();
                JobConfigProvider.this.parseJobLenientlyFromSource(source, (ActionListener<Job.Builder>)jobListener);
            }

            public void onFailure(Exception e) {
                if (e.getClass() == IndexNotFoundException.class) {
                    jobListener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                } else {
                    jobListener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }

    public void deleteJob(String jobId, boolean errorIfMissing, ActionListener<DeleteResponse> actionListener) {
        DeleteRequest request = new DeleteRequest(MlConfigIndex.indexName(), Job.documentId((String)jobId));
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteAction.INSTANCE, (ActionRequest)request, (ActionListener)actionListener.delegateFailure((l, deleteResponse) -> {
            if (errorIfMissing) {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                    return;
                }
                assert (deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
            }
            l.onResponse(deleteResponse);
        }));
    }

    public void updateJob(final String jobId, final JobUpdate update, final ByteSizeValue maxModelMemoryLimit, ActionListener<Job> updatedJobListener) {
        GetRequest getRequest = new GetRequest(MlConfigIndex.indexName(), Job.documentId((String)jobId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new DelegatingActionListener<GetResponse, Job>(updatedJobListener){

            public void onResponse(GetResponse getResponse) {
                Job updatedJob;
                Job.Builder jobBuilder;
                if (!getResponse.isExists()) {
                    this.delegate.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                    return;
                }
                long seqNo = getResponse.getSeqNo();
                long primaryTerm = getResponse.getPrimaryTerm();
                BytesReference source = getResponse.getSourceAsBytesRef();
                try {
                    jobBuilder = JobConfigProvider.this.parseJobLenientlyFromSource(source);
                }
                catch (IOException e) {
                    this.delegate.onFailure((Exception)new ElasticsearchParseException("Failed to parse job configuration [" + jobId + "]", (Throwable)e, new Object[0]));
                    return;
                }
                try {
                    updatedJob = update.mergeWithJob(jobBuilder.build(), maxModelMemoryLimit);
                }
                catch (Exception e) {
                    this.delegate.onFailure(e);
                    return;
                }
                JobConfigProvider.this.indexUpdatedJob(updatedJob, seqNo, primaryTerm, (ActionListener<Job>)this.delegate);
            }
        });
    }

    public void updateJobWithValidation(String jobId, JobUpdate update, ByteSizeValue maxModelMemoryLimit, UpdateValidator validator, ActionListener<Job> listener) {
        GetRequest getRequest = new GetRequest(MlConfigIndex.indexName(), Job.documentId((String)jobId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
            Job originalJob;
            if (!getResponse.isExists()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                return;
            }
            long seqNo = getResponse.getSeqNo();
            long primaryTerm = getResponse.getPrimaryTerm();
            BytesReference source = getResponse.getSourceAsBytesRef();
            try {
                originalJob = this.parseJobLenientlyFromSource(source).build();
            }
            catch (Exception e) {
                listener.onFailure((Exception)new ElasticsearchParseException("Failed to parse job configuration [" + jobId + "]", (Throwable)e, new Object[0]));
                return;
            }
            validator.validate(originalJob, update, (ActionListener<Void>)ActionListener.wrap(validated -> {
                Job updatedJob;
                try {
                    updatedJob = update.mergeWithJob(originalJob, maxModelMemoryLimit);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return;
                }
                this.indexUpdatedJob(updatedJob, seqNo, primaryTerm, listener);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void indexUpdatedJob(Job updatedJob, long seqNo, long primaryTerm, ActionListener<Job> updatedJobListener) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder updatedSource = updatedJob.toXContent(builder, ToXContent.EMPTY_PARAMS);
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(MlConfigIndex.indexName()).id(Job.documentId((String)updatedJob.getId())).source(updatedSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            indexRequest.setIfSeqNo(seqNo);
            indexRequest.setIfPrimaryTerm(primaryTerm);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(indexResponse -> {
                assert (indexResponse.getResult() == DocWriteResponse.Result.UPDATED);
                updatedJobListener.onResponse((Object)updatedJob);
            }, arg_0 -> updatedJobListener.onFailure(arg_0)));
        }
        catch (IOException e) {
            updatedJobListener.onFailure((Exception)new ElasticsearchParseException("Failed to serialise job with id [" + updatedJob.getId() + "]", (Throwable)e, new Object[0]));
        }
    }

    public void jobExists(String jobId, boolean errorIfMissing, @Nullable TaskId parentTaskId, ActionListener<Boolean> listener) {
        GetRequest getRequest = new GetRequest(MlConfigIndex.indexName(), Job.documentId((String)jobId));
        getRequest.fetchSourceContext(FetchSourceContext.DO_NOT_FETCH_SOURCE);
        if (parentTaskId != null) {
            getRequest.setParentTask(parentTaskId);
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
            if (!getResponse.isExists()) {
                if (errorIfMissing) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                } else {
                    listener.onResponse((Object)Boolean.FALSE);
                }
            } else {
                listener.onResponse((Object)Boolean.TRUE);
            }
        }, e -> {
            if (e.getClass() == IndexNotFoundException.class) {
                if (errorIfMissing) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)jobId)));
                } else {
                    listener.onResponse((Object)Boolean.FALSE);
                }
            } else {
                listener.onFailure(e);
            }
        }));
    }

    public void jobIdMatches(List<String> ids, ActionListener<List<String>> listener) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(Job.JOB_TYPE.getPreferredName(), "anomaly_detector"));
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder(Job.ID.getPreferredName(), ids));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.fetchSource(false);
        sourceBuilder.docValueField(Job.ID.getPreferredName(), null);
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlConfigIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(ids.size()).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits = response.getHits().getHits();
            ArrayList<String> matchedIds = new ArrayList<String>();
            for (SearchHit hit : hits) {
                matchedIds.add((String)hit.field(Job.ID.getPreferredName()).getValue());
            }
            listener.onResponse(matchedIds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void updateJobBlockReason(String jobId, Blocked blocked, ActionListener<PutJobAction.Response> listener) {
        JobUpdate jobUpdate = new JobUpdate.Builder(jobId).setBlocked(blocked).build();
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)UpdateJobAction.INSTANCE, (ActionRequest)UpdateJobAction.Request.internal((String)jobId, (JobUpdate)jobUpdate), listener);
    }

    public void updateJobAfterReset(String jobId, ActionListener<PutJobAction.Response> listener) {
        JobUpdate jobUpdate = new JobUpdate.Builder(jobId).setModelSnapshotId(ModelSnapshot.EMPTY_SNAPSHOT_ID).setBlocked(Blocked.none()).setClearFinishTime(true).build();
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)UpdateJobAction.INSTANCE, (ActionRequest)UpdateJobAction.Request.internal((String)jobId, (JobUpdate)jobUpdate), listener);
    }

    public void expandJobsIds(String expression, boolean allowNoMatch, boolean excludeDeleting, @Nullable PersistentTasksCustomMetadata tasksCustomMetadata, boolean allowMissingConfigs, @Nullable TaskId parentTaskId, ActionListener<SortedSet<String>> listener) {
        String[] tokens = ExpandedIdsMatcher.tokenizeExpression((String)expression);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(JobConfigProvider.buildJobWildcardQuery(tokens, excludeDeleting));
        sourceBuilder.sort(Job.ID.getPreferredName());
        sourceBuilder.fetchSource(false);
        sourceBuilder.docValueField(Job.ID.getPreferredName(), null);
        sourceBuilder.docValueField(Job.GROUPS.getPreferredName(), null);
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlConfigIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(10000).request();
        if (parentTaskId != null) {
            searchRequest.setParentTask(parentTaskId);
        }
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, allowNoMatch);
        Collection<String> openMatchingJobs = JobConfigProvider.matchingJobIdsWithTasks(tokens, tasksCustomMetadata);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            TreeSet<String> jobIds = new TreeSet<String>();
            TreeSet<String> groupsIds = new TreeSet<String>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                jobIds.add((String)hit.field(Job.ID.getPreferredName()).getValue());
                List groups = hit.field(Job.GROUPS.getPreferredName()).getValues();
                if (groups == null) continue;
                groupsIds.addAll(groups.stream().map(Object::toString).toList());
            }
            if (allowMissingConfigs) {
                jobIds.addAll(openMatchingJobs);
            }
            groupsIds.addAll(jobIds);
            requiredMatches.filterMatchedIds(groupsIds);
            if (requiredMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)requiredMatches.unmatchedIdsString())));
                return;
            }
            listener.onResponse(jobIds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void expandJobs(String expression, boolean allowNoMatch, boolean excludeDeleting, @Nullable TaskId parentTaskId, ActionListener<List<Job.Builder>> listener) {
        String[] tokens = ExpandedIdsMatcher.tokenizeExpression((String)expression);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(JobConfigProvider.buildJobWildcardQuery(tokens, excludeDeleting));
        sourceBuilder.sort(Job.ID.getPreferredName());
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlConfigIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(10000).request();
        if (parentTaskId != null) {
            searchRequest.setParentTask(parentTaskId);
        }
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, allowNoMatch);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            ArrayList<Job.Builder> jobs = new ArrayList<Job.Builder>();
            HashSet<String> jobAndGroupIds = new HashSet<String>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                try {
                    BytesReference source = hit.getSourceRef();
                    Job.Builder job = this.parseJobLenientlyFromSource(source);
                    jobs.add(job);
                    jobAndGroupIds.add(job.getId());
                    jobAndGroupIds.addAll(job.getGroups());
                }
                catch (IOException e) {
                    logger.error("Error parsing anomaly detector job configuration [" + hit.getId() + "]", (Throwable)e);
                }
            }
            requiredMatches.filterMatchedIds(jobAndGroupIds);
            if (requiredMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingJobException((String)requiredMatches.unmatchedIdsString())));
                return;
            }
            listener.onResponse(jobs);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void expandGroupIds(List<String> groupIds, ActionListener<SortedSet<String>> listener) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)new TermsQueryBuilder(Job.GROUPS.getPreferredName(), groupIds));
        sourceBuilder.sort(Job.ID.getPreferredName(), SortOrder.DESC);
        sourceBuilder.fetchSource(false);
        sourceBuilder.docValueField(Job.ID.getPreferredName(), null);
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlConfigIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(10000).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            TreeSet<String> jobIds = new TreeSet<String>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                jobIds.add((String)hit.field(Job.ID.getPreferredName()).getValue());
            }
            listener.onResponse(jobIds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void groupExists(String groupId, ActionListener<Boolean> listener) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(Job.JOB_TYPE.getPreferredName(), "anomaly_detector"));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(Job.GROUPS.getPreferredName(), groupId));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.fetchSource(false);
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlConfigIndex.indexName()}).setSize(0).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)(response.getHits().getTotalHits().value > 0L ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void findJobsWithCustomRules(ActionListener<List<Job>> listener) {
        String customRulesPath = Strings.collectionToDelimitedString(Arrays.asList(Job.ANALYSIS_CONFIG.getPreferredName(), AnalysisConfig.DETECTORS.getPreferredName(), Detector.CUSTOM_RULES_FIELD.getPreferredName()), (String)".");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.nestedQuery((String)customRulesPath, (QueryBuilder)QueryBuilders.existsQuery((String)customRulesPath), (ScoreMode)ScoreMode.None));
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlConfigIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(10000).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                try {
                    BytesReference source = hit.getSourceRef();
                    Job job = this.parseJobLenientlyFromSource(source).build();
                    jobs.add(job);
                }
                catch (IOException e) {
                    logger.error("Error parsing anomaly detector job configuration [" + hit.getId() + "]", (Throwable)e);
                }
            }
            listener.onResponse(jobs);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void validateDatafeedJob(DatafeedConfig config, ActionListener<Boolean> listener) {
        this.getJob(config.getJobId(), null, (ActionListener<Job.Builder>)ActionListener.wrap(jobBuilder -> {
            try {
                DatafeedJobValidator.validate((DatafeedConfig)config, (Job)jobBuilder.build(), (NamedXContentRegistry)this.xContentRegistry);
                listener.onResponse((Object)Boolean.TRUE);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static Collection<String> matchingJobIdsWithTasks(String[] jobIdPatterns, PersistentTasksCustomMetadata tasksMetadata) {
        return MlStrings.findMatching((String[])jobIdPatterns, (Set)MlTasks.openJobIds((PersistentTasksCustomMetadata)tasksMetadata));
    }

    private void parseJobLenientlyFromSource(BytesReference source, ActionListener<Job.Builder> jobListener) {
        try (StreamInput stream = source.streamInput();
             XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (InputStream)stream);){
            jobListener.onResponse((Object)((Job.Builder)Job.LENIENT_PARSER.apply(parser, null)));
        }
        catch (Exception e) {
            jobListener.onFailure(e);
        }
    }

    private Job.Builder parseJobLenientlyFromSource(BytesReference source) throws IOException {
        try (StreamInput stream = source.streamInput();){
            Job.Builder builder;
            block12: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (InputStream)stream);
                try {
                    builder = (Job.Builder)Job.LENIENT_PARSER.apply(parser, null);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return builder;
        }
    }

    public static QueryBuilder buildJobWildcardQuery(String[] tokens, boolean excludeDeleting) {
        TermQueryBuilder jobQuery = new TermQueryBuilder(Job.JOB_TYPE.getPreferredName(), "anomaly_detector");
        if (Strings.isAllOrWildcard((String[])tokens) && !excludeDeleting) {
            return jobQuery;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)jobQuery);
        BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
        if (excludeDeleting) {
            shouldQueries.mustNot((QueryBuilder)new ExistsQueryBuilder(Job.DELETING.getPreferredName()));
            if (Strings.isAllOrWildcard((String[])tokens)) {
                boolQueryBuilder.filter((QueryBuilder)shouldQueries);
                return boolQueryBuilder;
            }
        }
        ArrayList<String> terms = new ArrayList<String>();
        for (String token : tokens) {
            if (Regex.isSimpleMatchPattern((String)token)) {
                shouldQueries.should((QueryBuilder)new WildcardQueryBuilder(Job.ID.getPreferredName(), token));
                shouldQueries.should((QueryBuilder)new WildcardQueryBuilder(Job.GROUPS.getPreferredName(), token));
                continue;
            }
            terms.add(token);
        }
        if (!terms.isEmpty()) {
            shouldQueries.should((QueryBuilder)new TermsQueryBuilder(Job.ID.getPreferredName(), terms));
            shouldQueries.should((QueryBuilder)new TermsQueryBuilder(Job.GROUPS.getPreferredName(), terms));
        }
        if (!shouldQueries.should().isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)shouldQueries);
        }
        return boolQueryBuilder;
    }

    @FunctionalInterface
    public static interface UpdateValidator {
        public void validate(Job var1, JobUpdate var2, ActionListener<Void> var3);
    }
}

