/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.assignment.planning;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.ml.inference.assignment.planning.AbstractPreserveAllocations;
import org.elasticsearch.xpack.ml.inference.assignment.planning.AssignmentPlan;

public class PreserveOneAllocation
extends AbstractPreserveAllocations {
    protected PreserveOneAllocation(List<AssignmentPlan.Node> nodes, List<AssignmentPlan.Deployment> deployments) {
        super(nodes, deployments);
    }

    @Override
    protected int calculateUsedCores(AssignmentPlan.Node n, AssignmentPlan.Deployment m) {
        return m.threadsPerAllocation();
    }

    @Override
    protected Map<String, Integer> calculateAllocationsPerNodeToPreserve(AssignmentPlan.Deployment m) {
        return m.currentAllocationsByNodeId().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)e.getValue() - 1));
    }

    @Override
    protected int calculatePreservedAllocations(AssignmentPlan.Deployment m) {
        return (int)m.currentAllocationsByNodeId().values().stream().filter(v -> v > 0).count();
    }

    @Override
    protected int addPreservedAllocations(AssignmentPlan.Node n, AssignmentPlan.Deployment m) {
        return 1;
    }
}

