/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.assignment.planning;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ml.inference.assignment.planning.AssignmentPlan;

abstract class AbstractPreserveAllocations {
    private final List<AssignmentPlan.Node> nodes;
    private final List<AssignmentPlan.Deployment> deployments;

    protected AbstractPreserveAllocations(List<AssignmentPlan.Node> nodes, List<AssignmentPlan.Deployment> deployments) {
        this.nodes = Objects.requireNonNull(nodes);
        this.deployments = Objects.requireNonNull(deployments);
    }

    List<AssignmentPlan.Node> nodesPreservingAllocations() {
        return this.nodes.stream().map(n -> this.modifyNodePreservingAllocations((AssignmentPlan.Node)n)).toList();
    }

    private AssignmentPlan.Node modifyNodePreservingAllocations(AssignmentPlan.Node n) {
        long bytesUsed = 0L;
        int coresUsed = 0;
        for (AssignmentPlan.Deployment m : this.deployments) {
            if (!m.currentAllocationsByNodeId().containsKey(n.id())) continue;
            bytesUsed += m.memoryBytes();
            coresUsed += this.calculateUsedCores(n, m);
        }
        return new AssignmentPlan.Node(n.id(), n.availableMemoryBytes() - bytesUsed, n.cores() - coresUsed);
    }

    List<AssignmentPlan.Deployment> modelsPreservingAllocations() {
        return this.deployments.stream().map(m -> this.modifyModelPreservingPreviousAssignments((AssignmentPlan.Deployment)m)).toList();
    }

    AssignmentPlan.Deployment modifyModelPreservingPreviousAssignments(AssignmentPlan.Deployment m) {
        if (m.currentAllocationsByNodeId().isEmpty()) {
            return m;
        }
        return new AssignmentPlan.Deployment(m.id(), m.memoryBytes(), m.allocations() - this.calculatePreservedAllocations(m), m.threadsPerAllocation(), this.calculateAllocationsPerNodeToPreserve(m), m.maxAssignedAllocations());
    }

    AssignmentPlan mergePreservedAllocations(AssignmentPlan assignmentPlan) {
        HashMap<Tuple, Integer> assignmentsByModelNodeIdPair = new HashMap<Tuple, Integer>();
        for (AssignmentPlan.Deployment m : assignmentPlan.models()) {
            Map assignments = assignmentPlan.assignments(m).orElse(Map.of());
            for (Map.Entry nodeAssignment : assignments.entrySet()) {
                assignmentsByModelNodeIdPair.put(Tuple.tuple((Object)m.id(), (Object)((AssignmentPlan.Node)nodeAssignment.getKey()).id()), (Integer)nodeAssignment.getValue());
            }
        }
        AssignmentPlan.Builder mergedPlanBuilder = AssignmentPlan.builder(this.nodes, this.deployments);
        for (AssignmentPlan.Deployment m : this.deployments) {
            for (AssignmentPlan.Node n : this.nodes) {
                int allocations = assignmentsByModelNodeIdPair.getOrDefault(Tuple.tuple((Object)m.id(), (Object)n.id()), 0);
                if (m.currentAllocationsByNodeId().containsKey(n.id())) {
                    allocations += this.addPreservedAllocations(n, m);
                    mergedPlanBuilder.accountMemory(m, n);
                }
                if (allocations <= 0) continue;
                mergedPlanBuilder.assignModelToNode(m, n, allocations);
            }
        }
        return mergedPlanBuilder.build();
    }

    protected abstract int calculateUsedCores(AssignmentPlan.Node var1, AssignmentPlan.Deployment var2);

    protected abstract Map<String, Integer> calculateAllocationsPerNodeToPreserve(AssignmentPlan.Deployment var1);

    protected abstract int calculatePreservedAllocations(AssignmentPlan.Deployment var1);

    protected abstract int addPreservedAllocations(AssignmentPlan.Node var1, AssignmentPlan.Deployment var2);
}

