/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.assignment;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelAssignmentRoutingInfoAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentState;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfo;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingStateAndReason;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlPlatformArchitecturesUtil;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.autoscaling.NodeAvailabilityZoneMapper;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentRebalancer;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentUtils;
import org.elasticsearch.xpack.ml.inference.assignment.planning.AllocationReducer;
import org.elasticsearch.xpack.ml.job.NodeLoad;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.notifications.SystemAuditor;

public class TrainedModelAssignmentClusterService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TrainedModelAssignmentClusterService.class);
    private static final TransportVersion RENAME_ALLOCATION_TO_ASSIGNMENT_TRANSPORT_VERSION = TransportVersions.V_8_3_0;
    public static final TransportVersion DISTRIBUTED_MODEL_ALLOCATION_TRANSPORT_VERSION = TransportVersions.V_8_4_0;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final NodeLoadDetector nodeLoadDetector;
    private final SystemAuditor systemAuditor;
    private final NodeAvailabilityZoneMapper nodeAvailabilityZoneMapper;
    private final Client client;
    private volatile int maxMemoryPercentage;
    private volatile boolean useAuto;
    private volatile int maxOpenJobs;
    protected volatile int maxLazyMLNodes;
    protected volatile long maxMLNodeSize;
    protected volatile int allocatedProcessorsScale;

    public TrainedModelAssignmentClusterService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeLoadDetector nodeLoadDetector, SystemAuditor systemAuditor, NodeAvailabilityZoneMapper nodeAvailabilityZoneMapper, Client client) {
        this.clusterService = Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.nodeLoadDetector = Objects.requireNonNull(nodeLoadDetector);
        this.systemAuditor = Objects.requireNonNull(systemAuditor);
        this.nodeAvailabilityZoneMapper = Objects.requireNonNull(nodeAvailabilityZoneMapper);
        this.maxMemoryPercentage = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
        this.useAuto = (Boolean)MachineLearningField.USE_AUTO_MACHINE_MEMORY_PERCENT.get(settings);
        this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
        this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
        this.maxMLNodeSize = ((ByteSizeValue)MachineLearning.MAX_ML_NODE_SIZE.get(settings)).getBytes();
        this.allocatedProcessorsScale = (Integer)MachineLearning.ALLOCATED_PROCESSORS_SCALE.get(settings);
        this.client = client;
        if (DiscoveryNode.isMasterNode((Settings)settings)) {
            clusterService.addListener((ClusterStateListener)this);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMemoryPercentage);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearningField.USE_AUTO_MACHINE_MEMORY_PERCENT, this::setUseAuto);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_ML_NODE_SIZE, this::setMaxMLNodeSize);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.ALLOCATED_PROCESSORS_SCALE, this::setAllocatedProcessorsScale);
        }
    }

    private void setMaxMemoryPercentage(int maxMemoryPercentage) {
        this.maxMemoryPercentage = maxMemoryPercentage;
    }

    private void setUseAuto(boolean useAuto) {
        this.useAuto = useAuto;
    }

    private void setMaxOpenJobs(int maxOpenJobs) {
        this.maxOpenJobs = maxOpenJobs;
    }

    private void setMaxLazyMLNodes(int value) {
        this.maxLazyMLNodes = value;
    }

    private void setMaxMLNodeSize(ByteSizeValue value) {
        this.maxMLNodeSize = value.getBytes();
    }

    private void setAllocatedProcessorsScale(int scale) {
        this.allocatedProcessorsScale = scale;
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        Optional<String> rebalanceReason;
        if (this.eventStateHasGlobalBlockStateNotRecoveredBlock(event)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        if (this.eventStateMinTransportVersionIsBeforeDistributedModelAllocationTransportVersion(event)) {
            this.removeRoutingToRemovedOrShuttingDownNodes(event);
            return;
        }
        if (event.nodesAdded()) {
            this.logMlNodeHeterogeneity();
        }
        if ((rebalanceReason = TrainedModelAssignmentClusterService.detectReasonToRebalanceModels(event)).isPresent()) {
            this.rebalanceAssignments(event.state(), Optional.empty(), rebalanceReason.get(), (ActionListener<TrainedModelAssignmentMetadata>)ActionListener.wrap(newMetadata -> logger.debug(() -> Strings.format((String)"rebalanced model assignments [%s]", (Object[])new Object[]{org.elasticsearch.common.Strings.toString((ChunkedToXContent)newMetadata, (boolean)false, (boolean)true)})), e -> logger.warn("failed to rebalance models", (Throwable)e)));
        }
    }

    boolean eventStateMinTransportVersionIsBeforeDistributedModelAllocationTransportVersion(ClusterChangedEvent event) {
        return event.state().getMinTransportVersion().before((VersionId)DISTRIBUTED_MODEL_ALLOCATION_TRANSPORT_VERSION);
    }

    boolean eventStateHasGlobalBlockStateNotRecoveredBlock(ClusterChangedEvent event) {
        return event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
    }

    void logMlNodeHeterogeneity() {
        ActionListener<Set<String>> architecturesListener = TrainedModelAssignmentClusterService.getArchitecturesSetActionListener();
        MlPlatformArchitecturesUtil.getMlNodesArchitecturesSet(architecturesListener, (Client)this.client, (ExecutorService)this.threadPool.executor("ml_utility"));
    }

    static ActionListener<Set<String>> getArchitecturesSetActionListener() {
        ActionListener<Set<String>> architecturesListener = new ActionListener<Set<String>>(){

            public void onResponse(Set<String> architectures) {
                if (architectures.size() > 1) {
                    logger.warn(Strings.format((String)"Heterogeneous platform architectures were detected among ML nodes. This will prevent the deployment of some trained models. Distinct platform architectures detected: %s", (Object[])new Object[]{architectures}));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to detect heterogeneity among ML nodes with exception: ", (Throwable)e);
            }
        };
        return architecturesListener;
    }

    private void removeRoutingToRemovedOrShuttingDownNodes(ClusterChangedEvent event) {
        if (TrainedModelAssignmentClusterService.areAssignedNodesRemoved(event)) {
            this.submitUnbatchedTask("removing routing entries for removed or shutting down nodes", new ClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) {
                    return TrainedModelAssignmentClusterService.removeRoutingToUnassignableNodes(currentState);
                }

                public void onFailure(Exception e) {
                    logger.error("could not remove routing entries for removed or shutting down nodes", (Throwable)e);
                }

                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    logger.debug(() -> Strings.format((String)"updated model assignments based on node changes in the cluster; new metadata [%s]", (Object[])new Object[]{org.elasticsearch.common.Strings.toString((ChunkedToXContent)TrainedModelAssignmentMetadata.fromState(newState), (boolean)false, (boolean)true)}));
                }
            });
        }
    }

    static boolean areAssignedNodesRemoved(ClusterChangedEvent event) {
        boolean nodesShutdownChanged = event.changedCustomMetadataSet().contains("node_shutdown");
        if (event.nodesRemoved() || nodesShutdownChanged) {
            HashSet<String> removedOrShuttingDownNodeIds = new HashSet<String>(TrainedModelAssignmentClusterService.nodesShuttingDown(event.state()));
            event.nodesDelta().removedNodes().stream().map(DiscoveryNode::getId).forEach(removedOrShuttingDownNodeIds::add);
            TrainedModelAssignmentMetadata metadata = TrainedModelAssignmentMetadata.fromState(event.state());
            for (TrainedModelAssignment assignment : metadata.allAssignments().values()) {
                if (Sets.intersection(removedOrShuttingDownNodeIds, assignment.getNodeRoutingTable().keySet()).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    static ClusterState removeRoutingToUnassignableNodes(ClusterState currentState) {
        Set assignableNodes = TrainedModelAssignmentClusterService.getAssignableNodes(currentState).stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        TrainedModelAssignmentMetadata metadata = TrainedModelAssignmentMetadata.fromState(currentState);
        TrainedModelAssignmentMetadata.Builder builder = TrainedModelAssignmentMetadata.builder(currentState);
        Set shuttingDownNodes = currentState.metadata().nodeShutdowns().getAllNodeIds();
        for (TrainedModelAssignment assignment : metadata.allAssignments().values()) {
            Set routedNodeIdsToRemove = Sets.difference(assignment.getNodeRoutingTable().keySet(), assignableNodes);
            if (routedNodeIdsToRemove.isEmpty()) continue;
            logger.debug(() -> Strings.format((String)"[%s] removing routing entries to nodes %s because they have been removed or are shutting down", (Object[])new Object[]{assignment.getDeploymentId(), routedNodeIdsToRemove}));
            TrainedModelAssignment.Builder assignmentBuilder = TrainedModelAssignmentClusterService.removeRoutingBuilder(routedNodeIdsToRemove, shuttingDownNodes, assignment);
            builder.updateAssignment(assignment.getDeploymentId(), assignmentBuilder.calculateAndSetAssignmentState());
        }
        return TrainedModelAssignmentClusterService.update(currentState, builder);
    }

    private static TrainedModelAssignment.Builder removeRoutingBuilder(Set<String> nodeIds, Set<String> shuttingDownNodes, TrainedModelAssignment assignment) {
        TrainedModelAssignment.Builder assignmentBuilder = TrainedModelAssignment.Builder.fromAssignment((TrainedModelAssignment)assignment);
        for (String nodeIdToRemove : nodeIds) {
            RoutingInfo routingInfoToRemove = (RoutingInfo)assignment.getNodeRoutingTable().get(nodeIdToRemove);
            if (!shuttingDownNodes.contains(nodeIdToRemove)) {
                logger.debug(() -> Strings.format((String)"[%s] Removing route for unassignable node id [%s]", (Object[])new Object[]{assignment.getDeploymentId(), nodeIdToRemove}));
                assignmentBuilder.removeRoutingEntry(nodeIdToRemove);
                continue;
            }
            if (routingInfoToRemove == null || !routingInfoToRemove.getState().isAnyOf(new RoutingState[]{RoutingState.STARTED, RoutingState.STARTING})) continue;
            logger.debug(() -> Strings.format((String)"[%s] Found assignment with route to shutting down node id [%s], adding stopping route", (Object[])new Object[]{assignment.getDeploymentId(), nodeIdToRemove}));
            RoutingInfo stoppingRouteInfo = TrainedModelAssignmentUtils.createShuttingDownRoute((RoutingInfo)assignment.getNodeRoutingTable().get(nodeIdToRemove));
            assignmentBuilder.addOrOverwriteRoutingEntry(nodeIdToRemove, stoppingRouteInfo);
        }
        return assignmentBuilder;
    }

    public void updateModelRoutingTable(final UpdateTrainedModelAssignmentRoutingInfoAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> Strings.format((String)"[%s] updating routing table entry for node [%s], update [%s]", (Object[])new Object[]{request.getDeploymentId(), request.getNodeId(), request.getUpdate()}));
        this.submitUnbatchedTask("updating model routing for node assignment", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return TrainedModelAssignmentClusterService.updateModelRoutingTable(currentState, request);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    public void createNewModelAssignment(StartTrainedModelDeploymentAction.TaskParams params, ActionListener<TrainedModelAssignment> listener) {
        if (this.clusterService.state().getMinTransportVersion().before((VersionId)DISTRIBUTED_MODEL_ALLOCATION_TRANSPORT_VERSION)) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("cannot create new assignment [{}] for model [{}] while cluster upgrade is in progress", RestStatus.CONFLICT, new Object[]{params.getDeploymentId(), params.getModelId()})));
            return;
        }
        if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isResetMode()) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("cannot create new assignment [{}] for model [{}] while feature reset is in progress.", RestStatus.CONFLICT, new Object[]{params.getDeploymentId(), params.getModelId()})));
            return;
        }
        this.rebalanceAssignments(this.clusterService.state(), Optional.of(params), "model deployment started", (ActionListener<TrainedModelAssignmentMetadata>)ActionListener.wrap(newMetadata -> {
            TrainedModelAssignment assignment = newMetadata.getDeploymentAssignment(params.getDeploymentId());
            if (assignment == null) {
                assignment = TrainedModelAssignment.Builder.empty((StartTrainedModelDeploymentAction.TaskParams)params).build();
            }
            listener.onResponse((Object)assignment);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void setModelAssignmentToStopping(final String modelId, final ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("set model assignment stopping", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return TrainedModelAssignmentClusterService.setToStopping(currentState, modelId, "client API call");
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    public void removeModelAssignment(final String deploymentId, final ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("delete model deployment assignment", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return TrainedModelAssignmentClusterService.removeAssignment(currentState, deploymentId);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                TrainedModelAssignmentClusterService.this.rebalanceAssignments(newState, Optional.empty(), "model deployment stopped", (ActionListener<TrainedModelAssignmentMetadata>)ActionListener.wrap(metadataAfterRebalance -> logger.debug(() -> Strings.format((String)"Successfully rebalanced model deployments after deployment [%s] was stopped", (Object[])new Object[]{deploymentId})), e -> logger.error(Strings.format((String)"Failed to rebalance model deployments after deployment [%s] was stopped", (Object[])new Object[]{deploymentId}), (Throwable)e)));
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    public void removeAllModelAssignments(final ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("delete all model assignments", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return TrainedModelAssignmentClusterService.removeAllAssignments(currentState);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    private static ClusterState update(ClusterState currentState, TrainedModelAssignmentMetadata.Builder modelAssignments) {
        TrainedModelAssignmentMetadata previousMetadata = TrainedModelAssignmentMetadata.fromState(currentState);
        TrainedModelAssignmentMetadata updatedMetadata = modelAssignments.build();
        if (updatedMetadata.equals(previousMetadata)) {
            return currentState;
        }
        return TrainedModelAssignmentClusterService.forceUpdate(currentState, modelAssignments);
    }

    private static ClusterState forceUpdate(ClusterState currentState, TrainedModelAssignmentMetadata.Builder modelAssignments) {
        logger.debug(() -> Strings.format((String)"updated assignments: %s", (Object[])new Object[]{modelAssignments.build()}));
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        if (currentState.getMinTransportVersion().onOrAfter((VersionId)RENAME_ALLOCATION_TO_ASSIGNMENT_TRANSPORT_VERSION)) {
            metadata.putCustom("trained_model_assignment", (Metadata.Custom)modelAssignments.build()).removeCustom("trained_model_allocation");
        } else {
            metadata.putCustom("trained_model_allocation", (Metadata.Custom)modelAssignments.buildOld());
        }
        return ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
    }

    ClusterState createModelAssignment(ClusterState currentState, StartTrainedModelDeploymentAction.TaskParams params) throws Exception {
        return TrainedModelAssignmentClusterService.update(currentState, this.rebalanceAssignments(currentState, Optional.of(params)));
    }

    private void rebalanceAssignments(ClusterState clusterState, Optional<StartTrainedModelDeploymentAction.TaskParams> modelToAdd, String reason, ActionListener<TrainedModelAssignmentMetadata> listener) {
        ActionListener architecturesListener = ActionListener.wrap(mlNodesArchitectures -> this.threadPool.executor("ml_utility").execute(() -> {
            TrainedModelAssignmentMetadata.Builder rebalancedMetadata;
            logger.debug(() -> Strings.format((String)"Rebalancing model allocations because [%s]", (Object[])new Object[]{reason}));
            try {
                rebalancedMetadata = this.rebalanceAssignments(clusterState, modelToAdd);
            }
            catch (Exception e) {
                listener.onFailure(e);
                return;
            }
            this.submitUnbatchedTask(reason, new ClusterStateUpdateTask((Set)mlNodesArchitectures, modelToAdd, clusterState, rebalancedMetadata, reason, (ActionListener)listener){
                private volatile boolean isUpdated;
                private volatile boolean isChanged;
                final /* synthetic */ Set val$mlNodesArchitectures;
                final /* synthetic */ Optional val$modelToAdd;
                final /* synthetic */ ClusterState val$clusterState;
                final /* synthetic */ TrainedModelAssignmentMetadata.Builder val$rebalancedMetadata;
                final /* synthetic */ String val$reason;
                final /* synthetic */ ActionListener val$listener;
                {
                    this.val$mlNodesArchitectures = set;
                    this.val$modelToAdd = optional;
                    this.val$clusterState = clusterState;
                    this.val$rebalancedMetadata = builder;
                    this.val$reason = string;
                    this.val$listener = actionListener;
                }

                public ClusterState execute(ClusterState currentState) {
                    if (TrainedModelAssignmentClusterService.this.areClusterStatesCompatibleForRebalance(this.val$clusterState, currentState = TrainedModelAssignmentClusterService.this.stopPlatformSpecificModelsInHeterogeneousClusters(currentState, this.val$mlNodesArchitectures, this.val$modelToAdd, this.val$clusterState))) {
                        this.isUpdated = true;
                        ClusterState updatedState = TrainedModelAssignmentClusterService.update(currentState, this.val$rebalancedMetadata);
                        this.isChanged = updatedState != currentState;
                        return updatedState;
                    }
                    TrainedModelAssignmentClusterService.this.rebalanceAssignments(currentState, this.val$modelToAdd, this.val$reason, (ActionListener<TrainedModelAssignmentMetadata>)this.val$listener);
                    return currentState;
                }

                public void onFailure(Exception e) {
                    this.val$listener.onFailure(e);
                }

                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    if (this.isUpdated) {
                        if (this.isChanged) {
                            TrainedModelAssignmentClusterService.this.threadPool.executor("ml_utility").execute(() -> TrainedModelAssignmentClusterService.this.systemAuditor.info(Messages.getMessage((String)"Rebalanced trained model allocations because [{0}]", (Object[])new Object[]{this.val$reason})));
                        }
                        this.val$listener.onResponse((Object)TrainedModelAssignmentMetadata.fromState(newState));
                    }
                }
            });
        }), arg_0 -> listener.onFailure(arg_0));
        MlPlatformArchitecturesUtil.getMlNodesArchitecturesSet((ActionListener)architecturesListener, (Client)this.client, (ExecutorService)this.threadPool.executor("ml_utility"));
    }

    ClusterState stopPlatformSpecificModelsInHeterogeneousClusters(ClusterState updatedState, Set<String> mlNodesArchitectures, Optional<StartTrainedModelDeploymentAction.TaskParams> modelToAdd, ClusterState clusterState) {
        if (mlNodesArchitectures.size() > 1 && modelToAdd.isPresent()) {
            String reasonToStop = Strings.format((String)"ML nodes in this cluster have multiple platform architectures, but can only have one for this model ([%s]); detected architectures: %s", (Object[])new Object[]{modelToAdd.get().getModelId(), mlNodesArchitectures});
            updatedState = this.callSetToStopping(reasonToStop, modelToAdd.get().getDeploymentId(), clusterState);
        }
        return updatedState;
    }

    ClusterState callSetToStopping(String reasonToStop, String deploymentId, ClusterState clusterState) {
        return TrainedModelAssignmentClusterService.setToStopping(clusterState, deploymentId, reasonToStop);
    }

    private boolean areClusterStatesCompatibleForRebalance(ClusterState source, ClusterState target) {
        List<DiscoveryNode> targetNodes;
        List<DiscoveryNode> sourceNodes = TrainedModelAssignmentClusterService.getAssignableNodes(source);
        return sourceNodes.equals(targetNodes = TrainedModelAssignmentClusterService.getAssignableNodes(target)) && this.detectNodeLoads(sourceNodes, source).equals(this.detectNodeLoads(targetNodes, target)) && MlMetadata.getMlMetadata((ClusterState)source).equals((Object)MlMetadata.getMlMetadata((ClusterState)target)) && TrainedModelAssignmentMetadata.fromState(source).equals(TrainedModelAssignmentMetadata.fromState(target));
    }

    private TrainedModelAssignmentMetadata.Builder rebalanceAssignments(ClusterState currentState, Optional<StartTrainedModelDeploymentAction.TaskParams> modelToAdd) throws Exception {
        List<DiscoveryNode> nodes = TrainedModelAssignmentClusterService.getAssignableNodes(currentState);
        logger.debug(() -> Strings.format((String)"assignable nodes are %s", (Object[])new Object[]{nodes.stream().map(DiscoveryNode::getId).toList()}));
        Map<DiscoveryNode, NodeLoad> nodeLoads = this.detectNodeLoads(nodes, currentState);
        TrainedModelAssignmentMetadata currentMetadata = TrainedModelAssignmentMetadata.fromState(currentState);
        TrainedModelAssignmentRebalancer rebalancer = new TrainedModelAssignmentRebalancer(currentMetadata, nodeLoads, this.nodeAvailabilityZoneMapper.buildMlNodesByAvailabilityZone(currentState), modelToAdd, this.allocatedProcessorsScale);
        Set shuttingDownNodeIds = currentState.metadata().nodeShutdowns().getAllNodeIds();
        TrainedModelAssignmentMetadata.Builder rebalanced = TrainedModelAssignmentClusterService.setShuttingDownNodeRoutesToStopping(currentMetadata, shuttingDownNodeIds, rebalancer.rebalance());
        if (modelToAdd.isPresent()) {
            this.checkModelIsFullyAllocatedIfScalingIsNotPossible(modelToAdd.get().getDeploymentId(), rebalanced, nodes);
        }
        return rebalanced;
    }

    static TrainedModelAssignmentMetadata.Builder setShuttingDownNodeRoutesToStopping(TrainedModelAssignmentMetadata currentMetadata, Set<String> shuttingDownNodeIds, TrainedModelAssignmentMetadata.Builder builder) {
        if (shuttingDownNodeIds.isEmpty()) {
            return builder;
        }
        for (TrainedModelAssignment existingAssignment : currentMetadata.allAssignments().values()) {
            boolean foundShuttingDownNodeForAssignment = false;
            String existingDeploymentId = existingAssignment.getDeploymentId();
            TrainedModelAssignment.Builder assignmentBuilder = builder.hasModelDeployment(existingAssignment.getDeploymentId()) ? builder.getAssignment(existingDeploymentId) : TrainedModelAssignment.Builder.fromAssignment((TrainedModelAssignment)existingAssignment).stopAssignment("nodes changed").clearNodeRoutingTable();
            for (String nodeId : shuttingDownNodeIds) {
                if (!existingAssignment.isRoutedToNode(nodeId) || !((RoutingInfo)existingAssignment.getNodeRoutingTable().get(nodeId)).getState().isAnyOf(new RoutingState[]{RoutingState.STARTED, RoutingState.STARTING})) continue;
                logger.debug(() -> Strings.format((String)"Found assignment deployment id: [%s] with route to shutting down node id: [%s], adding stopping route", (Object[])new Object[]{existingDeploymentId, nodeId}));
                foundShuttingDownNodeForAssignment = true;
                RoutingInfo stoppingRouteInfo = TrainedModelAssignmentUtils.createShuttingDownRoute((RoutingInfo)existingAssignment.getNodeRoutingTable().get(nodeId));
                assignmentBuilder.addOrOverwriteRoutingEntry(nodeId, stoppingRouteInfo);
            }
            if (!foundShuttingDownNodeForAssignment) continue;
            builder.addOrOverwriteAssignment(existingDeploymentId, assignmentBuilder);
        }
        return builder;
    }

    private void checkModelIsFullyAllocatedIfScalingIsNotPossible(String modelId, TrainedModelAssignmentMetadata.Builder assignments, List<DiscoveryNode> nodes) {
        TrainedModelAssignment assignment = assignments.getAssignment(modelId).build();
        if (this.isScalingPossible(nodes) || assignment.isSatisfied(nodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet()))) {
            return;
        }
        if (assignment.getNodeRoutingTable().isEmpty()) {
            String msg = "Could not start deployment because no suitable nodes were found, allocation explanation [" + assignment.getReason().orElse("none") + "]";
            logger.warn("[{}] {}", (Object)modelId, (Object)msg);
            IllegalStateException detail = new IllegalStateException(msg);
            throw new ElasticsearchStatusException("Could not start deployment because no ML nodes with sufficient capacity were found", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
        }
        String msg = "Could not start deployment because there are not enough resources to provide all requested allocations";
        logger.debug(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{modelId, msg}));
        throw new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    private static List<DiscoveryNode> getAssignableNodes(ClusterState clusterState) {
        Set<String> shuttingDownNodes = TrainedModelAssignmentClusterService.nodesShuttingDown(clusterState);
        return clusterState.getNodes().getNodes().values().stream().filter(StartTrainedModelDeploymentAction.TaskParams::mayAssignToNode).filter(n -> !shuttingDownNodes.contains(n.getId())).toList();
    }

    private Map<DiscoveryNode, NodeLoad> detectNodeLoads(List<DiscoveryNode> nodes, ClusterState clusterState) {
        return nodes.stream().collect(Collectors.toMap(Function.identity(), n -> this.nodeLoadDetector.detectNodeLoad(clusterState, null, (DiscoveryNode)n, this.maxOpenJobs, this.maxMemoryPercentage, this.useAuto)));
    }

    private boolean isScalingPossible(List<DiscoveryNode> nodes) {
        OptionalLong smallestMLNode = nodes.stream().map(NodeLoadDetector::getNodeSize).flatMapToLong(OptionalLong::stream).min();
        return this.maxLazyMLNodes > nodes.size() || smallestMLNode.isPresent() && smallestMLNode.getAsLong() < this.maxMLNodeSize;
    }

    public void updateNumberOfAllocations(String deploymentId, int numberOfAllocations, ActionListener<TrainedModelAssignment> listener) {
        this.updateNumberOfAllocations(this.clusterService.state(), deploymentId, numberOfAllocations, listener);
    }

    private void updateNumberOfAllocations(final ClusterState clusterState, String deploymentId, int numberOfAllocations, ActionListener<TrainedModelAssignment> listener) {
        TrainedModelAssignmentMetadata metadata = TrainedModelAssignmentMetadata.fromState(clusterState);
        TrainedModelAssignment existingAssignment = metadata.getDeploymentAssignment(deploymentId);
        if (existingAssignment == null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.missingModelDeployment((String)deploymentId)));
            return;
        }
        if (existingAssignment.getTaskParams().getNumberOfAllocations() == numberOfAllocations) {
            listener.onResponse((Object)existingAssignment);
            return;
        }
        if (existingAssignment.getAssignmentState() != AssignmentState.STARTED) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("cannot update deployment that is not in [{}] state", RestStatus.CONFLICT, new Object[]{AssignmentState.STARTED})));
            return;
        }
        if (clusterState.getMinTransportVersion().before((VersionId)DISTRIBUTED_MODEL_ALLOCATION_TRANSPORT_VERSION)) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("cannot update number_of_allocations for deployment with model id [{}] while cluster upgrade is in progress.", RestStatus.CONFLICT, new Object[]{deploymentId})));
            return;
        }
        ActionListener updatedStateListener = ActionListener.wrap(updatedState -> this.submitUnbatchedTask("update model deployment number_of_allocations", new ClusterStateUpdateTask((ClusterState)updatedState, deploymentId, numberOfAllocations, (ActionListener)listener, existingAssignment){
            private volatile boolean isUpdated;
            final /* synthetic */ ClusterState val$updatedState;
            final /* synthetic */ String val$deploymentId;
            final /* synthetic */ int val$numberOfAllocations;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ TrainedModelAssignment val$existingAssignment;
            {
                this.val$updatedState = clusterState2;
                this.val$deploymentId = string;
                this.val$numberOfAllocations = n;
                this.val$listener = actionListener;
                this.val$existingAssignment = trainedModelAssignment;
            }

            public ClusterState execute(ClusterState currentState) {
                if (TrainedModelAssignmentClusterService.this.areClusterStatesCompatibleForRebalance(clusterState, currentState)) {
                    this.isUpdated = true;
                    return this.val$updatedState;
                }
                logger.debug(() -> Strings.format((String)"[%s] Retrying update as cluster state has been modified", (Object[])new Object[]{this.val$deploymentId}));
                TrainedModelAssignmentClusterService.this.updateNumberOfAllocations(currentState, this.val$deploymentId, this.val$numberOfAllocations, (ActionListener<TrainedModelAssignment>)this.val$listener);
                return currentState;
            }

            public void onFailure(Exception e) {
                this.val$listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                if (this.isUpdated) {
                    TrainedModelAssignment updatedAssignment = TrainedModelAssignmentMetadata.fromState(newState).getDeploymentAssignment(this.val$deploymentId);
                    if (updatedAssignment.totalTargetAllocations() > this.val$existingAssignment.totalTargetAllocations()) {
                        TrainedModelAssignmentClusterService.this.threadPool.executor("ml_utility").execute(() -> TrainedModelAssignmentClusterService.this.systemAuditor.info(Messages.getMessage((String)"Rebalanced trained model allocations because [{0}]", (Object[])new Object[]{"model deployment updated"})));
                    }
                    this.val$listener.onResponse((Object)updatedAssignment);
                }
            }
        }), arg_0 -> listener.onFailure(arg_0));
        this.adjustNumberOfAllocations(clusterState, existingAssignment, numberOfAllocations, (ActionListener<ClusterState>)updatedStateListener);
    }

    private void adjustNumberOfAllocations(ClusterState clusterState, TrainedModelAssignment assignment, int numberOfAllocations, ActionListener<ClusterState> listener) {
        this.threadPool.executor("ml_utility").execute(() -> {
            if (numberOfAllocations > assignment.getTaskParams().getNumberOfAllocations()) {
                this.increaseNumberOfAllocations(clusterState, assignment, numberOfAllocations, listener);
            } else {
                this.decreaseNumberOfAllocations(clusterState, assignment, numberOfAllocations, listener);
            }
        });
    }

    private void increaseNumberOfAllocations(ClusterState clusterState, TrainedModelAssignment assignment, int numberOfAllocations, ActionListener<ClusterState> listener) {
        try {
            ClusterState updatedClusterState = TrainedModelAssignmentClusterService.update(clusterState, TrainedModelAssignmentMetadata.builder(clusterState).updateAssignment(assignment.getDeploymentId(), TrainedModelAssignment.Builder.fromAssignment((TrainedModelAssignment)assignment).setNumberOfAllocations(numberOfAllocations)));
            TrainedModelAssignmentMetadata.Builder rebalancedMetadata = this.rebalanceAssignments(updatedClusterState, Optional.empty());
            if (!this.isScalingPossible(TrainedModelAssignmentClusterService.getAssignableNodes(clusterState)) && rebalancedMetadata.getAssignment(assignment.getDeploymentId()).build().totalTargetAllocations() < numberOfAllocations) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Could not update deployment because there are not enough resources to provide all requested allocations", RestStatus.TOO_MANY_REQUESTS, new Object[0])));
            } else {
                listener.onResponse((Object)TrainedModelAssignmentClusterService.update(clusterState, rebalancedMetadata));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void decreaseNumberOfAllocations(ClusterState clusterState, TrainedModelAssignment assignment, int numberOfAllocations, ActionListener<ClusterState> listener) {
        TrainedModelAssignment.Builder updatedAssignment;
        TrainedModelAssignment.Builder builder = updatedAssignment = numberOfAllocations < assignment.totalTargetAllocations() ? new AllocationReducer(assignment, this.nodeAvailabilityZoneMapper.buildMlNodesByAvailabilityZone(clusterState)).reduceTo(numberOfAllocations) : TrainedModelAssignment.Builder.fromAssignment((TrainedModelAssignment)assignment).setNumberOfAllocations(numberOfAllocations);
        if (numberOfAllocations <= assignment.totalTargetAllocations()) {
            updatedAssignment.setReason(null);
        }
        TrainedModelAssignmentMetadata.Builder builder2 = TrainedModelAssignmentMetadata.builder(clusterState);
        builder2.updateAssignment(assignment.getDeploymentId(), updatedAssignment);
        listener.onResponse((Object)TrainedModelAssignmentClusterService.update(clusterState, builder2));
    }

    static ClusterState setToStopping(ClusterState clusterState, String deploymentId, String reason) {
        TrainedModelAssignmentMetadata metadata = TrainedModelAssignmentMetadata.fromState(clusterState);
        TrainedModelAssignment existingAssignment = metadata.getDeploymentAssignment(deploymentId);
        if (existingAssignment == null) {
            throw new ResourceNotFoundException("assignment with id [{}] not found", new Object[]{deploymentId});
        }
        if (existingAssignment.getAssignmentState().equals((Object)AssignmentState.STOPPING)) {
            return clusterState;
        }
        TrainedModelAssignmentMetadata.Builder builder = TrainedModelAssignmentMetadata.builder(clusterState);
        builder.getAssignment(deploymentId).stopAssignment(reason);
        return TrainedModelAssignmentClusterService.update(clusterState, builder);
    }

    static ClusterState updateModelRoutingTable(ClusterState currentState, UpdateTrainedModelAssignmentRoutingInfoAction.Request request) {
        String deploymentId = request.getDeploymentId();
        String nodeId = request.getNodeId();
        TrainedModelAssignmentMetadata metadata = TrainedModelAssignmentMetadata.fromState(currentState);
        logger.trace(() -> Strings.format((String)"[%s] [%s] current metadata before update %s", (Object[])new Object[]{deploymentId, nodeId, org.elasticsearch.common.Strings.toString((ChunkedToXContent)metadata)}));
        TrainedModelAssignment existingAssignment = metadata.getDeploymentAssignment(deploymentId);
        TrainedModelAssignmentMetadata.Builder builder = TrainedModelAssignmentMetadata.builder(currentState);
        if (request.getUpdate().getStateAndReason().isPresent() && ((RoutingStateAndReason)request.getUpdate().getStateAndReason().get()).getState().equals((Object)RoutingState.STOPPED)) {
            if (existingAssignment == null || !existingAssignment.isRoutedToNode(nodeId)) {
                return currentState;
            }
            builder.getAssignment(deploymentId).removeRoutingEntry(nodeId).calculateAndSetAssignmentState();
            return TrainedModelAssignmentClusterService.update(currentState, builder);
        }
        if (existingAssignment == null) {
            throw new ResourceNotFoundException("assignment with id [{}] not found", new Object[]{deploymentId});
        }
        if (existingAssignment.getAssignmentState().equals((Object)AssignmentState.STOPPING)) {
            logger.debug(() -> Strings.format((String)"[%s] requested update from node [%s] while stopping; update was [%s]", (Object[])new Object[]{deploymentId, nodeId, request.getUpdate()}));
            return currentState;
        }
        if (!existingAssignment.isRoutedToNode(nodeId)) {
            throw new ResourceNotFoundException("assignment with id [{}]] is not routed to node [{}]", new Object[]{deploymentId, nodeId});
        }
        RoutingInfo routingInfo = (RoutingInfo)existingAssignment.getNodeRoutingTable().get(nodeId);
        builder.getAssignment(deploymentId).updateExistingRoutingEntry(nodeId, request.getUpdate().apply(routingInfo)).calculateAndSetAssignmentState();
        return TrainedModelAssignmentClusterService.update(currentState, builder);
    }

    static ClusterState removeAssignment(ClusterState currentState, String deploymentId) {
        TrainedModelAssignmentMetadata.Builder builder = TrainedModelAssignmentMetadata.builder(currentState);
        if (!builder.hasModelDeployment(deploymentId)) {
            throw new ResourceNotFoundException("assignment for deployment with id [{}] not found", new Object[]{deploymentId});
        }
        logger.debug(() -> Strings.format((String)"[%s] removing assignment", (Object[])new Object[]{deploymentId}));
        return TrainedModelAssignmentClusterService.update(currentState, builder.removeAssignment(deploymentId));
    }

    static ClusterState removeAllAssignments(ClusterState currentState) {
        if (TrainedModelAssignmentMetadata.fromState(currentState).allAssignments().isEmpty()) {
            return currentState;
        }
        return TrainedModelAssignmentClusterService.forceUpdate(currentState, TrainedModelAssignmentMetadata.Builder.empty());
    }

    static Optional<String> detectReasonToRebalanceModels(ClusterChangedEvent event) {
        TrainedModelAssignmentMetadata newMetadata = TrainedModelAssignmentMetadata.fromState(event.state());
        if (newMetadata == null || newMetadata.allAssignments().isEmpty()) {
            return Optional.empty();
        }
        return TrainedModelAssignmentClusterService.detectReasonIfMlJobsStopped(event).or(() -> {
            String reason = null;
            if (TrainedModelAssignmentClusterService.haveMlNodesChanged(event, newMetadata)) {
                reason = "nodes changed";
            } else if (newMetadata.hasOutdatedAssignments()) {
                reason = "outdated assignments detected";
            }
            return Optional.ofNullable(reason);
        });
    }

    static Optional<String> detectReasonIfMlJobsStopped(ClusterChangedEvent event) {
        if (!event.changedCustomMetadataSet().contains("persistent_tasks")) {
            return Optional.empty();
        }
        PersistentTasksCustomMetadata previousPersistentTasks = (PersistentTasksCustomMetadata)event.previousState().getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata currentPersistentTasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks");
        Set<String> previousMlTaskIds = TrainedModelAssignmentClusterService.findMlProcessTaskIds(previousPersistentTasks);
        Set<String> currentMlTaskIds = TrainedModelAssignmentClusterService.findMlProcessTaskIds(currentPersistentTasks);
        Set stoppedTaskTypes = previousMlTaskIds.stream().filter(id -> !currentMlTaskIds.contains(id)).map(arg_0 -> ((PersistentTasksCustomMetadata)previousPersistentTasks).getTask(arg_0)).map(PersistentTasksCustomMetadata.PersistentTask::getTaskName).map(MlTasks::prettyPrintTaskName).collect(Collectors.toSet());
        if (stoppedTaskTypes.size() == 1) {
            return Optional.of("ML [" + (String)stoppedTaskTypes.iterator().next() + "] job stopped");
        }
        if (stoppedTaskTypes.size() > 1) {
            return Optional.of("ML " + stoppedTaskTypes + " jobs stopped");
        }
        return Optional.empty();
    }

    private static Set<String> findMlProcessTaskIds(@Nullable PersistentTasksCustomMetadata metadata) {
        return metadata == null ? Set.of() : MlTasks.findMlProcessTasks((PersistentTasksCustomMetadata)metadata).stream().map(PersistentTasksCustomMetadata.PersistentTask::getId).collect(Collectors.toSet());
    }

    static boolean haveMlNodesChanged(ClusterChangedEvent event, TrainedModelAssignmentMetadata newMetadata) {
        boolean nodesShutdownChanged = event.changedCustomMetadataSet().contains("node_shutdown");
        if (event.nodesChanged() || nodesShutdownChanged) {
            Set exitingShutDownNodes;
            Set<String> shuttingDownNodes = TrainedModelAssignmentClusterService.nodesShuttingDown(event.state());
            DiscoveryNodes.Delta nodesDelta = event.nodesDelta();
            Set removedNodes = nodesDelta.removedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            Set addedNodes = nodesDelta.addedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            if (nodesShutdownChanged) {
                Set<String> previousShuttingDownNodes = TrainedModelAssignmentClusterService.nodesShuttingDown(event.previousState());
                Set returningShutDownNodes = Sets.difference(previousShuttingDownNodes, shuttingDownNodes);
                addedNodes.addAll(returningShutDownNodes);
                exitingShutDownNodes = Sets.difference(shuttingDownNodes, previousShuttingDownNodes);
                removedNodes.addAll(exitingShutDownNodes);
            } else {
                exitingShutDownNodes = Collections.emptySet();
            }
            logger.debug(() -> Strings.format((String)"added nodes %s; removed nodes %s; shutting down nodes %s; exiting shutdown nodes %s", (Object[])new Object[]{addedNodes, removedNodes, shuttingDownNodes, exitingShutDownNodes}));
            for (TrainedModelAssignment trainedModelAssignment : newMetadata.allAssignments().values()) {
                if (trainedModelAssignment.getAssignmentState().equals((Object)AssignmentState.STOPPING)) continue;
                for (String nodeId : exitingShutDownNodes) {
                    if (!trainedModelAssignment.isRoutedToNode(nodeId) || ((RoutingInfo)trainedModelAssignment.getNodeRoutingTable().get(nodeId)).getState() == RoutingState.STOPPING) continue;
                    logger.debug(() -> Strings.format((String)"should rebalance because model deployment [%s] has allocations on shutting down node [%s]", (Object[])new Object[]{trainedModelAssignment.getDeploymentId(), nodeId}));
                    return true;
                }
                for (String nodeId : removedNodes) {
                    if (!trainedModelAssignment.isRoutedToNode(nodeId) || shuttingDownNodes.contains(nodeId)) continue;
                    logger.debug(() -> Strings.format((String)"should rebalance because model deployment [%s] has allocations on removed node [%s]", (Object[])new Object[]{trainedModelAssignment.getDeploymentId(), nodeId}));
                    return true;
                }
                for (String nodeId : addedNodes) {
                    if (!StartTrainedModelDeploymentAction.TaskParams.mayAssignToNode((DiscoveryNode)event.state().nodes().get(nodeId)) || shuttingDownNodes.contains(nodeId)) continue;
                    logger.debug(() -> Strings.format((String)"should rebalance because ML eligible node [%s] was added", (Object[])new Object[]{nodeId}));
                    return true;
                }
            }
        }
        return false;
    }

    static Set<String> nodesShuttingDown(ClusterState state) {
        return state.metadata().nodeShutdowns().getAllNodeIds();
    }
}

