/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.ClearScrollAction;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollAction;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.SearchHitToJsonProcessor;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;

class ScrollDataExtractor
implements DataExtractor {
    private static final TimeValue SCROLL_TIMEOUT = new TimeValue(30L, TimeUnit.MINUTES);
    private static final Logger logger = LogManager.getLogger(ScrollDataExtractor.class);
    private final Client client;
    private final ScrollDataExtractorContext context;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private String scrollId;
    private boolean isCancelled;
    private boolean hasNext;
    private Long timestampOnCancel;
    protected Long lastTimestamp;
    private boolean searchHasShardFailure;

    ScrollDataExtractor(Client client, ScrollDataExtractorContext dataExtractorContext, DatafeedTimingStatsReporter timingStatsReporter) {
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.hasNext = true;
        this.searchHasShardFailure = false;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        logger.trace("[{}] Data extractor received cancel request", (Object)this.context.jobId);
        this.isCancelled = true;
    }

    public void destroy() {
        this.cancel();
        this.clearScroll();
    }

    public long getEndTime() {
        return this.context.end;
    }

    public DataExtractor.Result next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Optional<InputStream> stream = this.tryNextStream();
        if (!stream.isPresent()) {
            this.hasNext = false;
        }
        return new DataExtractor.Result(new SearchInterval(this.context.start, this.context.end), stream);
    }

    private Optional<InputStream> tryNextStream() throws IOException {
        try {
            return this.scrollId == null ? Optional.ofNullable(this.initScroll(this.context.start)) : Optional.ofNullable(this.continueScroll());
        }
        catch (Exception e) {
            this.scrollId = null;
            if (this.searchHasShardFailure) {
                throw e;
            }
            logger.debug("[{}] Resetting scroll search after shard failure", (Object)this.context.jobId);
            this.markScrollAsErrored();
            return Optional.ofNullable(this.initScroll(this.lastTimestamp == null ? this.context.start : this.lastTimestamp));
        }
    }

    protected InputStream initScroll(long startTimestamp) throws IOException {
        logger.debug("[{}] Initializing scroll with start time [{}]", (Object)this.context.jobId, (Object)startTimestamp);
        SearchResponse searchResponse = this.executeSearchRequest(this.buildSearchRequest(startTimestamp));
        logger.debug("[{}] Search response was obtained", (Object)this.context.jobId);
        this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
        this.scrollId = searchResponse.getScrollId();
        SearchHit[] hits = searchResponse.getHits().getHits();
        searchResponse = null;
        return this.processAndConsumeSearchHits(hits);
    }

    protected SearchResponse executeSearchRequest(SearchRequestBuilder searchRequestBuilder) {
        SearchResponse searchResponse = (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> ((SearchRequestBuilder)searchRequestBuilder).get());
        try {
            this.checkForSkippedClusters(searchResponse);
        }
        catch (ResourceNotFoundException e) {
            this.clearScrollLoggingExceptions(searchResponse.getScrollId());
            throw e;
        }
        return searchResponse;
    }

    private SearchRequestBuilder buildSearchRequest(long start) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(this.context.scrollSize).sort(this.context.extractedFields.timeField(), SortOrder.ASC).query(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.context.query, (String)this.context.extractedFields.timeField(), (long)start, (long)this.context.end)).runtimeMappings(this.context.runtimeMappings);
        SearchRequestBuilder searchRequestBuilder = new SearchRequestBuilder((ElasticsearchClient)this.client, SearchAction.INSTANCE).setScroll(SCROLL_TIMEOUT).setIndices(this.context.indices).setIndicesOptions(this.context.indicesOptions).setAllowPartialSearchResults(false).setSource(searchSourceBuilder);
        for (ExtractedField docValueField : this.context.extractedFields.getDocValueFields()) {
            searchRequestBuilder.addDocValueField(docValueField.getSearchField(), docValueField.getDocValueFormat());
        }
        String[] sourceFields = this.context.extractedFields.getSourceFields();
        if (sourceFields.length == 0) {
            searchRequestBuilder.setFetchSource(false);
            searchRequestBuilder.storedFields(new String[]{"_none_"});
        } else {
            searchRequestBuilder.setFetchSource(sourceFields, null);
        }
        this.context.scriptFields.forEach(f -> searchRequestBuilder.addScriptField(f.fieldName(), f.script()));
        return searchRequestBuilder;
    }

    private InputStream processAndConsumeSearchHits(SearchHit[] hits) throws IOException {
        if (hits == null || hits.length == 0) {
            this.hasNext = false;
            this.clearScroll();
            return null;
        }
        BytesStreamOutput outputStream = new BytesStreamOutput();
        SearchHit lastHit = hits[hits.length - 1];
        this.lastTimestamp = this.context.extractedFields.timeFieldValue(lastHit);
        try (SearchHitToJsonProcessor hitProcessor = new SearchHitToJsonProcessor(this.context.extractedFields, (OutputStream)outputStream);){
            for (int i = 0; i < hits.length; ++i) {
                Long timestamp;
                SearchHit hit = hits[i];
                if (this.isCancelled && (timestamp = this.context.extractedFields.timeFieldValue(hit)) != null) {
                    if (this.timestampOnCancel == null) {
                        this.timestampOnCancel = timestamp;
                    } else if (!timestamp.equals(this.timestampOnCancel)) {
                        this.hasNext = false;
                        this.clearScroll();
                        break;
                    }
                }
                hitProcessor.process(hit);
                hits[i] = null;
            }
        }
        return outputStream.bytes().streamInput();
    }

    private InputStream continueScroll() throws IOException {
        SearchResponse searchResponse;
        logger.debug("[{}] Continuing scroll with id [{}]", (Object)this.context.jobId, (Object)this.scrollId);
        try {
            searchResponse = this.executeSearchScrollRequest(this.scrollId);
        }
        catch (SearchPhaseExecutionException searchExecutionException) {
            if (this.searchHasShardFailure) {
                throw searchExecutionException;
            }
            logger.debug("[{}] search failed due to SearchPhaseExecutionException. Will attempt again with new scroll", (Object)this.context.jobId);
            this.markScrollAsErrored();
            searchResponse = this.executeSearchRequest(this.buildSearchRequest(this.lastTimestamp == null ? this.context.start : this.lastTimestamp));
        }
        logger.debug("[{}] Search response was obtained", (Object)this.context.jobId);
        this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
        this.scrollId = searchResponse.getScrollId();
        SearchHit[] hits = searchResponse.getHits().getHits();
        searchResponse = null;
        return this.processAndConsumeSearchHits(hits);
    }

    void markScrollAsErrored() {
        this.scrollId = null;
        if (this.lastTimestamp != null) {
            Long l = this.lastTimestamp;
            this.lastTimestamp = this.lastTimestamp + 1L;
        }
        this.searchHasShardFailure = true;
    }

    protected SearchResponse executeSearchScrollRequest(String scrollId) {
        SearchResponse searchResponse = (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> (SearchResponse)new SearchScrollRequestBuilder((ElasticsearchClient)this.client, SearchScrollAction.INSTANCE).setScroll(SCROLL_TIMEOUT).setScrollId(scrollId).get());
        try {
            this.checkForSkippedClusters(searchResponse);
        }
        catch (ResourceNotFoundException e) {
            this.clearScrollLoggingExceptions(searchResponse.getScrollId());
            throw e;
        }
        return searchResponse;
    }

    private void clearScroll() {
        this.innerClearScroll(this.scrollId);
        this.scrollId = null;
    }

    private void clearScrollLoggingExceptions(String scrollId) {
        try {
            this.innerClearScroll(scrollId);
        }
        catch (Exception e) {
            logger.error(() -> "[" + this.context.jobId + "] Failed to clear scroll", (Throwable)e);
        }
    }

    private void innerClearScroll(String scrollId) {
        if (scrollId != null) {
            ClearScrollRequest request = new ClearScrollRequest();
            request.addScrollId(scrollId);
            ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> (ClearScrollResponse)this.client.execute((ActionType)ClearScrollAction.INSTANCE, (ActionRequest)request).actionGet());
        }
    }
}

