/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregatedSearchRequestBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorContext;

public record AggregationDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, QueryBuilder extraFilters, Job job, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter) implements DataExtractorFactory
{
    public static AggregatedSearchRequestBuilder requestBuilder(Client client, String[] indices, IndicesOptions indicesOptions) {
        return searchSourceBuilder -> new SearchRequestBuilder((ElasticsearchClient)client, SearchAction.INSTANCE).setSource(searchSourceBuilder).setIndicesOptions(indicesOptions).setAllowPartialSearchResults(false).setIndices(indices);
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        QueryBuilder queryBuilder = this.datafeedConfig.getParsedQuery(this.xContentRegistry);
        if (this.extraFilters != null) {
            queryBuilder = QueryBuilders.boolQuery().filter(queryBuilder).filter(this.extraFilters);
        }
        long histogramInterval = this.datafeedConfig.getHistogramIntervalMillis(this.xContentRegistry);
        AggregationDataExtractorContext dataExtractorContext = new AggregationDataExtractorContext(this.job.getId(), this.job.getDataDescription().getTimeField(), this.job.getAnalysisConfig().analysisFields(), this.datafeedConfig.getIndices(), queryBuilder, this.datafeedConfig.getParsedAggregations(this.xContentRegistry), Intervals.alignToCeil((long)start, (long)histogramInterval), Intervals.alignToFloor((long)end, (long)histogramInterval), this.job.getAnalysisConfig().getSummaryCountFieldName().equals("doc_count"), this.datafeedConfig.getHeaders(), this.datafeedConfig.getIndicesOptions(), this.datafeedConfig.getRuntimeMappings());
        return new AggregationDataExtractor(this.client, dataExtractorContext, this.timingStatsReporter);
    }
}

