/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContextProvider;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJob;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobBuilder;
import org.elasticsearch.xpack.ml.datafeed.ProblemTracker;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class DatafeedRunner {
    private static final Logger logger = LogManager.getLogger(DatafeedRunner.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final LongSupplier currentTimeSupplier;
    private final AnomalyDetectionAuditor auditor;
    private final ConcurrentMap<Long, Holder> runningDatafeedsOnThisNode = new ConcurrentHashMap<Long, Holder>();
    private final DatafeedJobBuilder datafeedJobBuilder;
    private final TaskRunner taskRunner = new TaskRunner();
    private final AutodetectProcessManager autodetectProcessManager;
    private final DatafeedContextProvider datafeedContextProvider;

    public DatafeedRunner(ThreadPool threadPool, Client client, ClusterService clusterService, DatafeedJobBuilder datafeedJobBuilder, LongSupplier currentTimeSupplier, AnomalyDetectionAuditor auditor, AutodetectProcessManager autodetectProcessManager, DatafeedContextProvider datafeedContextProvider) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.currentTimeSupplier = Objects.requireNonNull(currentTimeSupplier);
        this.auditor = Objects.requireNonNull(auditor);
        this.datafeedJobBuilder = Objects.requireNonNull(datafeedJobBuilder);
        this.autodetectProcessManager = Objects.requireNonNull(autodetectProcessManager);
        this.datafeedContextProvider = Objects.requireNonNull(datafeedContextProvider);
        clusterService.addListener((ClusterStateListener)this.taskRunner);
    }

    public void run(final TransportStartDatafeedAction.DatafeedTask task, final Consumer<Exception> finishHandler) {
        ActionListener datafeedJobHandler = ActionListener.wrap(datafeedJob -> {
            final String jobId = datafeedJob.getJobId();
            Holder holder = new Holder(task, task.getDatafeedId(), (DatafeedJob)datafeedJob, new ProblemTracker(this.auditor, jobId, datafeedJob.numberOfSearchesIn24Hours()), finishHandler);
            TransportStartDatafeedAction.DatafeedTask.StoppedOrIsolated stoppedOrIsolated = task.executeIfNotStoppedOrIsolated(() -> this.runningDatafeedsOnThisNode.put(task.getAllocationId(), holder));
            if (stoppedOrIsolated == TransportStartDatafeedAction.DatafeedTask.StoppedOrIsolated.NEITHER) {
                task.updatePersistentTaskState((PersistentTaskState)DatafeedState.STARTED, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                    public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                        DatafeedRunner.this.taskRunner.runWhenJobIsOpened(task, jobId);
                    }

                    public void onFailure(Exception e) {
                        if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                            logger.info("[{}] Aborting as datafeed has been stopped", (Object)task.getDatafeedId());
                            DatafeedRunner.this.runningDatafeedsOnThisNode.remove(task.getAllocationId());
                            finishHandler.accept(null);
                        } else {
                            finishHandler.accept(e);
                        }
                    }
                });
            } else {
                logger.info("[{}] Datafeed has been {} before running", (Object)task.getDatafeedId(), (Object)stoppedOrIsolated.toString().toLowerCase(Locale.ROOT));
                finishHandler.accept(null);
            }
        }, finishHandler);
        ActionListener datafeedContextListener = ActionListener.wrap(datafeedContext -> {
            TransportStartDatafeedAction.DatafeedTask.StoppedOrIsolated stoppedOrIsolated = task.getStoppedOrIsolated();
            if (stoppedOrIsolated == TransportStartDatafeedAction.DatafeedTask.StoppedOrIsolated.NEITHER) {
                this.datafeedJobBuilder.build(task, (DatafeedContext)datafeedContext, (ActionListener<DatafeedJob>)datafeedJobHandler);
            } else {
                logger.info("[{}] Datafeed has been {} while building context", (Object)task.getDatafeedId(), (Object)stoppedOrIsolated.toString().toLowerCase(Locale.ROOT));
                finishHandler.accept(null);
            }
        }, finishHandler);
        this.datafeedContextProvider.buildDatafeedContext(task.getDatafeedId(), (ActionListener<DatafeedContext>)datafeedContextListener);
    }

    public void stopDatafeed(TransportStartDatafeedAction.DatafeedTask task, String reason, TimeValue timeout) {
        logger.info("[{}] attempt to stop datafeed [{}] [{}]", (Object)reason, (Object)task.getDatafeedId(), (Object)task.getAllocationId());
        Holder holder = (Holder)this.runningDatafeedsOnThisNode.remove(task.getAllocationId());
        if (holder != null) {
            holder.stop(reason, timeout, null);
        }
    }

    public void stopAllDatafeedsOnThisNode(String reason) {
        int numDatafeeds = this.runningDatafeedsOnThisNode.size();
        if (numDatafeeds != 0) {
            logger.info("Closing [{}] datafeeds, because [{}]", (Object)numDatafeeds, (Object)reason);
            for (Holder holder : this.runningDatafeedsOnThisNode.values()) {
                holder.stop(reason, TimeValue.timeValueSeconds((long)20L), null);
            }
        }
    }

    public void prepareForImmediateShutdown() {
        Iterator iter = this.runningDatafeedsOnThisNode.values().iterator();
        while (iter.hasNext()) {
            ((Holder)iter.next()).setNodeIsShuttingDown();
            iter.remove();
        }
    }

    public void isolateDatafeed(TransportStartDatafeedAction.DatafeedTask task) {
        Holder holder = (Holder)this.runningDatafeedsOnThisNode.get(task.getAllocationId());
        if (holder != null) {
            holder.isolateDatafeed();
        }
    }

    public void vacateAllDatafeedsOnThisNode(String reason) {
        for (Holder holder : this.runningDatafeedsOnThisNode.values()) {
            if (holder.isIsolated()) continue;
            holder.vacateNode(reason);
        }
    }

    public boolean finishedLookBack(TransportStartDatafeedAction.DatafeedTask task) {
        Holder holder = (Holder)this.runningDatafeedsOnThisNode.get(task.getAllocationId());
        return holder != null && holder.isLookbackFinished();
    }

    public SearchInterval getSearchInterval(TransportStartDatafeedAction.DatafeedTask task) {
        Holder holder = (Holder)this.runningDatafeedsOnThisNode.get(task.getAllocationId());
        return holder == null ? null : holder.datafeedJob.getSearchInterval();
    }

    private void innerRun(final Holder holder, final long startTime, final Long endTime) {
        holder.cancellable = Scheduler.wrapAsCancellable(this.threadPool.executor("ml_datafeed").submit((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                logger.error("Failed lookback import for job [" + holder.datafeedJob.getJobId() + "]", (Throwable)e);
                holder.stop("general_lookback_failure", TimeValue.timeValueSeconds((long)20L), e);
            }

            protected void doRun() {
                Long next = null;
                try {
                    next = holder.executeLookBack(startTime, endTime);
                }
                catch (DatafeedJob.ExtractionProblemException e) {
                    if (endTime == null) {
                        next = e.nextDelayInMsSinceEpoch;
                    }
                    holder.problemTracker.reportExtractionProblem(e);
                }
                catch (DatafeedJob.AnalysisProblemException e) {
                    if (endTime == null) {
                        next = e.nextDelayInMsSinceEpoch;
                    }
                    holder.problemTracker.reportAnalysisProblem(e);
                    if (e.shouldStop) {
                        holder.stop("lookback_analysis_error", TimeValue.timeValueSeconds((long)20L), (Exception)((Object)e));
                        return;
                    }
                }
                catch (DatafeedJob.EmptyDataCountException e) {
                    if (endTime == null) {
                        holder.problemTracker.reportEmptyDataCount();
                        next = e.nextDelayInMsSinceEpoch;
                    } else {
                        String lookbackNoDataMsg = Messages.getMessage((String)"Datafeed lookback retrieved no data");
                        logger.warn("[{}] {}", (Object)holder.datafeedJob.getJobId(), (Object)lookbackNoDataMsg);
                        DatafeedRunner.this.auditor.warning(holder.datafeedJob.getJobId(), lookbackNoDataMsg);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed lookback import for job [" + holder.datafeedJob.getJobId() + "]", (Throwable)e);
                    holder.stop("general_lookback_failure", TimeValue.timeValueSeconds((long)20L), e);
                    return;
                }
                holder.finishedLookback(true);
                if (!holder.isIsolated()) {
                    if (next != null) {
                        DatafeedRunner.this.doDatafeedRealtime(next, holder.datafeedJob.getJobId(), holder);
                    } else {
                        holder.stop("no_realtime", TimeValue.timeValueSeconds((long)20L), null);
                        holder.problemTracker.finishReport();
                    }
                }
            }
        }));
    }

    void doDatafeedRealtime(long delayInMsSinceEpoch, final String jobId, final Holder holder) {
        if (holder.isRunning() && !holder.isIsolated()) {
            TimeValue delay = this.computeNextDelay(delayInMsSinceEpoch);
            logger.debug("Waiting [{}] before executing next realtime import for job [{}]", (Object)delay, (Object)jobId);
            holder.cancellable = this.threadPool.schedule((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    logger.error("Unexpected datafeed failure for job [" + jobId + "] stopping...", (Throwable)e);
                    holder.stop("general_realtime_error", TimeValue.timeValueSeconds((long)20L), e);
                }

                protected void doRun() {
                    long nextDelayInMsSinceEpoch;
                    try {
                        nextDelayInMsSinceEpoch = holder.executeRealTime();
                        holder.problemTracker.reportNonEmptyDataCount();
                    }
                    catch (DatafeedJob.ExtractionProblemException e) {
                        nextDelayInMsSinceEpoch = e.nextDelayInMsSinceEpoch;
                        holder.problemTracker.reportExtractionProblem(e);
                    }
                    catch (DatafeedJob.AnalysisProblemException e) {
                        nextDelayInMsSinceEpoch = e.nextDelayInMsSinceEpoch;
                        holder.problemTracker.reportAnalysisProblem(e);
                        if (e.shouldStop) {
                            holder.stop("realtime_analysis_error", TimeValue.timeValueSeconds((long)20L), (Exception)((Object)e));
                            return;
                        }
                    }
                    catch (DatafeedJob.EmptyDataCountException e) {
                        int emptyDataCount = holder.problemTracker.reportEmptyDataCount();
                        if (!e.haveEverSeenData && holder.shouldStopAfterEmptyData(emptyDataCount)) {
                            String noDataMessage = "Datafeed for [" + jobId + "] has seen no data in [" + emptyDataCount + "] attempts, and never seen any data previously, so stopping...";
                            logger.warn(noDataMessage);
                            holder.stop("no_data", TimeValue.timeValueSeconds((long)20L), e, true, noDataMessage);
                            return;
                        }
                        nextDelayInMsSinceEpoch = e.nextDelayInMsSinceEpoch;
                    }
                    catch (Exception e) {
                        logger.error("Unexpected datafeed failure for job [" + jobId + "] stopping...", (Throwable)e);
                        holder.stop("general_realtime_error", TimeValue.timeValueSeconds((long)20L), e);
                        return;
                    }
                    holder.problemTracker.finishReport();
                    if (nextDelayInMsSinceEpoch >= 0L) {
                        DatafeedRunner.this.doDatafeedRealtime(nextDelayInMsSinceEpoch, jobId, holder);
                    }
                }
            }, delay, (Executor)this.threadPool.executor("ml_datafeed"));
        }
    }

    private String getJobIdIfDatafeedRunningOnThisNode(TransportStartDatafeedAction.DatafeedTask task) {
        Holder holder = (Holder)this.runningDatafeedsOnThisNode.get(task.getAllocationId());
        if (holder == null) {
            return null;
        }
        return holder.getJobId();
    }

    private JobState getJobState(PersistentTasksCustomMetadata tasks, String jobId) {
        return MlTasks.getJobStateModifiedForReassignments((String)jobId, (PersistentTasksCustomMetadata)tasks);
    }

    private boolean jobHasOpenAutodetectCommunicator(PersistentTasksCustomMetadata tasks, String jobId) {
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask == null) {
            return false;
        }
        JobTaskState state = (JobTaskState)jobTask.getState();
        if (state == null || state.isStatusStale(jobTask)) {
            return false;
        }
        return this.autodetectProcessManager.hasOpenAutodetectCommunicator(jobTask.getAllocationId());
    }

    private TimeValue computeNextDelay(long next) {
        return new TimeValue(Math.max(1L, next - this.currentTimeSupplier.getAsLong()));
    }

    boolean isRunning(TransportStartDatafeedAction.DatafeedTask task) {
        return this.runningDatafeedsOnThisNode.containsKey(task.getAllocationId());
    }

    private class TaskRunner
    implements ClusterStateListener {
        private final List<TransportStartDatafeedAction.DatafeedTask> tasksToRun = new CopyOnWriteArrayList<TransportStartDatafeedAction.DatafeedTask>();

        private TaskRunner() {
        }

        private void runWhenJobIsOpened(TransportStartDatafeedAction.DatafeedTask datafeedTask, String jobId) {
            ClusterState clusterState = DatafeedRunner.this.clusterService.state();
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
            if (DatafeedRunner.this.getJobState(tasks, jobId) == JobState.OPENED && DatafeedRunner.this.jobHasOpenAutodetectCommunicator(tasks, jobId)) {
                this.runTask(datafeedTask);
            } else {
                logger.info("Datafeed [{}] is waiting for job [{}] to be opened", (Object)datafeedTask.getDatafeedId(), (Object)jobId);
                this.tasksToRun.add(datafeedTask);
            }
        }

        private void runTask(TransportStartDatafeedAction.DatafeedTask task) {
            try (ThreadContext.StoredContext ignore = DatafeedRunner.this.threadPool.getThreadContext().stashContext();){
                Holder holder = (Holder)DatafeedRunner.this.runningDatafeedsOnThisNode.get(task.getAllocationId());
                if (holder != null) {
                    DatafeedRunner.this.innerRun(holder, task.getDatafeedStartTime(), task.getEndTime());
                } else {
                    logger.warn("Datafeed [{}] was stopped while being started", (Object)task.getDatafeedId());
                }
            }
        }

        public void clusterChanged(ClusterChangedEvent event) {
            PersistentTasksCustomMetadata currentTasks;
            if (this.tasksToRun.isEmpty() || !event.metadataChanged()) {
                return;
            }
            PersistentTasksCustomMetadata previousTasks = (PersistentTasksCustomMetadata)event.previousState().getMetadata().custom("persistent_tasks");
            if (Objects.equals(previousTasks, currentTasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks"))) {
                return;
            }
            ArrayList<TransportStartDatafeedAction.DatafeedTask> remainingTasks = new ArrayList<TransportStartDatafeedAction.DatafeedTask>();
            for (TransportStartDatafeedAction.DatafeedTask datafeedTask : this.tasksToRun) {
                String jobId = DatafeedRunner.this.getJobIdIfDatafeedRunningOnThisNode(datafeedTask);
                if (jobId == null) continue;
                JobState jobState = DatafeedRunner.this.getJobState(currentTasks, jobId);
                if (jobState == JobState.OPENING || !DatafeedRunner.this.jobHasOpenAutodetectCommunicator(currentTasks, jobId)) {
                    remainingTasks.add(datafeedTask);
                    continue;
                }
                if (jobState == JobState.OPENED) {
                    this.runTask(datafeedTask);
                    continue;
                }
                logger.warn("Datafeed [{}] is stopping because job [{}] state is [{}]", (Object)datafeedTask.getDatafeedId(), (Object)jobId, (Object)jobState);
                datafeedTask.stop("job_never_opened", TimeValue.timeValueSeconds((long)20L));
            }
            this.tasksToRun.retainAll(remainingTasks);
        }
    }

    public class Holder {
        private final TransportStartDatafeedAction.DatafeedTask task;
        private final long allocationId;
        private final String datafeedId;
        private final ReentrantLock datafeedJobLock = new ReentrantLock(true);
        private final DatafeedJob datafeedJob;
        private final boolean defaultAutoCloseJob;
        private final ProblemTracker problemTracker;
        private final Consumer<Exception> finishHandler;
        volatile Scheduler.Cancellable cancellable;
        private volatile boolean isNodeShuttingDown;
        private volatile boolean lookbackFinished;

        Holder(TransportStartDatafeedAction.DatafeedTask task, String datafeedId, DatafeedJob datafeedJob, ProblemTracker problemTracker, Consumer<Exception> finishHandler) {
            this.task = task;
            this.allocationId = task.getAllocationId();
            this.datafeedId = datafeedId;
            this.datafeedJob = datafeedJob;
            this.defaultAutoCloseJob = task.isLookbackOnly();
            this.problemTracker = problemTracker;
            this.finishHandler = finishHandler;
        }

        boolean shouldStopAfterEmptyData(int emptyDataCount) {
            Integer emptyDataCountToStopAt = this.datafeedJob.getMaxEmptySearches();
            return emptyDataCountToStopAt != null && emptyDataCount >= emptyDataCountToStopAt;
        }

        private void finishedLookback(boolean value) {
            this.lookbackFinished = value;
        }

        String getJobId() {
            return this.datafeedJob.getJobId();
        }

        boolean isRunning() {
            return this.datafeedJob.isRunning();
        }

        boolean isIsolated() {
            return this.datafeedJob.isIsolated();
        }

        public void stop(String source, TimeValue timeout, Exception e) {
            this.stop(source, timeout, e, this.defaultAutoCloseJob, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(String source, TimeValue timeout, Exception e, boolean autoCloseJob, String stoppedReason) {
            block14: {
                block15: {
                    if (this.isNodeShuttingDown) {
                        return;
                    }
                    logger.info("[{}] attempt to stop datafeed [{}] for job [{}]", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId());
                    if (!this.datafeedJob.stop()) break block15;
                    boolean acquired = false;
                    try {
                        logger.info("[{}] try lock [{}] to stop datafeed [{}] for job [{}]...", (Object)source, (Object)timeout, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId());
                        acquired = this.datafeedJobLock.tryLock(timeout.millis(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e1) {
                        try {
                            Thread.currentThread().interrupt();
                        }
                        catch (Throwable throwable) {
                            logger.info("[{}] stopping datafeed [{}] for job [{}], acquired [{}]...", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId(), (Object)acquired);
                            DatafeedRunner.this.runningDatafeedsOnThisNode.remove(this.allocationId);
                            if (this.cancellable != null) {
                                this.cancellable.cancel();
                            }
                            String auditMessage = this.isIsolated() ? Messages.getMessage((String)"Datafeed isolated") : (stoppedReason == null ? Messages.getMessage((String)"Datafeed stopped") : Messages.getMessage((String)"Datafeed stopped with reason [{0}]", (Object[])new Object[]{stoppedReason}));
                            DatafeedRunner.this.auditor.info(this.datafeedJob.getJobId(), auditMessage);
                            this.datafeedJob.finishReportingTimingStats();
                            this.finishHandler.accept(e);
                            logger.info("[{}] datafeed [{}] for job [{}] has been stopped{}", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId(), acquired ? "" : ", but there may be pending tasks as the timeout [" + timeout.getStringRep() + "] expired");
                            if (autoCloseJob && !this.isIsolated()) {
                                this.closeJob();
                            }
                            if (acquired) {
                                this.datafeedJobLock.unlock();
                            }
                            throw throwable;
                        }
                        logger.info("[{}] stopping datafeed [{}] for job [{}], acquired [{}]...", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId(), (Object)acquired);
                        DatafeedRunner.this.runningDatafeedsOnThisNode.remove(this.allocationId);
                        if (this.cancellable != null) {
                            this.cancellable.cancel();
                        }
                        String auditMessage = this.isIsolated() ? Messages.getMessage((String)"Datafeed isolated") : (stoppedReason == null ? Messages.getMessage((String)"Datafeed stopped") : Messages.getMessage((String)"Datafeed stopped with reason [{0}]", (Object[])new Object[]{stoppedReason}));
                        DatafeedRunner.this.auditor.info(this.datafeedJob.getJobId(), auditMessage);
                        this.datafeedJob.finishReportingTimingStats();
                        this.finishHandler.accept(e);
                        logger.info("[{}] datafeed [{}] for job [{}] has been stopped{}", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId(), acquired ? "" : ", but there may be pending tasks as the timeout [" + timeout.getStringRep() + "] expired");
                        if (autoCloseJob && !this.isIsolated()) {
                            this.closeJob();
                        }
                        if (acquired) {
                            this.datafeedJobLock.unlock();
                        }
                        break block14;
                    }
                    logger.info("[{}] stopping datafeed [{}] for job [{}], acquired [{}]...", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId(), (Object)acquired);
                    DatafeedRunner.this.runningDatafeedsOnThisNode.remove(this.allocationId);
                    if (this.cancellable != null) {
                        this.cancellable.cancel();
                    }
                    String auditMessage = this.isIsolated() ? Messages.getMessage((String)"Datafeed isolated") : (stoppedReason == null ? Messages.getMessage((String)"Datafeed stopped") : Messages.getMessage((String)"Datafeed stopped with reason [{0}]", (Object[])new Object[]{stoppedReason}));
                    DatafeedRunner.this.auditor.info(this.datafeedJob.getJobId(), auditMessage);
                    this.datafeedJob.finishReportingTimingStats();
                    this.finishHandler.accept(e);
                    logger.info("[{}] datafeed [{}] for job [{}] has been stopped{}", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId(), acquired ? "" : ", but there may be pending tasks as the timeout [" + timeout.getStringRep() + "] expired");
                    if (autoCloseJob && !this.isIsolated()) {
                        this.closeJob();
                    }
                    if (acquired) {
                        this.datafeedJobLock.unlock();
                    }
                    break block14;
                }
                logger.info("[{}] datafeed [{}] for job [{}] was already stopped", (Object)source, (Object)this.datafeedId, (Object)this.datafeedJob.getJobId());
            }
        }

        public void isolateDatafeed() {
            this.datafeedJob.isolate();
        }

        public void setNodeIsShuttingDown() {
            this.isolateDatafeed();
            this.isNodeShuttingDown = true;
        }

        public void vacateNode(String reason) {
            this.isolateDatafeed();
            this.task.markAsLocallyAborted(reason);
        }

        public boolean isLookbackFinished() {
            return this.lookbackFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Long executeLookBack(long startTime, Long endTime) throws Exception {
            this.datafeedJobLock.lock();
            this.lookbackFinished = false;
            try {
                if (this.isRunning() && !this.isIsolated()) {
                    Long l = this.datafeedJob.runLookBack(startTime, endTime);
                    return l;
                }
                Long l = null;
                return l;
            }
            finally {
                this.datafeedJobLock.unlock();
            }
        }

        private long executeRealTime() throws Exception {
            this.datafeedJobLock.lock();
            try {
                if (this.isRunning() && !this.isIsolated()) {
                    long l = this.datafeedJob.runRealtime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            finally {
                this.datafeedJobLock.unlock();
            }
        }

        private void closeJob() {
            ClusterState clusterState = DatafeedRunner.this.clusterService.state();
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
            JobState jobState = MlTasks.getJobState((String)this.getJobId(), (PersistentTasksCustomMetadata)tasks);
            if (jobState != JobState.OPENED) {
                logger.debug("[{}] No need to auto-close job as job state is [{}]", (Object)this.getJobId(), (Object)jobState);
                return;
            }
            this.task.waitForPersistentTask(Objects::isNull, TimeValue.timeValueSeconds((long)20L), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<StartDatafeedAction.DatafeedParams>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                    CloseJobAction.Request closeJobRequest = new CloseJobAction.Request(Holder.this.getJobId());
                    closeJobRequest.setLocal(true);
                    ClientHelper.executeAsyncWithOrigin((Client)DatafeedRunner.this.client, (String)"ml", (ActionType)CloseJobAction.INSTANCE, (ActionRequest)closeJobRequest, (ActionListener)new ActionListener<CloseJobAction.Response>(){

                        public void onResponse(CloseJobAction.Response response) {
                            if (!response.isClosed()) {
                                logger.error("[{}] job close action was not acknowledged", (Object)Holder.this.getJobId());
                            }
                        }

                        public void onFailure(Exception e) {
                            ElasticsearchStatusException exception;
                            if (e instanceof ElasticsearchStatusException && (exception = (ElasticsearchStatusException)((Object)e)).status() == RestStatus.CONFLICT) {
                                logger.debug("[{}] {}", (Object)Holder.this.getJobId(), (Object)e.getMessage());
                            } else {
                                logger.error("[" + Holder.this.getJobId() + "] failed to auto-close job", (Throwable)e);
                            }
                        }
                    });
                }

                public void onFailure(Exception e) {
                    logger.error("Failed to remove datafeed persistent task - will not auto close job [" + Holder.this.getJobId() + "]", (Throwable)e);
                }
            });
        }
    }
}

