/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;

public class NodeAvailabilityZoneMapper
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(NodeAvailabilityZoneMapper.class);
    private volatile List<String> awarenessAttributes;
    private volatile DiscoveryNodes lastDiscoveryNodes;
    private volatile Map<List<String>, Collection<DiscoveryNode>> allNodesByAvailabilityZone;
    private volatile Map<List<String>, Collection<DiscoveryNode>> mlNodesByAvailabilityZone;

    public NodeAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings) {
        this(settings, clusterSettings, null);
    }

    public NodeAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings, DiscoveryNodes discoveryNodes) {
        this.awarenessAttributes = (List)AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        this.lastDiscoveryNodes = discoveryNodes;
        this.updateNodesByAvailabilityZone();
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
    }

    private synchronized void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = List.copyOf(awarenessAttributes);
        this.updateNodesByAvailabilityZone();
    }

    public List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    public Map<List<String>, Collection<DiscoveryNode>> getAllNodesByAvailabilityZone() {
        return this.allNodesByAvailabilityZone;
    }

    public OptionalInt getNumAvailabilityZones() {
        return this.lastDiscoveryNodes == null ? OptionalInt.empty() : OptionalInt.of(this.allNodesByAvailabilityZone.size());
    }

    public Map<List<String>, Collection<DiscoveryNode>> getMlNodesByAvailabilityZone() {
        return this.mlNodesByAvailabilityZone;
    }

    public OptionalInt getNumMlAvailabilityZones() {
        return this.lastDiscoveryNodes == null ? OptionalInt.empty() : OptionalInt.of(this.mlNodesByAvailabilityZone.size());
    }

    public synchronized void clusterChanged(ClusterChangedEvent event) {
        if (this.lastDiscoveryNodes == null || event.nodesChanged()) {
            this.lastDiscoveryNodes = event.state().nodes();
            this.updateNodesByAvailabilityZone();
        }
    }

    private synchronized void updateNodesByAvailabilityZone() {
        if (this.lastDiscoveryNodes == null) {
            this.allNodesByAvailabilityZone = Map.of();
            this.mlNodesByAvailabilityZone = this.allNodesByAvailabilityZone;
            return;
        }
        NodesByAvailabilityZone nodesByAvailabilityZone = NodeAvailabilityZoneMapper.buildNodesByAvailabilityZone(this.lastDiscoveryNodes, this.awarenessAttributes);
        this.allNodesByAvailabilityZone = nodesByAvailabilityZone.allNodes;
        this.mlNodesByAvailabilityZone = nodesByAvailabilityZone.mlNodes;
    }

    private static NodesByAvailabilityZone buildNodesByAvailabilityZone(DiscoveryNodes discoveryNodes, List<String> awarenessAttributes) {
        Collection nodes = discoveryNodes.getNodes().values();
        if (awarenessAttributes.isEmpty()) {
            return new NodesByAvailabilityZone(Map.of(List.of(), nodes), Map.of(List.of(), nodes.stream().filter(n -> n.getRoles().contains(DiscoveryNodeRole.ML_ROLE)).toList()));
        }
        HashMap<List, Collection> allNodesByAvailabilityZone = new HashMap<List, Collection>();
        HashMap<List, Collection> mlNodesByAvailabilityZone = new HashMap<List, Collection>();
        for (DiscoveryNode node : nodes) {
            List<String> orderedNodeAttributeValues = awarenessAttributes.stream().map(a -> {
                String v = (String)node.getAttributes().get(a);
                if (v == null) {
                    logger.debug("Node [{}] does not have all configured awareness attributes {} - missing [{}]", (Object)node, (Object)awarenessAttributes, a);
                    return "";
                }
                return v;
            }).toList();
            allNodesByAvailabilityZone.computeIfAbsent(orderedNodeAttributeValues, k -> new ArrayList()).add(node);
            if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) continue;
            mlNodesByAvailabilityZone.compute(orderedNodeAttributeValues, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<DiscoveryNode>();
                }
                v.add(node);
                return v;
            });
        }
        return new NodesByAvailabilityZone(Map.copyOf(allNodesByAvailabilityZone), Map.copyOf(mlNodesByAvailabilityZone));
    }

    public Map<List<String>, Collection<DiscoveryNode>> buildMlNodesByAvailabilityZone(ClusterState clusterState) {
        return NodeAvailabilityZoneMapper.buildNodesByAvailabilityZone((DiscoveryNodes)clusterState.nodes(), this.awarenessAttributes).mlNodes;
    }

    private record NodesByAvailabilityZone(Map<List<String>, Collection<DiscoveryNode>> allNodes, Map<List<String>, Collection<DiscoveryNode>> mlNodes) {
    }
}

