/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.FrequentItemSetsAggregatorFactory;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public final class FrequentItemSetsAggregationBuilder
extends AbstractAggregationBuilder<FrequentItemSetsAggregationBuilder> {
    public static final String NAME = "frequent_item_sets";
    public static final String DEPRECATED_NAME = "frequent_items";
    public static final double DEFAULT_MINIMUM_SUPPORT = 0.01;
    public static final int DEFAULT_MINIMUM_SET_SIZE = 1;
    public static final int DEFAULT_SIZE = 10;
    public static final List<String> EXECUTION_HINT_ALLOWED_MODES = List.of("global_ordinals", "map");
    public static final ParseField MINIMUM_SUPPORT = new ParseField("minimum_support", new String[0]);
    public static final ParseField MINIMUM_SET_SIZE = new ParseField("minimum_set_size", new String[0]);
    public static final ParseField FIELDS = new ParseField("fields", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD_NAME = new ParseField("execution_hint", new String[0]);
    public static final ConstructingObjectParser<FrequentItemSetsAggregationBuilder, String> PARSER = new ConstructingObjectParser("frequent_item_sets", false, (args, context) -> {
        List fields = (List)args[0];
        double minimumSupport = args[1] == null ? 0.01 : (Double)args[1];
        int minimumSetSize = args[2] == null ? 1 : (Integer)args[2];
        int size = args[3] == null ? 10 : (Integer)args[3];
        QueryBuilder filter = (QueryBuilder)args[4];
        String executionHint = (String)args[5];
        return new FrequentItemSetsAggregationBuilder((String)context, fields, minimumSupport, minimumSetSize, size, filter, executionHint);
    });
    static final ValuesSourceRegistry.RegistryKey<ItemSetMapReduceValueSource.ValueSourceSupplier> REGISTRY_KEY;
    private final List<MultiValuesSourceFieldConfig> fields;
    private final double minimumSupport;
    private final int minimumSetSize;
    private final int size;
    private final QueryBuilder filter;
    private final String executionHint;

    public static void registerAggregators(ValuesSourceRegistry.Builder registry) {
        registry.registerUsage(NAME);
        registry.register(REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD, CoreValuesSourceType.IP), ItemSetMapReduceValueSource.KeywordValueSource::new, false);
        registry.register(REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), ItemSetMapReduceValueSource.NumericValueSource::new, false);
    }

    public FrequentItemSetsAggregationBuilder(String name, List<MultiValuesSourceFieldConfig> fields, double minimumSupport, int minimumSetSize, int size, QueryBuilder filter, String executionHint) {
        super(name);
        this.fields = fields;
        if (minimumSupport <= 0.0 || minimumSupport > 1.0) {
            throw new IllegalArgumentException("[minimum_support] must be greater than 0 and less or equal to 1. Found [" + minimumSupport + "] in [" + name + "]");
        }
        this.minimumSupport = minimumSupport;
        if (minimumSetSize <= 0) {
            throw new IllegalArgumentException("[minimum_set_size] must be greater than 0. Found [" + minimumSetSize + "] in [" + name + "]");
        }
        this.minimumSetSize = minimumSetSize;
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + name + "]");
        }
        this.size = size;
        this.filter = filter;
        if (executionHint != null && !EXECUTION_HINT_ALLOWED_MODES.contains(executionHint)) {
            throw new IllegalArgumentException(Strings.format((String)"[execution_hint] must be one of [%s]. Found [%s]", (Object[])new Object[]{Strings.collectionToCommaDelimitedString(EXECUTION_HINT_ALLOWED_MODES), executionHint}));
        }
        this.executionHint = executionHint;
    }

    public FrequentItemSetsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readCollectionAsList(MultiValuesSourceFieldConfig::new);
        this.minimumSupport = in.readDouble();
        this.minimumSetSize = in.readVInt();
        this.size = in.readVInt();
        this.filter = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_6_0) ? (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class) : null;
        this.executionHint = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_7_0) ? in.readOptionalString() : null;
    }

    public boolean supportsSampling() {
        return true;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new FrequentItemSetsAggregationBuilder(this.name, this.fields, this.minimumSupport, this.minimumSetSize, this.size, this.filter, this.executionHint);
    }

    public String getType() {
        return NAME;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeCollection(this.fields);
        out.writeDouble(this.minimumSupport);
        out.writeVInt(this.minimumSetSize);
        out.writeVInt(this.size);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_6_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.filter);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_7_0)) {
            out.writeOptionalString(this.executionHint);
        }
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        return new FrequentItemSetsAggregatorFactory(this.name, context, parent, subfactoriesBuilder, this.metadata, this.fields, this.minimumSupport, this.minimumSetSize, this.size, this.filter, this.executionHint);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(FIELDS.getPreferredName());
        for (MultiValuesSourceFieldConfig field : this.fields) {
            field.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(MINIMUM_SUPPORT.getPreferredName(), this.minimumSupport);
        builder.field(MINIMUM_SET_SIZE.getPreferredName(), this.minimumSetSize);
        builder.field(Aggregation.CommonFields.SIZE.getPreferredName(), this.size);
        if (this.filter != null) {
            builder.field(MultiValuesSourceFieldConfig.FILTER.getPreferredName(), (ToXContent)this.filter);
        }
        builder.endObject();
        return builder;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    public FrequentItemSetsAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new IllegalArgumentException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
    }

    public FrequentItemSetsAggregationBuilder subAggregation(AggregationBuilder aggregation) {
        throw new IllegalArgumentException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_4_0;
    }

    private static /* synthetic */ MultiValuesSourceFieldConfig lambda$static$1(ContextParser fieldsParser, XContentParser p, String n) throws IOException {
        return ((MultiValuesSourceFieldConfig.Builder)fieldsParser.parse(p, null)).build();
    }

    static {
        ObjectParser fieldsParser = MultiValuesSourceFieldConfig.parserBuilder((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FrequentItemSetsAggregationBuilder.lambda$static$1((ContextParser)fieldsParser, arg_0, arg_1), FIELDS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MINIMUM_SUPPORT);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MINIMUM_SET_SIZE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), Aggregation.CommonFields.SIZE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, context) -> AbstractQueryBuilder.parseTopLevelQuery((XContentParser)p), MultiValuesSourceFieldConfig.FILTER, ObjectParser.ValueType.OBJECT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), EXECUTION_HINT_FIELD_NAME);
        REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey(NAME, ItemSetMapReduceValueSource.ValueSourceSupplier.class);
    }
}

