/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.TrainedModelCacheInfoAction;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;

public class TransportTrainedModelCacheInfoAction
extends TransportNodesAction<TrainedModelCacheInfoAction.Request, TrainedModelCacheInfoAction.Response, NodeModelCacheInfoRequest, TrainedModelCacheInfoAction.Response.CacheInfo> {
    private final ModelLoadingService modelLoadingService;

    @Inject
    public TransportTrainedModelCacheInfoAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ModelLoadingService modelLoadingService) {
        super("cluster:internal/xpack/ml/trained_models/cache/info", threadPool, clusterService, transportService, actionFilters, TrainedModelCacheInfoAction.Request::new, NodeModelCacheInfoRequest::new, (Executor)threadPool.executor("management"));
        this.modelLoadingService = modelLoadingService;
    }

    protected TrainedModelCacheInfoAction.Response newResponse(TrainedModelCacheInfoAction.Request request, List<TrainedModelCacheInfoAction.Response.CacheInfo> responses, List<FailedNodeException> failures) {
        return new TrainedModelCacheInfoAction.Response(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeModelCacheInfoRequest newNodeRequest(TrainedModelCacheInfoAction.Request request) {
        return new NodeModelCacheInfoRequest(request);
    }

    protected TrainedModelCacheInfoAction.Response.CacheInfo newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new TrainedModelCacheInfoAction.Response.CacheInfo(in);
    }

    protected TrainedModelCacheInfoAction.Response.CacheInfo nodeOperation(NodeModelCacheInfoRequest nodeModelCacheInfoRequest, Task task) {
        assert (task instanceof CancellableTask);
        return new TrainedModelCacheInfoAction.Response.CacheInfo(this.transportService.getLocalNode(), this.modelLoadingService.getMaxCacheSize(), this.modelLoadingService.getCurrentCacheSize());
    }

    public static class NodeModelCacheInfoRequest
    extends TransportRequest {
        TrainedModelCacheInfoAction.Request request;

        public NodeModelCacheInfoRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new TrainedModelCacheInfoAction.Request(in);
        }

        NodeModelCacheInfoRequest(TrainedModelCacheInfoAction.Request request) {
            this.request = request;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

