/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TransportPutFilterAction
extends HandledTransportAction<PutFilterAction.Request, PutFilterAction.Response> {
    private final Client client;

    @Inject
    public TransportPutFilterAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/ml/filters/put", transportService, actionFilters, PutFilterAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
    }

    protected void doExecute(Task task, PutFilterAction.Request request, final ActionListener<PutFilterAction.Response> listener) {
        final MlFilter filter = request.getFilter();
        IndexRequest indexRequest = new IndexRequest(MlMetaIndex.indexName()).id(filter.documentId());
        indexRequest.opType(DocWriteRequest.OpType.CREATE);
        indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true"));
            indexRequest.source(filter.toXContent(builder, (ToXContent.Params)params));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialise filter with id [" + filter.getId() + "]", e);
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)new ActionListener<DocWriteResponse>(){

            public void onResponse(DocWriteResponse indexResponse) {
                listener.onResponse((Object)new PutFilterAction.Response(filter));
            }

            public void onFailure(Exception e) {
                Object reportedException = ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException ? new ResourceAlreadyExistsException("A filter with id [" + filter.getId() + "] already exists", new Object[0]) : ExceptionsHelper.serverError((String)("Error putting filter with id [" + filter.getId() + "]"), (Throwable)e);
                listener.onFailure((Exception)reportedException);
            }
        });
    }
}

