/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetMlAutoscalingStats;
import org.elasticsearch.xpack.core.ml.autoscaling.MlAutoscalingStats;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingResourceTracker;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportGetMlAutoscalingStats
extends TransportMasterNodeAction<GetMlAutoscalingStats.Request, GetMlAutoscalingStats.Response> {
    private final Client client;
    private final MlMemoryTracker mlMemoryTracker;
    private final Settings settings;
    private final Executor timeoutExecutor;

    @Inject
    public TransportGetMlAutoscalingStats(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, Settings settings, MlMemoryTracker mlMemoryTracker) {
        super("cluster:monitor/xpack/ml/autoscaling/stats/get", transportService, clusterService, threadPool, actionFilters, GetMlAutoscalingStats.Request::new, indexNameExpressionResolver, GetMlAutoscalingStats.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.mlMemoryTracker = mlMemoryTracker;
        this.settings = settings;
        this.timeoutExecutor = threadPool.generic();
    }

    protected void masterOperation(Task task, GetMlAutoscalingStats.Request request, ClusterState state, ActionListener<GetMlAutoscalingStats.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskAssigningClient = new ParentTaskAssigningClient(this.client, parentTaskId);
        if (this.mlMemoryTracker.isRecentlyRefreshed()) {
            MlAutoscalingResourceTracker.getMlAutoscalingStats(state, this.clusterService.getClusterSettings(), (Client)parentTaskAssigningClient, request.timeout(), this.mlMemoryTracker, this.settings, (ActionListener<MlAutoscalingStats>)ActionListener.wrap(autoscalingResources -> listener.onResponse((Object)new GetMlAutoscalingStats.Response(autoscalingResources)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.mlMemoryTracker.refresh((PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks"), (ActionListener<Void>)ListenerTimeouts.wrapWithTimeout((ThreadPool)this.threadPool, (TimeValue)request.timeout(), (Executor)this.timeoutExecutor, (ActionListener)ActionListener.wrap(ignored -> MlAutoscalingResourceTracker.getMlAutoscalingStats(state, this.clusterService.getClusterSettings(), (Client)parentTaskAssigningClient, request.timeout(), this.mlMemoryTracker, this.settings, (ActionListener<MlAutoscalingStats>)ActionListener.wrap(autoscalingResources -> listener.onResponse((Object)new GetMlAutoscalingStats.Response(autoscalingResources)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)), timeoutTrigger -> listener.onFailure((Exception)new ElasticsearchStatusException("ML autoscaling metrics could not be retrieved in time, but should be available shortly.", RestStatus.REQUEST_TIMEOUT, new Object[0]))));
        }
    }

    protected ClusterBlockException checkBlock(GetMlAutoscalingStats.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

