/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.task.JobTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;

public class TransportForecastJobAction
extends TransportJobTaskAction<ForecastJobAction.Request, ForecastJobAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportForecastJobAction.class);
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;
    private final NativeStorageProvider nativeStorageProvider;
    private final AnomalyDetectionAuditor auditor;
    private final long cppMinAvailableDiskSpaceBytes;

    @Inject
    public TransportForecastJobAction(TransportService transportService, Settings settings, ClusterService clusterService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, AutodetectProcessManager processManager, JobManager jobManager, NativeStorageProvider nativeStorageProvider, AnomalyDetectionAuditor auditor) {
        super("cluster:admin/xpack/ml/job/forecast", clusterService, transportService, actionFilters, ForecastJobAction.Request::new, ForecastJobAction.Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE, processManager);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
        this.nativeStorageProvider = nativeStorageProvider;
        this.auditor = auditor;
        this.cppMinAvailableDiskSpaceBytes = ((ByteSizeValue)MachineLearning.MIN_DISK_SPACE_OFF_HEAP.get(settings)).getBytes() / 5L * 4L;
    }

    protected void taskOperation(CancellableTask actionTask, ForecastJobAction.Request request, JobTask task, ActionListener<ForecastJobAction.Response> listener) {
        this.jobManager.getJob(task.getJobId(), (ActionListener<Job>)ActionListener.wrap(job -> {
            Path tmpStorage;
            Long adjustedLimit;
            TransportForecastJobAction.validate(job, request);
            ForecastParams.Builder paramsBuilder = ForecastParams.builder();
            if (request.getDuration() != null) {
                paramsBuilder.duration(request.getDuration());
            }
            if (request.getExpiresIn() != null) {
                paramsBuilder.expiresIn(request.getExpiresIn());
            }
            if ((adjustedLimit = TransportForecastJobAction.getAdjustedMemoryLimit(job, request.getMaxModelMemory(), this.auditor)) != null) {
                paramsBuilder.maxModelMemory(adjustedLimit);
            }
            if ((tmpStorage = this.nativeStorageProvider.tryGetLocalTmpStorage(task.getDescription(), ForecastJobAction.Request.FORECAST_LOCAL_STORAGE_LIMIT)) != null) {
                paramsBuilder.tmpStorage(tmpStorage.toString());
            }
            if (this.cppMinAvailableDiskSpaceBytes >= 0L) {
                paramsBuilder.minAvailableDiskSpace(this.cppMinAvailableDiskSpaceBytes);
            }
            ForecastParams params = paramsBuilder.build();
            this.processManager.forecastJob(task, params, e -> {
                if (e == null) {
                    this.getForecastRequestStats(request.getJobId(), params.getForecastId(), listener);
                } else {
                    listener.onFailure(e);
                }
            });
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getForecastRequestStats(String jobId, String forecastId, ActionListener<ForecastJobAction.Response> listener) {
        Consumer<ForecastRequestStats> forecastRequestStatsHandler = forecastRequestStats -> {
            if (forecastRequestStats == null) {
                listener.onFailure((Exception)new ElasticsearchException("Cannot run forecast: internal error, please check the logs", new Object[0]));
            } else if (forecastRequestStats.getStatus() == ForecastRequestStats.ForecastRequestStatus.FAILED) {
                List messages = forecastRequestStats.getMessages();
                if (messages.size() > 0) {
                    Object message = (String)messages.get(0);
                    if (((String)message).contains("disk space is insufficient")) {
                        message = (String)message + " Minimum disk space required: [" + this.processManager.getMinLocalStorageAvailable() + "]";
                    }
                    listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Cannot run forecast: " + (String)message), (Object[])new Object[0]));
                } else {
                    listener.onFailure((Exception)new ElasticsearchException("Cannot run forecast: internal error, please check the logs", new Object[0]));
                }
            } else {
                listener.onResponse((Object)new ForecastJobAction.Response(true, forecastId));
            }
        };
        this.jobResultsProvider.getForecastRequestStats(jobId, forecastId, forecastRequestStatsHandler, arg_0 -> listener.onFailure(arg_0));
    }

    static Long getAdjustedMemoryLimit(Job job, Long requestedLimit, AbstractAuditor<? extends AbstractAuditMessage> auditor) {
        if (requestedLimit == null) {
            return null;
        }
        long jobLimitMegaBytes = job.getAnalysisLimits() == null || job.getAnalysisLimits().getModelMemoryLimit() == null ? 4096L : job.getAnalysisLimits().getModelMemoryLimit();
        long allowedMax = (long)((double)ByteSizeValue.ofMb((long)jobLimitMegaBytes).getBytes() * 0.4);
        long adjustedMax = Math.min(requestedLimit, allowedMax - 1L);
        if (adjustedMax != requestedLimit) {
            String msg = "requested forecast memory limit [" + requestedLimit + "] bytes is greater than or equal to [" + allowedMax + "] bytes (40% of the job memory limit). Reducing to [" + adjustedMax + "].";
            logger.warn("[{}] {}", (Object)job.getId(), (Object)msg);
            auditor.warning(job.getId(), msg);
        }
        return adjustedMax;
    }

    static void validate(Job job, ForecastJobAction.Request request) {
        TimeValue bucketSpan;
        TimeValue duration;
        if (job.getJobVersion() == null || job.getJobVersion().before((VersionId)MlConfigVersion.fromString((String)"6.1.0"))) {
            throw ExceptionsHelper.badRequestException((String)"Cannot run forecast because jobs created prior to version 6.1 are not supported", (Object[])new Object[0]);
        }
        if (request.getDuration() != null && (duration = request.getDuration()).compareTo(bucketSpan = job.getAnalysisConfig().getBucketSpan()) < 0) {
            throw ExceptionsHelper.badRequestException((String)("[" + ForecastJobAction.Request.DURATION.getPreferredName() + "] must be greater or equal to the bucket span: [" + duration.getStringRep() + "/" + bucketSpan.getStringRep() + "]"), (Object[])new Object[0]);
        }
    }
}

