/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class MlDailyMaintenanceService
implements Releasable {
    private static final Logger logger = LogManager.getLogger(MlDailyMaintenanceService.class);
    private static final int MAX_TIME_OFFSET_MINUTES = 120;
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final MlAssignmentNotifier mlAssignmentNotifier;
    private final Supplier<TimeValue> schedulerProvider;
    private final boolean isAnomalyDetectionEnabled;
    private final boolean isDataFrameAnalyticsEnabled;
    private final boolean isNlpEnabled;
    private volatile Scheduler.Cancellable cancellable;
    private volatile float deleteExpiredDataRequestsPerSecond;

    MlDailyMaintenanceService(Settings settings, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier, Supplier<TimeValue> scheduleProvider, boolean isAnomalyDetectionEnabled, boolean isDataFrameAnalyticsEnabled, boolean isNlpEnabled) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.mlAssignmentNotifier = Objects.requireNonNull(mlAssignmentNotifier);
        this.schedulerProvider = Objects.requireNonNull(scheduleProvider);
        this.deleteExpiredDataRequestsPerSecond = ((Float)MachineLearning.NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND.get(settings)).floatValue();
        this.isAnomalyDetectionEnabled = isAnomalyDetectionEnabled;
        this.isDataFrameAnalyticsEnabled = isDataFrameAnalyticsEnabled;
        this.isNlpEnabled = isNlpEnabled;
    }

    public MlDailyMaintenanceService(Settings settings, ClusterName clusterName, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier, boolean isAnomalyDetectionEnabled, boolean isDataFrameAnalyticsEnabled, boolean isNlpEnabled) {
        this(settings, threadPool, client, clusterService, mlAssignmentNotifier, () -> MlDailyMaintenanceService.delayToNextTime(clusterName), isAnomalyDetectionEnabled, isDataFrameAnalyticsEnabled, isNlpEnabled);
    }

    void setDeleteExpiredDataRequestsPerSecond(float value) {
        this.deleteExpiredDataRequestsPerSecond = value;
    }

    private static TimeValue delayToNextTime(ClusterName clusterName) {
        Random random = new Random(clusterName.hashCode());
        int minutesOffset = random.ints(0, 120).findFirst().getAsInt();
        ZonedDateTime now = ZonedDateTime.now(Clock.systemDefaultZone());
        ZonedDateTime next = now.plusDays(1L).toLocalDate().atStartOfDay(now.getZone()).plusMinutes(30L).plusMinutes(minutesOffset);
        return TimeValue.timeValueMillis((long)(next.toInstant().toEpochMilli() - now.toInstant().toEpochMilli()));
    }

    public synchronized void start() {
        logger.debug("Starting ML daily maintenance service");
        this.scheduleNext();
    }

    public synchronized void stop() {
        logger.debug("Stopping ML daily maintenance service");
        if (this.cancellable != null && !this.cancellable.isCancelled()) {
            this.cancellable.cancel();
        }
    }

    boolean isStarted() {
        return this.cancellable != null;
    }

    public void close() {
        this.stop();
    }

    private synchronized void scheduleNext() {
        try {
            this.cancellable = this.threadPool.schedule(this::triggerTasks, this.schedulerProvider.get(), (Executor)this.threadPool.generic());
        }
        catch (EsRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                logger.debug("failed to schedule next maintenance task; shutting down", (Throwable)e);
            }
            throw e;
        }
    }

    private void triggerTasks() {
        try {
            if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode()) {
                logger.warn("skipping scheduled [ML] maintenance tasks because upgrade mode is enabled");
                return;
            }
            if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isResetMode()) {
                logger.warn("skipping scheduled [ML] maintenance tasks because machine learning feature reset is in progress");
                return;
            }
            logger.info("triggering scheduled [ML] maintenance tasks");
            if (this.isAnomalyDetectionEnabled) {
                this.triggerAnomalyDetectionMaintenance();
            }
            if (this.isDataFrameAnalyticsEnabled) {
                this.triggerDataFrameAnalyticsMaintenance();
            }
            if (this.isNlpEnabled) {
                this.triggerNlpMaintenance();
            }
            this.auditUnassignedMlTasks();
        }
        finally {
            this.scheduleNext();
        }
    }

    private void triggerAnomalyDetectionMaintenance() {
        ActionListener finalListener = ActionListener.wrap(unused -> {}, e -> logger.error("An error occurred during [ML] maintenance tasks execution", (Throwable)e));
        ActionListener deleteJobsListener = ActionListener.wrap(unused -> this.triggerDeleteExpiredDataTask((ActionListener<AcknowledgedResponse>)finalListener), e -> {
            logger.info("[ML] maintenance task: triggerDeleteJobsInStateDeletingWithoutDeletionTask failed", (Throwable)e);
            this.triggerDeleteExpiredDataTask((ActionListener<AcknowledgedResponse>)finalListener);
        });
        this.triggerDeleteJobsInStateDeletingWithoutDeletionTask((ActionListener<AcknowledgedResponse>)deleteJobsListener);
    }

    private void triggerDataFrameAnalyticsMaintenance() {
    }

    private void triggerNlpMaintenance() {
    }

    private void triggerDeleteExpiredDataTask(ActionListener<AcknowledgedResponse> finalListener) {
        ActionListener deleteExpiredDataActionListener = ActionListener.wrap(deleteExpiredDataResponse -> {
            if (deleteExpiredDataResponse.isDeleted()) {
                logger.info("Successfully completed [ML] maintenance task: triggerDeleteExpiredDataTask");
            } else {
                logger.info("Halting [ML] maintenance tasks before completion as elapsed time is too great");
            }
            finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteExpiredDataAction.INSTANCE, (ActionRequest)new DeleteExpiredDataAction.Request(Float.valueOf(this.deleteExpiredDataRequestsPerSecond), TimeValue.timeValueHours((long)8L)), (ActionListener)deleteExpiredDataActionListener);
    }

    public void triggerDeleteJobsInStateDeletingWithoutDeletionTask(ActionListener<AcknowledgedResponse> finalListener) {
        SetOnce jobsInStateDeletingHolder = new SetOnce();
        ActionListener deleteJobsActionListener = ActionListener.wrap(deleteJobsResponses -> {
            List jobIds = deleteJobsResponses.stream().filter(t -> !((AcknowledgedResponse)t.v2()).isAcknowledged()).map(Tuple::v1).map(DeleteJobAction.Request::getJobId).collect(Collectors.toList());
            if (jobIds.isEmpty()) {
                logger.info("Successfully completed [ML] maintenance task: triggerDeleteJobsInStateDeletingWithoutDeletionTask");
            } else {
                logger.info("The following ML jobs could not be deleted: [" + String.join((CharSequence)",", jobIds) + "]");
            }
            finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener listTasksActionListener = ActionListener.wrap(listTasksResponse -> {
            Set jobsWithDeletionTask;
            Set jobsInStateDeleting = (Set)jobsInStateDeletingHolder.get();
            Set jobsInStateDeletingWithoutDeletionTask = Sets.difference((Set)jobsInStateDeleting, jobsWithDeletionTask = listTasksResponse.getTasks().stream().filter(t -> t.description() != null).filter(t -> t.description().startsWith("delete-job-")).map(t -> t.description().substring("delete-job-".length())).collect(Collectors.toSet()));
            if (jobsInStateDeletingWithoutDeletionTask.isEmpty()) {
                finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            TypedChainTaskExecutor<Tuple> chainTaskExecutor = new TypedChainTaskExecutor<Tuple>(EsExecutors.DIRECT_EXECUTOR_SERVICE, unused -> true, unused -> true);
            for (String jobId : jobsInStateDeletingWithoutDeletionTask) {
                DeleteJobAction.Request request = new DeleteJobAction.Request(jobId);
                chainTaskExecutor.add(listener -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteJobAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)Tuple.tuple((Object)request, (Object)response)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
            }
            chainTaskExecutor.execute((ActionListener<List<Tuple>>)deleteJobsActionListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener getJobsActionListener = ActionListener.wrap(getJobsResponse -> {
            Set jobsInStateDeleting = getJobsResponse.getResponse().results().stream().filter(Job::isDeleting).map(Job::getId).collect(Collectors.toSet());
            if (jobsInStateDeleting.isEmpty()) {
                finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            jobsInStateDeletingHolder.set(jobsInStateDeleting);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)ListTasksAction.INSTANCE, (ActionRequest)((ListTasksRequest)new ListTasksRequest().setActions(new String[]{"cluster:admin/xpack/ml/job/delete"})), (ActionListener)listTasksActionListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetJobsAction.INSTANCE, (ActionRequest)new GetJobsAction.Request("*"), (ActionListener)getJobsActionListener);
    }

    private void auditUnassignedMlTasks() {
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        if (tasks != null) {
            this.mlAssignmentNotifier.auditUnassignedMlTasks(state.nodes(), tasks);
        }
    }
}

