/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elser;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.MapParsingUtils;
import org.elasticsearch.xpack.inference.services.elser.ElserMlNodeService;

public class ElserMlNodeServiceSettings
implements ServiceSettings {
    public static final String NAME = "elser_mlnode_service_settings";
    public static final String NUM_ALLOCATIONS = "num_allocations";
    public static final String NUM_THREADS = "num_threads";
    public static final String MODEL_VERSION = "model_version";
    private final int numAllocations;
    private final int numThreads;
    private final String modelVariant;

    public static Builder fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Integer numAllocations = MapParsingUtils.removeAsType(map, NUM_ALLOCATIONS, Integer.class);
        Integer numThreads = MapParsingUtils.removeAsType(map, NUM_THREADS, Integer.class);
        if (numAllocations == null) {
            validationException.addValidationError(MapParsingUtils.missingSettingErrorMsg(NUM_ALLOCATIONS, "service_settings"));
        } else if (numAllocations < 1) {
            validationException.addValidationError(ElserMlNodeServiceSettings.mustBeAPositiveNumberError(NUM_ALLOCATIONS, numAllocations));
        }
        if (numThreads == null) {
            validationException.addValidationError(MapParsingUtils.missingSettingErrorMsg(NUM_THREADS, "service_settings"));
        } else if (numThreads < 1) {
            validationException.addValidationError(ElserMlNodeServiceSettings.mustBeAPositiveNumberError(NUM_THREADS, numThreads));
        }
        String version = MapParsingUtils.removeAsType(map, MODEL_VERSION, String.class);
        if (version != null && !ElserMlNodeService.VALID_ELSER_MODELS.contains(version)) {
            validationException.addValidationError("unknown ELSER model version [" + version + "]");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        Builder builder = new Builder();
        builder.setNumAllocations(numAllocations);
        builder.setNumThreads(numThreads);
        builder.setModelVariant(version);
        return builder;
    }

    public ElserMlNodeServiceSettings(int numAllocations, int numThreads, String variant) {
        this.numAllocations = numAllocations;
        this.numThreads = numThreads;
        this.modelVariant = Objects.requireNonNull(variant);
    }

    public ElserMlNodeServiceSettings(StreamInput in) throws IOException {
        this.numAllocations = in.readVInt();
        this.numThreads = in.readVInt();
        this.modelVariant = ElserMlNodeServiceSettings.transportVersionIsCompatibleWithElserModelVersion(in.getTransportVersion()) ? in.readString() : ".elser_model_2";
    }

    static boolean transportVersionIsCompatibleWithElserModelVersion(TransportVersion transportVersion) {
        TransportVersion elserServiceModelVersionAdded = new TransportVersion(8515000);
        if (transportVersion.onOrAfter((VersionId)elserServiceModelVersionAdded)) {
            return true;
        }
        TransportVersion nextNonPatchVersion = new TransportVersion(8513000);
        return transportVersion.onOrAfter((VersionId)TransportVersions.ELSER_SERVICE_MODEL_VERSION_ADDED_PATCH) && transportVersion.before((VersionId)nextNonPatchVersion);
    }

    public int getNumAllocations() {
        return this.numAllocations;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getModelVariant() {
        return this.modelVariant;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_ALLOCATIONS, this.numAllocations);
        builder.field(NUM_THREADS, this.numThreads);
        builder.field(MODEL_VERSION, this.modelVariant);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_500_074;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numAllocations);
        out.writeVInt(this.numThreads);
        if (ElserMlNodeServiceSettings.transportVersionIsCompatibleWithElserModelVersion(out.getTransportVersion())) {
            out.writeString(this.modelVariant);
        }
    }

    public int hashCode() {
        return Objects.hash(this.numAllocations, this.numThreads, this.modelVariant);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElserMlNodeServiceSettings that = (ElserMlNodeServiceSettings)o;
        return this.numAllocations == that.numAllocations && this.numThreads == that.numThreads && Objects.equals(this.modelVariant, that.modelVariant);
    }

    private static String mustBeAPositiveNumberError(String settingName, int value) {
        return "Invalid value [" + value + "]. [" + settingName + "] must be a positive integer";
    }

    public static class Builder {
        private int numAllocations;
        private int numThreads;
        private String modelVariant;

        public void setNumAllocations(int numAllocations) {
            this.numAllocations = numAllocations;
        }

        public void setNumThreads(int numThreads) {
            this.numThreads = numThreads;
        }

        public void setModelVariant(String modelVariant) {
            this.modelVariant = modelVariant;
        }

        public String getModelVariant() {
            return this.modelVariant;
        }

        public ElserMlNodeServiceSettings build() {
            return new ElserMlNodeServiceSettings(this.numAllocations, this.numThreads, this.modelVariant);
        }
    }
}

