/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestStatus;

public class MapParsingUtils {
    public static <T> T removeAsType(Map<String, Object> sourceMap, String key, Class<T> type) {
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new ElasticsearchStatusException("field [{}] is not of the expected type. The value [{}] cannot be converted to a [{}]", RestStatus.BAD_REQUEST, new Object[]{key, o, type.getSimpleName()});
    }

    public static Map<String, Object> removeFromMapOrThrowIfNull(Map<String, Object> sourceMap, String fieldName) {
        Map value = (Map)sourceMap.remove(fieldName);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{fieldName});
        }
        return value;
    }

    public static void throwIfNotEmptyMap(Map<String, Object> settingsMap, String serviceName) {
        if (!settingsMap.isEmpty()) {
            throw MapParsingUtils.unknownSettingsError(settingsMap, serviceName);
        }
    }

    public static ElasticsearchStatusException unknownSettingsError(Map<String, Object> config, String serviceName) {
        return new ElasticsearchStatusException("Model configuration contains settings [{}] unknown to the [{}] service", RestStatus.BAD_REQUEST, new Object[]{config, serviceName});
    }

    public static String missingSettingErrorMsg(String settingName, String scope) {
        return Strings.format((String)"[%s] does not contain the required setting [%s]", (Object[])new Object[]{scope, settingName});
    }
}

