/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.utils.MlPlatformArchitecturesUtil;
import org.elasticsearch.xpack.inference.action.PutInferenceModelAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportPutInferenceModelAction
extends TransportMasterNodeAction<PutInferenceModelAction.Request, PutInferenceModelAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final Client client;

    @Inject
    public TransportPutInferenceModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry, Client client) {
        super("cluster:admin/xpack/inference/put", transportService, clusterService, threadPool, actionFilters, PutInferenceModelAction.Request::new, indexNameExpressionResolver, PutInferenceModelAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.client = client;
    }

    protected void masterOperation(Task task, PutInferenceModelAction.Request request, ClusterState state, ActionListener<PutInferenceModelAction.Response> listener) throws Exception {
        Map<String, Object> requestAsMap = this.requestToMap(request);
        String serviceName = (String)requestAsMap.remove("service");
        if (serviceName == null) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Model configuration is missing a service", RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        Optional service = this.serviceRegistry.getService(serviceName);
        if (service.isEmpty()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Unknown service [{}]", RestStatus.BAD_REQUEST, new Object[]{serviceName}));
            return;
        }
        if (((InferenceService)service.get()).isInClusterService()) {
            MlPlatformArchitecturesUtil.getMlNodesArchitecturesSet((ActionListener)ActionListener.wrap(architectures -> {
                if (architectures.isEmpty() && TransportPutInferenceModelAction.clusterIsInElasticCloud(this.clusterService.getClusterSettings())) {
                    this.parseAndStoreModel((InferenceService)service.get(), request.getModelId(), request.getTaskType(), requestAsMap, Set.of("linux-x86_64"), listener);
                } else {
                    this.parseAndStoreModel((InferenceService)service.get(), request.getModelId(), request.getTaskType(), requestAsMap, (Set<String>)architectures, listener);
                }
            }, arg_0 -> listener.onFailure(arg_0)), (Client)this.client, (ExecutorService)this.threadPool.executor("inference_utility"));
        } else {
            this.parseAndStoreModel((InferenceService)service.get(), request.getModelId(), request.getTaskType(), requestAsMap, Set.of(), listener);
        }
    }

    private void parseAndStoreModel(InferenceService service, String modelId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures, ActionListener<PutInferenceModelAction.Response> listener) {
        Model model = service.parseRequestConfig(modelId, taskType, config, platformArchitectures);
        this.modelRegistry.storeModel(model, (ActionListener<Boolean>)ActionListener.wrap(r -> TransportPutInferenceModelAction.startModel(service, model, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private static void startModel(InferenceService service, Model model, ActionListener<PutInferenceModelAction.Response> listener) {
        service.start(model, ActionListener.wrap(ok -> listener.onResponse((Object)new PutInferenceModelAction.Response(model.getConfigurations())), arg_0 -> listener.onFailure(arg_0)));
    }

    private Map<String, Object> requestToMap(PutInferenceModelAction.Request request) throws IOException {
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
            Map map = parser.map();
            return map;
        }
    }

    protected ClusterBlockException checkBlock(PutInferenceModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static boolean clusterIsInElasticCloud(ClusterSettings settings) {
        return (Boolean)settings.get(MachineLearningField.USE_AUTO_MACHINE_MEMORY_PERCENT);
    }
}

