/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.inference.UnparsedModel;
import org.elasticsearch.xpack.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.inference.action.PutInferenceModelAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportGetInferenceModelAction
extends HandledTransportAction<GetInferenceModelAction.Request, PutInferenceModelAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;

    @Inject
    public TransportGetInferenceModelAction(TransportService transportService, ActionFilters actionFilters, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry) {
        super("cluster:admin/xpack/inference/get", transportService, actionFilters, GetInferenceModelAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
    }

    protected void doExecute(Task task, GetInferenceModelAction.Request request, ActionListener<PutInferenceModelAction.Response> listener) {
        this.modelRegistry.getUnparsedModelMap(request.getModelId(), (ActionListener<ModelRegistry.ModelConfigMap>)ActionListener.wrap(modelConfigMap -> {
            UnparsedModel unparsedModel = UnparsedModel.unparsedModelFromMap(modelConfigMap.config(), modelConfigMap.secrets());
            Optional service = this.serviceRegistry.getService(unparsedModel.service());
            if (service.isEmpty()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unknown service [{}] for model [{}]. ", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service(), unparsedModel.modelId()}));
                return;
            }
            Model model = ((InferenceService)service.get()).parsePersistedConfig(unparsedModel.modelId(), unparsedModel.taskType(), unparsedModel.settings(), unparsedModel.secrets());
            listener.onResponse((Object)new PutInferenceModelAction.Response(model.getConfigurations()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

