/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class PutInferenceModelAction
extends ActionType<Response> {
    public static final PutInferenceModelAction INSTANCE = new PutInferenceModelAction();
    public static final String NAME = "cluster:admin/xpack/inference/put";

    public PutInferenceModelAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final ModelConfigurations model;

        public Response(ModelConfigurations model) {
            this.model = model;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.model = new ModelConfigurations(in);
        }

        public ModelConfigurations getModel() {
            return this.model;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.model.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.model.toXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.model, response.model);
        }

        public int hashCode() {
            return Objects.hash(this.model);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TaskType taskType;
        private final String modelId;
        private final BytesReference content;
        private final XContentType contentType;

        public Request(String taskType, String modelId, BytesReference content, XContentType contentType) {
            this.taskType = TaskType.fromStringOrStatusException((String)taskType);
            this.modelId = modelId;
            this.content = content;
            this.contentType = contentType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.taskType = TaskType.fromStream((StreamInput)in);
            this.content = in.readBytesReference();
            this.contentType = (XContentType)in.readEnum(XContentType.class);
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getModelId() {
            return this.modelId;
        }

        public BytesReference getContent() {
            return this.content;
        }

        public XContentType getContentType() {
            return this.contentType;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            this.taskType.writeTo(out);
            out.writeBytesReference(this.content);
            XContentHelper.writeTo((StreamOutput)out, (XContentType)this.contentType);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.taskType == request.taskType && Objects.equals(this.modelId, request.modelId) && Objects.equals(this.content, request.content) && this.contentType == request.contentType;
        }

        public int hashCode() {
            return Objects.hash(this.taskType, this.modelId, this.content, this.contentType);
        }
    }
}

