/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;

public class DeleteInferenceModelAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteInferenceModelAction INSTANCE = new DeleteInferenceModelAction();
    public static final String NAME = "cluster:admin/xpack/inference/delete";

    public DeleteInferenceModelAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String modelId;
        private final TaskType taskType;

        public Request(String modelId, String taskType) {
            this.modelId = modelId;
            this.taskType = TaskType.fromStringOrStatusException((String)taskType);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.taskType = TaskType.fromStream((StreamInput)in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getModelId() {
            return this.modelId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            this.taskType.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.modelId, request.modelId) && this.taskType == request.taskType;
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.taskType);
        }
    }
}

