/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;

public record UnparsedModel(String modelId, TaskType taskType, String service, Map<String, Object> settings, Map<String, Object> secrets) {
    public static UnparsedModel unparsedModelFromMap(Map<String, Object> configMap, Map<String, Object> secretsMap) {
        String modelId = UnparsedModel.removeStringOrThrowIfNull(configMap, "model_id");
        String service = UnparsedModel.removeStringOrThrowIfNull(configMap, "service");
        String taskTypeStr = UnparsedModel.removeStringOrThrowIfNull(configMap, TaskType.NAME);
        TaskType taskType = TaskType.fromString((String)taskTypeStr);
        return new UnparsedModel(modelId, taskType, service, configMap, secretsMap);
    }

    private static String removeStringOrThrowIfNull(Map<String, Object> sourceMap, String fieldName) {
        String value = (String)sourceMap.remove(fieldName);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{fieldName});
        }
        return value;
    }
}

