/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.InferenceServicePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.inference.InferenceIndex;
import org.elasticsearch.xpack.inference.InferenceNamedWriteablesProvider;
import org.elasticsearch.xpack.inference.InferenceSecretsIndex;
import org.elasticsearch.xpack.inference.action.DeleteInferenceModelAction;
import org.elasticsearch.xpack.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.inference.action.InferenceAction;
import org.elasticsearch.xpack.inference.action.PutInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportDeleteInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportGetInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportInferenceAction;
import org.elasticsearch.xpack.inference.action.TransportPutInferenceModelAction;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.rest.RestDeleteInferenceModelAction;
import org.elasticsearch.xpack.inference.rest.RestGetInferenceModelAction;
import org.elasticsearch.xpack.inference.rest.RestInferenceAction;
import org.elasticsearch.xpack.inference.rest.RestPutInferenceModelAction;
import org.elasticsearch.xpack.inference.services.elser.ElserMlNodeService;

public class InferencePlugin
extends Plugin
implements ActionPlugin,
InferenceServicePlugin,
SystemIndexPlugin {
    public static final String NAME = "inference";
    public static final String UTILITY_THREAD_POOL_NAME = "inference_utility";

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)InferenceAction.INSTANCE, TransportInferenceAction.class), new ActionPlugin.ActionHandler((ActionType)GetInferenceModelAction.INSTANCE, TransportGetInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)PutInferenceModelAction.INSTANCE, TransportPutInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteInferenceModelAction.INSTANCE, TransportDeleteInferenceModelAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestInferenceAction(), new RestGetInferenceModelAction(), new RestPutInferenceModelAction(), new RestDeleteInferenceModelAction());
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider telemetryProvider, AllocationService allocationService, IndicesService indicesService) {
        ModelRegistry modelRegistry = new ModelRegistry(client);
        return List.of(modelRegistry);
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".inference*").setPrimaryIndex(".inference").setDescription("Contains inference service and model configuration").setMappings(InferenceIndex.mappings()).setSettings(InferenceIndex.settings()).setVersionMetaKey("version").setOrigin(NAME).build(), SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".secrets-inference*").setPrimaryIndex(".secrets-inference").setDescription("Contains inference service secrets").setMappings(InferenceSecretsIndex.mappings()).setSettings(InferenceSecretsIndex.settings()).setVersionMetaKey("version").setOrigin(NAME).setNetNew().build());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings unused) {
        ScalingExecutorBuilder utility = new ScalingExecutorBuilder(UTILITY_THREAD_POOL_NAME, 0, 1, TimeValue.timeValueMinutes((long)10L), false, "xpack.inference.utility_thread_pool");
        return List.of(utility);
    }

    public String getFeatureName() {
        return "inference_plugin";
    }

    public String getFeatureDescription() {
        return "Inference plugin for managing inference services and inference";
    }

    public List<InferenceServicePlugin.Factory> getInferenceServiceFactories() {
        return List.of(ElserMlNodeService::new);
    }

    public List<NamedWriteableRegistry.Entry> getInferenceServiceNamedWriteables() {
        return InferenceNamedWriteablesProvider.getNamedWriteables();
    }
}

