/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestChunkedToXContentListener;
import org.elasticsearch.rest.action.search.RestMultiSearchAction;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.usage.SearchUsageHolder;

@ServerlessScope(value=Scope.INTERNAL)
public class RestFleetMultiSearchAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;
    private final SearchUsageHolder searchUsageHolder;

    public RestFleetMultiSearchAction(Settings settings, SearchUsageHolder searchUsageHolder) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        this.searchUsageHolder = searchUsageHolder;
    }

    public String getName() {
        return "fleet_msearch_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_fleet/_fleet_msearch"), new RestHandler.Route(RestRequest.Method.POST, "/_fleet/_fleet_msearch"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_fleet/_fleet_msearch"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_fleet/_fleet_msearch"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchRequest multiSearchRequest = RestMultiSearchAction.parseRequest((RestRequest)request, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), (boolean)this.allowExplicitIndex, (SearchUsageHolder)this.searchUsageHolder, (key, value, searchRequest) -> {
            if ("wait_for_checkpoints".equals(key)) {
                String[] stringWaitForCheckpoints = XContentMapValues.nodeStringArrayValue((Object)value);
                long[] waitForCheckpoints = new long[stringWaitForCheckpoints.length];
                for (int i = 0; i < stringWaitForCheckpoints.length; ++i) {
                    waitForCheckpoints[i] = Long.parseLong(stringWaitForCheckpoints[i]);
                }
                if (waitForCheckpoints.length != 0) {
                    searchRequest.setWaitForCheckpoints(Collections.singletonMap("*", waitForCheckpoints));
                }
                return true;
            }
            if ("wait_for_checkpoints_timeout".equals(key)) {
                TimeValue waitForCheckpointsTimeout = XContentMapValues.nodeTimeValue((Object)value, (TimeValue)TimeValue.timeValueSeconds((long)30L));
                searchRequest.setWaitForCheckpointsTimeout(waitForCheckpointsTimeout);
                return true;
            }
            return false;
        });
        for (SearchRequest searchRequest2 : multiSearchRequest.requests()) {
            long[] checkpoints;
            Object[] indices = searchRequest2.indices();
            Map waitForCheckpoints = searchRequest2.getWaitForCheckpoints();
            if (!waitForCheckpoints.isEmpty()) {
                if (indices.length == 0) {
                    throw new IllegalArgumentException("Fleet search API param wait_for_checkpoints is only supported with an index to search specified. No index specified.");
                }
                if (indices.length > 1) {
                    throw new IllegalArgumentException("Fleet search API only supports searching a single index. Found: [" + Arrays.toString(indices) + "].");
                }
            }
            if ((checkpoints = (long[])searchRequest2.getWaitForCheckpoints().get("*")) == null) continue;
            searchRequest2.setWaitForCheckpoints(Collections.singletonMap(indices[0], checkpoints));
        }
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)new RestChunkedToXContentListener(channel));
        };
    }

    protected Set<String> responseParams() {
        return RestSearchAction.RESPONSE_PARAMS;
    }
}

