/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.fleet.action.GetGlobalCheckpointsShardAction;

public class GetGlobalCheckpointsAction
extends ActionType<Response> {
    public static final GetGlobalCheckpointsAction INSTANCE = new GetGlobalCheckpointsAction();
    public static final String NAME = "indices:monitor/fleet/global_checkpoints";

    private GetGlobalCheckpointsAction() {
        super(NAME, Writeable.Reader.localOnly());
    }

    public static class LocalAction
    extends TransportAction<Request, Response> {
        private final ClusterService clusterService;
        private final NodeClient client;
        private final IndexNameExpressionResolver resolver;
        private final ThreadPool threadPool;

        @Inject
        public LocalAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, NodeClient client, IndexNameExpressionResolver resolver, ThreadPool threadPool) {
            super(GetGlobalCheckpointsAction.NAME, actionFilters, transportService.getTaskManager());
            this.clusterService = clusterService;
            this.client = client;
            this.resolver = resolver;
            this.threadPool = threadPool;
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            Index index;
            ClusterState state = this.clusterService.state();
            try {
                index = this.resolver.concreteSingleIndex(state, (IndicesRequest)request);
            }
            catch (IndexNotFoundException e) {
                if (request.waitForIndex()) {
                    this.handleIndexNotReady(state, request, listener);
                } else {
                    listener.onFailure((Exception)((Object)e));
                }
                return;
            }
            IndexMetadata indexMetadata = state.getMetadata().index(index);
            IndexRoutingTable routingTable = state.routingTable().index(index);
            if (routingTable.allPrimaryShardsActive()) {
                new CheckpointFetcher(this.client, request, listener, indexMetadata, request.timeout()).run();
            } else if (request.waitForIndex()) {
                this.handleIndexNotReady(state, request, listener);
            } else {
                int active = routingTable.primaryShardsActive();
                int total = indexMetadata.getNumberOfShards();
                listener.onFailure((Exception)new UnavailableShardsException(null, "Primary shards were not active [shards={}, active={}]", new Object[]{total, active}));
            }
        }

        private void handleIndexNotReady(ClusterState initialState, final Request request, final ActionListener<Response> listener) {
            final long startNanos = System.nanoTime();
            ClusterStateObserver observer = new ClusterStateObserver(initialState, this.clusterService, request.timeout(), this.logger, this.threadPool.getThreadContext());
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    try {
                        Index index = resolver.concreteSingleIndex(state, (IndicesRequest)request);
                        long elapsedNanos = System.nanoTime() - startNanos;
                        long remainingNanos = request.timeout().nanos() - elapsedNanos;
                        if (remainingNanos > 0L) {
                            new CheckpointFetcher(client, request, (ActionListener<Response>)listener, state.getMetadata().index(index), TimeValue.timeValueNanos((long)remainingNanos)).run();
                        } else {
                            listener.onFailure((Exception)new UnavailableShardsException(null, "Primary shards were not active within timeout [timeout={}, shards={}, active={}]", new Object[]{request.timeout(), state.getMetadata().index(index).getNumberOfShards(), state.routingTable().index(index).primaryShardsActive()}));
                        }
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onTimeout(TimeValue timeout) {
                    try {
                        ClusterState state = clusterService.state();
                        Index index = resolver.concreteSingleIndex(state, (IndicesRequest)request);
                        listener.onFailure((Exception)new UnavailableShardsException(null, "Primary shards were not active within timeout [timeout={}, shards={}, active={}]", new Object[]{request.timeout(), state.getMetadata().index(index).getNumberOfShards(), state.routingTable().index(index).primaryShardsActive()}));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(clusterService.localNode()));
                }
            }, state -> {
                try {
                    Index index = this.resolver.concreteSingleIndex(state, (IndicesRequest)request);
                    return state.routingTable().index(index).allPrimaryShardsActive();
                }
                catch (Exception e) {
                    return false;
                }
            }, request.timeout());
        }

        private static class CheckpointFetcher
        extends ActionRunnable<Response> {
            private final NodeClient client;
            private final Request request;
            private final IndexMetadata indexMetadata;
            private final TimeValue timeout;

            private CheckpointFetcher(NodeClient client, Request request, ActionListener<Response> listener, IndexMetadata indexMetadata, TimeValue timeout) {
                super(listener);
                this.client = client;
                this.request = request;
                this.indexMetadata = indexMetadata;
                this.timeout = timeout;
            }

            protected void doRun() {
                long[] checkpoints;
                int numberOfShards = this.indexMetadata.getNumberOfShards();
                if (this.request.waitForAdvance() && numberOfShards != 1) {
                    this.listener.onFailure((Exception)new ElasticsearchStatusException("wait_for_advance only supports indices with one shard. [shard count: " + numberOfShards + "]", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                int currentCheckpointCount = this.request.checkpoints().length;
                if (currentCheckpointCount != 0) {
                    if (currentCheckpointCount != numberOfShards) {
                        this.listener.onFailure((Exception)new ElasticsearchStatusException("number of checkpoints must equal number of shards. [shard count: " + numberOfShards + ", checkpoint count: " + currentCheckpointCount + "]", RestStatus.BAD_REQUEST, new Object[0]));
                        return;
                    }
                    checkpoints = this.request.checkpoints();
                } else {
                    checkpoints = new long[numberOfShards];
                    for (int i = 0; i < numberOfShards; ++i) {
                        checkpoints[i] = -1L;
                    }
                }
                final AtomicArray responses = new AtomicArray(numberOfShards);
                final AtomicBoolean timedOut = new AtomicBoolean(false);
                final CountDown countDown = new CountDown(numberOfShards);
                int i = 0;
                while (i < numberOfShards) {
                    final int shardIndex = i++;
                    GetGlobalCheckpointsShardAction.Request shardChangesRequest = new GetGlobalCheckpointsShardAction.Request(new ShardId(this.indexMetadata.getIndex(), shardIndex), this.request.waitForAdvance(), checkpoints[shardIndex], this.timeout);
                    this.client.execute((ActionType)GetGlobalCheckpointsShardAction.INSTANCE, (ActionRequest)shardChangesRequest, (ActionListener)new ActionListener<GetGlobalCheckpointsShardAction.Response>(){

                        public void onResponse(GetGlobalCheckpointsShardAction.Response response) {
                            assert (responses.get(shardIndex) == null) : "Already have a response for shard [" + shardIndex + "]";
                            if (response.timedOut()) {
                                timedOut.set(true);
                            }
                            responses.set(shardIndex, (Object)response);
                            if (countDown.countDown()) {
                                long[] globalCheckpoints = new long[responses.length()];
                                int i = 0;
                                for (GetGlobalCheckpointsShardAction.Response r : responses.asList()) {
                                    globalCheckpoints[i++] = r.getGlobalCheckpoint();
                                }
                                listener.onResponse((Object)new Response(timedOut.get(), globalCheckpoints));
                            }
                        }

                        public void onFailure(Exception e) {
                            if (countDown.fastForward()) {
                                listener.onFailure(e);
                            }
                        }
                    });
                }
            }
        }
    }

    public static class Request
    extends ActionRequest
    implements IndicesRequest {
        private final String index;
        private final boolean waitForAdvance;
        private final boolean waitForIndex;
        private final long[] checkpoints;
        private final TimeValue timeout;

        public Request(String index, boolean waitForAdvance, boolean waitForIndex, long[] checkpoints, TimeValue timeout) {
            this.index = index;
            this.waitForAdvance = waitForAdvance;
            this.waitForIndex = waitForIndex;
            this.checkpoints = checkpoints;
            this.timeout = timeout;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.waitForIndex && !this.waitForAdvance) {
                e = new ActionRequestValidationException();
                e.addValidationError("If wait_for_index is set to true, wait_for_advance must also be set to true.");
            }
            if (Arrays.stream(this.checkpoints).anyMatch(l -> l < -1L)) {
                if (e == null) {
                    e = new ActionRequestValidationException();
                }
                e.addValidationError("All checkpoints must be >= -1. Found: " + Arrays.toString(this.checkpoints));
                return e;
            }
            return e;
        }

        public TimeValue timeout() {
            return this.timeout;
        }

        public boolean waitForAdvance() {
            return this.waitForAdvance;
        }

        public boolean waitForIndex() {
            return this.waitForIndex;
        }

        public long[] checkpoints() {
            return this.checkpoints;
        }

        public String[] indices() {
            return new String[]{this.index};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public void writeTo(StreamOutput out) {
            TransportAction.localOnly();
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final boolean timedOut;
        private final long[] globalCheckpoints;

        public Response(boolean timedOut, long[] globalCheckpoints) {
            this.timedOut = timedOut;
            this.globalCheckpoints = globalCheckpoints;
        }

        public long[] globalCheckpoints() {
            return this.globalCheckpoints;
        }

        public boolean timedOut() {
            return this.timedOut;
        }

        public void writeTo(StreamOutput out) {
            TransportAction.localOnly();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("timed_out", this.timedOut);
            builder.array("global_checkpoints", this.globalCheckpoints);
            return builder.endObject();
        }
    }
}

