/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity.nodeinfo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoMetrics;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.capacity.nodeinfo.AutoscalingNodeInfo;
import org.elasticsearch.xpack.autoscaling.capacity.nodeinfo.AutoscalingNodesInfo;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class AutoscalingNodeInfoService {
    public static final Setting<TimeValue> FETCH_TIMEOUT = Setting.timeSetting((String)"xpack.autoscaling.memory.monitor.timeout", (TimeValue)TimeValue.timeValueSeconds((long)15L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final AutoscalingNodeInfo FETCHING_SENTINEL = new AutoscalingNodeInfo(Long.MIN_VALUE, Processors.MAX_PROCESSORS);
    private static final Logger logger = LogManager.getLogger(AutoscalingNodeInfoService.class);
    private volatile Map<String, AutoscalingNodeInfo> nodeToMemory = Map.of();
    private volatile TimeValue fetchTimeout;
    private final Client client;
    private final Object mutex = new Object();

    @Inject
    public AutoscalingNodeInfoService(ClusterService clusterService, Client client) {
        this.client = client;
        this.fetchTimeout = (TimeValue)FETCH_TIMEOUT.get(clusterService.getSettings());
        if (DiscoveryNode.isMasterNode((Settings)clusterService.getSettings())) {
            clusterService.addListener(this::onClusterChanged);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(FETCH_TIMEOUT, this::setFetchTimeout);
        }
    }

    private void setFetchTimeout(TimeValue fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClusterChanged(ClusterChangedEvent event) {
        boolean master = event.localNodeMaster();
        ClusterState state = event.state();
        Set<DiscoveryNode> currentNodes = master ? this.relevantNodes(state) : Set.of();
        Set<DiscoveryNode> missingNodes = null;
        Object object = this.mutex;
        synchronized (object) {
            this.retainAliveNodes(currentNodes);
            if (master) {
                missingNodes = this.addMissingNodes(currentNodes);
            }
        }
        if (missingNodes != null) {
            this.sendToMissingNodes(arg_0 -> ((DiscoveryNodes)state.nodes()).get(arg_0), missingNodes);
        }
    }

    Set<DiscoveryNode> relevantNodes(ClusterState state) {
        Set<Set<DiscoveryNodeRole>> roleSets = this.calculateAutoscalingRoleSets(state);
        return state.nodes().stream().filter(n -> roleSets.contains(n.getRoles())).collect(Collectors.toSet());
    }

    private Set<DiscoveryNode> addMissingNodes(Set<DiscoveryNode> nodes) {
        Set<DiscoveryNode> missingNodes;
        if (nodes.size() != this.nodeToMemory.size() && (missingNodes = nodes.stream().filter(dn -> !this.nodeToMemory.containsKey(dn.getEphemeralId())).collect(Collectors.toSet())).size() > 0) {
            HashMap<String, AutoscalingNodeInfo> builder = new HashMap<String, AutoscalingNodeInfo>(this.nodeToMemory);
            missingNodes.stream().map(DiscoveryNode::getEphemeralId).forEach(id -> builder.put((String)id, FETCHING_SENTINEL));
            this.nodeToMemory = Collections.unmodifiableMap(builder);
            return missingNodes;
        }
        return null;
    }

    private void sendToMissingNodes(Function<String, DiscoveryNode> nodeLookup, Set<DiscoveryNode> missingNodes) {
        Runnable onError = () -> {
            Object object = this.mutex;
            synchronized (object) {
                HashMap<String, AutoscalingNodeInfo> builder = new HashMap<String, AutoscalingNodeInfo>(this.nodeToMemory);
                missingNodes.stream().map(DiscoveryNode::getEphemeralId).forEach(builder::remove);
                this.nodeToMemory = Collections.unmodifiableMap(builder);
            }
        };
        this.client.admin().cluster().nodesStats((NodesStatsRequest)new NodesStatsRequest((String[])missingNodes.stream().map(DiscoveryNode::getId).toArray(String[]::new)).clear().addMetric(NodesStatsRequest.Metric.OS.metricName()).timeout(this.fetchTimeout), ActionListener.wrap(nodesStatsResponse -> this.client.admin().cluster().nodesInfo((NodesInfoRequest)new NodesInfoRequest((String[])nodesStatsResponse.getNodes().stream().map(BaseNodeResponse::getNode).map(DiscoveryNode::getId).toArray(String[]::new)).clear().addMetric(NodesInfoMetrics.Metric.OS.metricName()).timeout(this.fetchTimeout), ActionListener.wrap(nodesInfoResponse -> {
            Map builderBuilder = Maps.newHashMapWithExpectedSize((int)nodesStatsResponse.getNodes().size());
            nodesStatsResponse.getNodes().forEach(nodeStats -> builderBuilder.put(nodeStats.getNode().getEphemeralId(), AutoscalingNodeInfo.builder().setMemory(nodeStats.getOs().getMem().getAdjustedTotal().getBytes())));
            nodesInfoResponse.getNodes().forEach(nodeInfo -> {
                assert (builderBuilder.containsKey(nodeInfo.getNode().getEphemeralId())) : "unexpected missing node when setting processors [" + nodeInfo.getNode().getEphemeralId() + "]";
                builderBuilder.computeIfPresent(nodeInfo.getNode().getEphemeralId(), (n, b) -> b.setProcessors(((OsInfo)nodeInfo.getInfo(OsInfo.class)).getFractionalAllocatedProcessors()));
            });
            Object object = this.mutex;
            synchronized (object) {
                HashMap<String, AutoscalingNodeInfo> builder = new HashMap<String, AutoscalingNodeInfo>(this.nodeToMemory);
                Stream.concat(nodesStatsResponse.failures().stream(), nodesInfoResponse.failures().stream()).map(FailedNodeException::nodeId).map(nodeLookup).map(DiscoveryNode::getEphemeralId).forEach(builder::remove);
                builderBuilder.forEach((nodeEphemeralId, memoryProcessorBuilder) -> {
                    if (memoryProcessorBuilder.canBuild()) {
                        builder.put((String)nodeEphemeralId, memoryProcessorBuilder.build());
                    }
                });
                this.nodeToMemory = Collections.unmodifiableMap(builder);
            }
        }, e -> {
            onError.run();
            logger.warn(() -> String.format(Locale.ROOT, "Unable to obtain processor info from [%s]", missingNodes), (Throwable)e);
        })), e -> {
            onError.run();
            logger.warn(() -> String.format(Locale.ROOT, "Unable to obtain memory info from [%s]", missingNodes), (Throwable)e);
        }));
    }

    private Set<Set<DiscoveryNodeRole>> calculateAutoscalingRoleSets(ClusterState state) {
        AutoscalingMetadata autoscalingMetadata = (AutoscalingMetadata)state.metadata().custom("autoscaling");
        if (autoscalingMetadata != null) {
            return autoscalingMetadata.policies().values().stream().map(AutoscalingPolicyMetadata::policy).map(AutoscalingPolicy::roles).map(this::toRoles).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private Set<DiscoveryNodeRole> toRoles(SortedSet<String> roleNames) {
        return roleNames.stream().map(DiscoveryNodeRole::getRoleFromRoleName).collect(Collectors.toSet());
    }

    private void retainAliveNodes(Set<DiscoveryNode> currentNodes) {
        assert (Thread.holdsLock(this.mutex));
        Set ephemeralIds = currentNodes.stream().map(DiscoveryNode::getEphemeralId).collect(Collectors.toSet());
        Set toRemove = this.nodeToMemory.keySet().stream().filter(Predicate.not(ephemeralIds::contains)).collect(Collectors.toSet());
        if (!toRemove.isEmpty()) {
            this.nodeToMemory = this.nodeToMemory.entrySet().stream().filter(n -> !toRemove.contains(n.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public AutoscalingNodesInfo snapshot() {
        Map<String, AutoscalingNodeInfo> nodeToMemoryRef = this.nodeToMemory;
        return node -> {
            AutoscalingNodeInfo result = (AutoscalingNodeInfo)nodeToMemoryRef.get(node.getEphemeralId());
            if (result == FETCHING_SENTINEL) {
                return Optional.empty();
            }
            return Optional.ofNullable(result);
        };
    }
}

