/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.metric;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.aggregations.metric.MatrixStatsResults;
import org.elasticsearch.aggregations.metric.RunningStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalMatrixStats
extends InternalAggregation {
    private final RunningStats stats;
    private final MatrixStatsResults results;

    InternalMatrixStats(String name, long count, RunningStats multiFieldStatsResults, MatrixStatsResults results, Map<String, Object> metadata) {
        super(name, metadata);
        assert (count >= 0L);
        this.stats = multiFieldStatsResults;
        this.results = results;
    }

    public InternalMatrixStats(StreamInput in) throws IOException {
        super(in);
        this.stats = (RunningStats)in.readOptionalWriteable(RunningStats::new);
        this.results = (MatrixStatsResults)in.readOptionalWriteable(MatrixStatsResults::new);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.stats);
        out.writeOptionalWriteable((Writeable)this.results);
    }

    public String getWriteableName() {
        return "matrix_stats";
    }

    public long getDocCount() {
        if (this.results != null) {
            return this.results.getDocCount();
        }
        if (this.stats == null) {
            return 0L;
        }
        return this.stats.docCount;
    }

    public long getFieldCount(String field) {
        if (this.results == null) {
            return 0L;
        }
        return this.results.getFieldCount(field);
    }

    public double getMean(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getMean(field);
    }

    public double getVariance(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getVariance(field);
    }

    public double getSkewness(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getSkewness(field);
    }

    public double getKurtosis(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getKurtosis(field);
    }

    public double getCovariance(String fieldX, String fieldY) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getCovariance(fieldX, fieldY);
    }

    public double getCorrelation(String fieldX, String fieldY) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getCorrelation(fieldX, fieldY);
    }

    RunningStats getStats() {
        return this.stats;
    }

    MatrixStatsResults getResults() {
        return this.results;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
        if (this.results != null && !this.results.getFieldCounts().keySet().isEmpty()) {
            builder.startArray("fields");
            for (String fieldName : this.results.getFieldCounts().keySet()) {
                builder.startObject();
                builder.field("name", fieldName);
                builder.field("count", this.results.getFieldCount(fieldName));
                builder.field("mean", this.results.getMean(fieldName));
                builder.field("variance", this.results.getVariance(fieldName));
                builder.field("skewness", this.results.getSkewness(fieldName));
                builder.field("kurtosis", this.results.getKurtosis(fieldName));
                builder.startObject("covariance");
                for (String fieldB : this.results.getFieldCounts().keySet()) {
                    builder.field(fieldB, this.results.getCovariance(fieldName, fieldB));
                }
                builder.endObject();
                builder.startObject("correlation");
                for (String fieldB : this.results.getFieldCounts().keySet()) {
                    builder.field(fieldB, this.results.getCorrelation(fieldName, fieldB));
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 2) {
            String element;
            if (this.results == null) {
                return Collections.emptyMap();
            }
            String field = path.get(0).replaceAll("^\"", "").replaceAll("^'", "").replaceAll("\"$", "").replaceAll("'$", "");
            return switch (element = path.get(1)) {
                case "counts" -> this.results.getFieldCount(field);
                case "means" -> this.results.getMean(field);
                case "variances" -> this.results.getVariance(field);
                case "skewness" -> this.results.getSkewness(field);
                case "kurtosis" -> this.results.getKurtosis(field);
                case "covariance" -> this.results.getCovariance(field, field);
                case "correlation" -> this.results.getCorrelation(field, field);
                default -> throw new IllegalArgumentException("Found unknown path element [" + element + "] in [" + this.getName() + "]");
            };
        }
        if (path.size() == 1) {
            String element = path.get(0);
            if (this.results == null) {
                return Collections.emptyMap();
            }
            return switch (element) {
                case "counts" -> this.results.getFieldCounts();
                case "means" -> this.results.getMeans();
                case "variances" -> this.results.getVariances();
                case "skewness" -> this.results.getSkewness();
                case "kurtosis" -> this.results.getKurtosis();
                case "covariance" -> this.results.getCovariances();
                case "correlation" -> this.results.getCorrelations();
                default -> throw new IllegalArgumentException("Found unknown path element [" + element + "] in [" + this.getName() + "]");
            };
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(aggregations);
        aggs.removeIf(p -> ((InternalMatrixStats)p).stats == null);
        if (aggs.isEmpty()) {
            return new InternalMatrixStats(this.name, 0L, null, new MatrixStatsResults(), this.getMetadata());
        }
        RunningStats runningStats = new RunningStats();
        for (InternalAggregation agg : aggs) {
            Set<String> missingFields = runningStats.missingFieldNames(((InternalMatrixStats)agg).stats);
            if (!missingFields.isEmpty()) {
                throw new IllegalArgumentException("Aggregation [" + agg.getName() + "] all fields must exist in all indices, but some indices are missing these fields [" + String.join((CharSequence)", ", new TreeSet<String>(missingFields)) + "]");
            }
            runningStats.merge(((InternalMatrixStats)agg).stats);
        }
        if (reduceContext.isFinalReduce()) {
            MatrixStatsResults matrixStatsResults = new MatrixStatsResults(runningStats);
            return new InternalMatrixStats(this.name, matrixStatsResults.getDocCount(), runningStats, matrixStatsResults, this.getMetadata());
        }
        return new InternalMatrixStats(this.name, runningStats.docCount, runningStats, null, this.getMetadata());
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalMatrixStats(this.name, samplingContext.scaleUp(this.getDocCount()), this.stats, new MatrixStatsResults(this.stats, samplingContext), this.getMetadata());
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stats, this.results);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMatrixStats other = (InternalMatrixStats)((Object)obj);
        return Objects.equals(this.stats, other.stats) && Objects.equals(this.results, other.results);
    }

    static class Fields {
        public static final String FIELDS = "fields";
        public static final String NAME = "name";
        public static final String COUNT = "count";
        public static final String MEAN = "mean";
        public static final String VARIANCE = "variance";
        public static final String SKEWNESS = "skewness";
        public static final String KURTOSIS = "kurtosis";
        public static final String COVARIANCE = "covariance";
        public static final String CORRELATION = "correlation";

        Fields() {
        }
    }
}

