/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.root;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MainResponse
extends ActionResponse
implements ToXContentObject {
    private String nodeName;
    private String luceneVersion;
    private ClusterName clusterName;
    private String clusterUuid;
    private Build build;
    private static final ObjectParser<MainResponse, Void> PARSER = new ObjectParser(MainResponse.class.getName(), true, MainResponse::new);

    MainResponse() {
    }

    MainResponse(StreamInput in) throws IOException {
        super(in);
        this.nodeName = in.readString();
        if (in.getTransportVersion().before((VersionId)TransportVersion.V_8_500_041)) {
            Version.readVersion((StreamInput)in);
        }
        String wireLuceneVersion = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_037)) {
            wireLuceneVersion = in.readString();
        } else {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_031)) {
                wireLuceneVersion = IndexVersion.readVersion((StreamInput)in).luceneVersion().toString();
            }
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_019)) {
                TransportVersion.readVersion((StreamInput)in);
            }
        }
        this.clusterName = new ClusterName(in);
        this.clusterUuid = in.readString();
        this.build = Build.readBuild((StreamInput)in);
        if (wireLuceneVersion == null) {
            wireLuceneVersion = IndexVersion.fromId((int)Version.fromString((String)this.build.version()).id).luceneVersion().toString();
        }
        this.luceneVersion = wireLuceneVersion;
    }

    public MainResponse(String nodeName, String luceneVersion, ClusterName clusterName, String clusterUuid, Build build) {
        this.nodeName = nodeName;
        this.luceneVersion = luceneVersion;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getLuceneVersion() {
        return this.luceneVersion;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public Build getBuild() {
        return this.build;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        if (out.getTransportVersion().before((VersionId)TransportVersion.V_8_500_041)) {
            Version.writeVersion((Version)Version.CURRENT, (StreamOutput)out);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_037)) {
            out.writeString(this.luceneVersion);
        } else {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_031)) {
                IndexVersion.writeVersion((IndexVersion)IndexVersion.current(), (StreamOutput)out);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_019)) {
                TransportVersion.writeVersion((TransportVersion)TransportVersion.current(), (StreamOutput)out);
            }
        }
        this.clusterName.writeTo(out);
        out.writeString(this.clusterUuid);
        Build.writeBuild((Build)this.build, (StreamOutput)out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.nodeName);
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", this.clusterUuid);
        builder.startObject("version").field("number", this.build.qualifiedVersion()).field("build_flavor", this.build.flavor()).field("build_type", this.build.type().displayName()).field("build_hash", this.build.hash()).field("build_date", this.build.date()).field("build_snapshot", this.build.isSnapshot()).field("lucene_version", this.luceneVersion).field("minimum_wire_compatibility_version", this.build.minWireCompatVersion()).field("minimum_index_compatibility_version", this.build.minIndexCompatVersion()).endObject();
        builder.field("tagline", "You Know, for Search");
        builder.endObject();
        return builder;
    }

    public static MainResponse fromXContent(XContentParser parser) {
        return (MainResponse)((Object)PARSER.apply(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MainResponse other = (MainResponse)((Object)o);
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.luceneVersion, other.luceneVersion) && Objects.equals(this.clusterUuid, other.clusterUuid) && Objects.equals(this.build, other.build) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.luceneVersion, this.clusterUuid, this.build, this.clusterName);
    }

    public String toString() {
        return "MainResponse{nodeName='" + this.nodeName + "', luceneVersion=" + this.luceneVersion + ", clusterName=" + this.clusterName + ", clusterUuid='" + this.clusterUuid + "', build=" + this.build + "}";
    }

    static {
        PARSER.declareString((response, value) -> {
            response.nodeName = value;
        }, new ParseField("name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterName = new ClusterName(value);
        }, new ParseField("cluster_name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterUuid = value;
        }, new ParseField("cluster_uuid", new String[0]));
        PARSER.declareString((response, value) -> {}, new ParseField("tagline", new String[0]));
        PARSER.declareObject((response, value) -> {
            String buildFlavor = (String)value.get("build_flavor");
            String buildTypeStr = (String)value.get("build_type");
            Build.Type buildType = buildTypeStr == null ? Build.Type.UNKNOWN : Build.Type.fromDisplayName((String)buildTypeStr, (boolean)false);
            String buildHash = (String)value.get("build_hash");
            String buildDate = (String)value.get("build_date");
            boolean isSnapshot = (Boolean)value.get("build_snapshot");
            String version = (String)value.get("number");
            String minWireCompatVersion = (String)value.get("minimum_wire_compatibility_version");
            String minIndexCompatVersion = (String)value.get("minimum_index_compatibility_version");
            String displayString = Build.defaultDisplayString((Build.Type)buildType, (String)buildHash, (String)buildDate, (String)version);
            response.build = new Build(buildFlavor, buildType, buildHash, buildDate, isSnapshot, version, minWireCompatVersion, minIndexCompatVersion, displayString);
            response.luceneVersion = (String)value.get("lucene_version");
        }, (parser, context) -> parser.map(), new ParseField("version", new String[0]));
    }
}

