/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.blobstore.url.http.HttpResponseInputStream;
import org.elasticsearch.common.blobstore.url.http.URLHttpClientException;
import org.elasticsearch.common.blobstore.url.http.URLHttpClientIOException;
import org.elasticsearch.common.blobstore.url.http.URLHttpClientSettings;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Streams;
import org.elasticsearch.rest.RestStatus;

public class URLHttpClient
implements Closeable {
    public static final int MAX_ERROR_MESSAGE_BODY_SIZE = 1024;
    private static final int MAX_CONNECTIONS = 50;
    private final Logger logger = LogManager.getLogger(URLHttpClient.class);
    private final CloseableHttpClient client;
    private final URLHttpClientSettings httpClientSettings;

    public URLHttpClient(CloseableHttpClient client, URLHttpClientSettings httpClientSettings) {
        this.client = client;
        this.httpClientSettings = httpClientSettings;
    }

    public HttpResponse get(URI uri, Map<String, String> headers) throws IOException {
        HttpGet request = new HttpGet(uri);
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            request.setHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.httpClientSettings.getSocketTimeoutMs()).setConnectionRequestTimeout(this.httpClientSettings.getConnectionPoolTimeoutMs()).setConnectTimeout(this.httpClientSettings.getConnectionTimeoutMs()).build();
        request.setConfig(requestConfig);
        try {
            return this.executeRequest(request);
        }
        catch (IOException e) {
            throw new URLHttpClientIOException(e.getMessage(), e);
        }
    }

    private HttpResponse executeRequest(final HttpGet request) throws IOException {
        final CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        final int statusCode = response.getStatusLine().getStatusCode();
        if (!this.isSuccessful(statusCode)) {
            this.handleInvalidResponse(response);
        }
        return new HttpResponse(){

            @Override
            public HttpResponseInputStream getInputStream() throws IOException {
                try {
                    return new HttpResponseInputStream((HttpRequestBase)request, response);
                }
                catch (IOException e) {
                    IOUtils.closeWhileHandlingException((Closeable)response);
                    throw e;
                }
            }

            @Override
            public String getBodyAsString(int maxSize) {
                return URLHttpClient.this.parseBodyAsString(response, maxSize);
            }

            @Override
            public int getStatusCode() {
                return statusCode;
            }

            @Override
            public String getHeader(String headerName) {
                Header header = response.getFirstHeader(headerName);
                return header == null ? null : header.getValue();
            }

            @Override
            public void close() throws IOException {
                response.close();
            }
        };
    }

    private void handleInvalidResponse(CloseableHttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        String errorBody = this.parseBodyAsString(response, 1024);
        throw new URLHttpClientException(statusCode, URLHttpClient.createErrorMessage(statusCode, errorBody));
    }

    static String createErrorMessage(int statusCode, String errorMessage) {
        if (!errorMessage.isEmpty()) {
            return statusCode + ": " + errorMessage;
        }
        return Integer.toString(statusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseBodyAsString(CloseableHttpResponse response, int maxSize) {
        String errorMessage = "";
        InputStream bodyContent = null;
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null && this.isValidContentTypeToParseError(httpEntity)) {
                byte[] errorBodyBytes = new byte[(int)Math.min(httpEntity.getContentLength(), (long)maxSize)];
                bodyContent = httpEntity.getContent();
                int bytesRead = Streams.readFully((InputStream)bodyContent, (byte[])errorBodyBytes);
                if (bytesRead > 0) {
                    Charset utf = this.getCharset(httpEntity);
                    errorMessage = new String(errorBodyBytes, utf);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to parse HTTP body to produce an error response", (Throwable)e);
        }
        finally {
            IOUtils.closeWhileHandlingException(bodyContent);
            IOUtils.closeWhileHandlingException((Closeable)response);
        }
        return errorMessage;
    }

    private Charset getCharset(HttpEntity httpEntity) {
        Header contentType = httpEntity.getContentType();
        if (contentType == null) {
            return StandardCharsets.UTF_8;
        }
        for (HeaderElement element : contentType.getElements()) {
            NameValuePair charset = element.getParameterByName("charset");
            if (charset == null) continue;
            return Charset.forName(charset.getValue());
        }
        return StandardCharsets.UTF_8;
    }

    private boolean isValidContentTypeToParseError(HttpEntity httpEntity) {
        Header contentType = httpEntity.getContentType();
        return contentType != null && httpEntity.getContentLength() > 0L && (contentType.getValue().startsWith("text/") || contentType.getValue().startsWith("application/"));
    }

    private boolean isSuccessful(int statusCode) {
        return statusCode / 100 == RestStatus.OK.getStatus() / 100;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static interface HttpResponse
    extends Closeable {
        public HttpResponseInputStream getInputStream() throws IOException;

        public int getStatusCode();

        public String getBodyAsString(int var1);

        @Nullable
        public String getHeader(String var1);
    }

    public static class Factory
    implements Closeable {
        private final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();

        public Factory() {
            this.connManager.setDefaultMaxPerRoute(50);
            this.connManager.setMaxTotal(50);
        }

        public URLHttpClient create(URLHttpClientSettings settings) {
            CloseableHttpClient apacheHttpClient = HttpClients.custom().setSSLContext(SSLContexts.createSystemDefault()).setConnectionManager((HttpClientConnectionManager)this.connManager).disableAutomaticRetries().setConnectionManagerShared(true).build();
            return new URLHttpClient(apacheHttpClient, settings);
        }

        @Override
        public void close() {
            this.connManager.close();
        }
    }
}

