/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.Collection;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.enrich.action.PutEnrichPolicyAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class TransportPutEnrichPolicyAction
extends AcknowledgedTransportMasterNodeAction<PutEnrichPolicyAction.Request> {
    private final SecurityContext securityContext;
    private final Client client;
    private final Settings settings;

    @Inject
    public TransportPutEnrichPolicyAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/enrich/put", transportService, clusterService, threadPool, actionFilters, PutEnrichPolicyAction.Request::new, indexNameExpressionResolver, "same");
        this.settings = settings;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.client = client;
    }

    protected void masterOperation(Task task, PutEnrichPolicyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            RoleDescriptor.IndicesPrivileges privileges = RoleDescriptor.IndicesPrivileges.builder().indices((Collection)request.getPolicy().getIndices()).privileges(new String[]{"read"}).build();
            String username = this.securityContext.getUser().principal();
            HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
            privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
            privRequest.username(username);
            privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
            privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{privileges});
            ActionListener wrappedListener = ActionListener.wrap(r -> {
                if (r.isCompleteMatch()) {
                    this.putPolicy(request, listener);
                } else {
                    listener.onFailure((Exception)Exceptions.authorizationError((String)"unable to store policy because no indices match with the specified index patterns {}", (Object[])new Object[]{request.getPolicy().getIndices(), username}));
                }
            }, arg_0 -> listener.onFailure(arg_0));
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, wrappedListener);
        } else {
            this.putPolicy(request, listener);
        }
    }

    private void putPolicy(PutEnrichPolicyAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        EnrichStore.putPolicy(request.getName(), request.getPolicy(), this.clusterService, this.indexNameExpressionResolver, e -> {
            if (e == null) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(PutEnrichPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

