/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyUtils;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;

public class TransportGetLifecycleAction
extends TransportMasterNodeAction<GetLifecycleAction.Request, GetLifecycleAction.Response> {
    @Inject
    public TransportGetLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ilm/get", transportService, clusterService, threadPool, actionFilters, GetLifecycleAction.Request::new, indexNameExpressionResolver, GetLifecycleAction.Response::new, "management");
    }

    protected void masterOperation(Task task, GetLifecycleAction.Request request, ClusterState state, ActionListener<GetLifecycleAction.Response> listener) {
        assert (task instanceof CancellableTask) : "get lifecycle requests should be cancellable";
        CancellableTask cancellableTask = (CancellableTask)task;
        if (cancellableTask.notifyIfCancelled(listener)) {
            return;
        }
        IndexLifecycleMetadata metadata = (IndexLifecycleMetadata)this.clusterService.state().metadata().custom("index_lifecycle");
        if (metadata == null) {
            if (request.getPolicyNames().length == 0) {
                listener.onResponse((Object)new GetLifecycleAction.Response(Collections.emptyList()));
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{Arrays.toString(request.getPolicyNames())}));
            }
        } else {
            List<String> names = request.getPolicyNames().length == 0 ? List.of("*") : Arrays.asList(request.getPolicyNames());
            if (names.size() > 1 && names.stream().anyMatch(Regex::isSimpleMatchPattern)) {
                throw new IllegalArgumentException("wildcard only supports a single value, please use comma-separated values or a single wildcard value");
            }
            LinkedHashMap<String, GetLifecycleAction.LifecyclePolicyResponseItem> policyResponseItemMap = new LinkedHashMap<String, GetLifecycleAction.LifecyclePolicyResponseItem>();
            for (String name : names) {
                if (Regex.isSimpleMatchPattern((String)name)) {
                    for (Map.Entry entry : metadata.getPolicyMetadatas().entrySet()) {
                        if (cancellableTask.notifyIfCancelled(listener)) {
                            return;
                        }
                        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)entry.getValue();
                        if (!Regex.simpleMatch((String)name, (String)((String)entry.getKey()))) continue;
                        policyResponseItemMap.put((String)entry.getKey(), new GetLifecycleAction.LifecyclePolicyResponseItem(policyMetadata.getPolicy(), policyMetadata.getVersion(), policyMetadata.getModifiedDateString(), LifecyclePolicyUtils.calculateUsage((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ClusterState)state, (String)policyMetadata.getName())));
                    }
                    continue;
                }
                LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)metadata.getPolicyMetadatas().get(name);
                if (policyMetadata == null) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{name}));
                    return;
                }
                policyResponseItemMap.put(name, new GetLifecycleAction.LifecyclePolicyResponseItem(policyMetadata.getPolicy(), policyMetadata.getVersion(), policyMetadata.getModifiedDateString(), LifecyclePolicyUtils.calculateUsage((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ClusterState)state, (String)policyMetadata.getName())));
            }
            ArrayList requestedPolicies = new ArrayList(policyResponseItemMap.values());
            listener.onResponse((Object)new GetLifecycleAction.Response(requestedPolicies));
        }
    }

    protected ClusterBlockException checkBlock(GetLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

