/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.ql.util.Graphviz;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class Debug
extends Command {
    private final LogicalPlan plan;
    private final Format format;
    private final Type type;

    public Debug(Source source, LogicalPlan plan, Type type, Format format) {
        super(source);
        this.plan = plan;
        this.format = format == null ? Format.TEXT : format;
        this.type = type == null ? Type.OPTIMIZED : type;
    }

    protected NodeInfo<Debug> info() {
        return NodeInfo.create((Node)this, Debug::new, (Object)this.plan, (Object)((Object)this.type), (Object)((Object)this.format));
    }

    public LogicalPlan plan() {
        return this.plan;
    }

    public Format format() {
        return this.format;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public List<Attribute> output() {
        return Collections.singletonList(new FieldAttribute(this.source(), "plan", (EsField)new KeywordEsField("plan")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        switch (this.type) {
            case ANALYZED: {
                session.debugAnalyzedPlan(this.plan, (ActionListener<RuleExecutor.ExecutionInfo>)ActionListener.wrap(i -> this.handleInfo((RuleExecutor.ExecutionInfo)i, listener), arg_0 -> listener.onFailure(arg_0)));
                break;
            }
            case OPTIMIZED: {
                session.analyzedPlan(this.plan, true, (ActionListener<LogicalPlan>)ActionListener.wrap(analyzedPlan -> this.handleInfo(session.optimizer().debugOptimize((LogicalPlan)analyzedPlan), listener), arg_0 -> listener.onFailure(arg_0)));
            }
        }
    }

    private void handleInfo(RuleExecutor.ExecutionInfo info, ActionListener<Cursor.Page> listener) {
        String planString = null;
        if (this.format == Format.TEXT) {
            StringBuilder sb = new StringBuilder();
            if (info == null) {
                sb.append(this.plan.toString());
            } else {
                Map map = info.transformations();
                for (Map.Entry entry : map.entrySet()) {
                    sb.append("***");
                    sb.append(((RuleExecutor.Batch)entry.getKey()).name());
                    sb.append("***");
                    for (RuleExecutor.Transformation tf : (List)entry.getValue()) {
                        sb.append(tf.name());
                        sb.append("\n");
                        sb.append(NodeUtils.diffString((Node)tf.before(), (Node)tf.after()));
                        sb.append("\n");
                    }
                }
            }
            planString = sb.toString();
        } else if (info == null) {
            planString = Graphviz.dot((String)"Planned", (Node)this.plan);
        } else {
            LinkedHashMap<Object, Node> plans = new LinkedHashMap<Object, Node>();
            Map map = info.transformations();
            plans.put("start", info.before());
            for (Map.Entry entry : map.entrySet()) {
                int counter = 0;
                for (RuleExecutor.Transformation tf : (List)entry.getValue()) {
                    if (!tf.hasChanged()) continue;
                    plans.put(tf.name() + "#" + ++counter, tf.after());
                }
            }
            planString = Graphviz.dot(plans, (boolean)true);
        }
        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), planString)));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, this.type, this.format});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Debug o = (Debug)obj;
        return Objects.equals((Object)this.format, (Object)o.format) && Objects.equals((Object)this.type, (Object)o.type) && Objects.equals(this.plan, o.plan);
    }

    public static enum Format {
        TEXT,
        GRAPHVIZ;

    }

    public static enum Type {
        ANALYZED,
        OPTIMIZED;

    }
}

