/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle;

import java.io.Closeable;
import java.time.Clock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.common.scheduler.TimeValueSchedule;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleErrorStore;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class DataStreamLifecycleService
implements ClusterStateListener,
Closeable,
SchedulerEngine.Listener {
    public static final String DATA_STREAM_LIFECYCLE_POLL_INTERVAL = "data_streams.lifecycle.poll_interval";
    public static final Setting<TimeValue> DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING = Setting.timeSetting((String)"data_streams.lifecycle.poll_interval", (TimeValue)TimeValue.timeValueMinutes((long)5L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final ByteSizeValue ONE_HUNDRED_MB = ByteSizeValue.ofMb((long)100L);
    public static final int TARGET_MERGE_FACTOR_VALUE = 16;
    public static final Setting<Integer> DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING = Setting.intSetting((String)"data_streams.lifecycle.target.merge.policy.merge_factor", (int)16, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING = Setting.byteSizeSetting((String)"data_streams.lifecycle.target.merge.policy.floor_segment", (ByteSizeValue)ONE_HUNDRED_MB, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(DataStreamLifecycleService.class);
    private static final String LIFECYCLE_JOB_NAME = "data_stream_lifecycle";
    static final String LIFECYCLE_CUSTOM_INDEX_METADATA_KEY = "data_stream_lifecycle";
    static final String FORCE_MERGE_COMPLETED_TIMESTAMP_METADATA_KEY = "force_merge_completed_timestamp";
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    final ResultDeduplicator<TransportRequest, Void> transportActionsDeduplicator;
    private final LongSupplier nowSupplier;
    private final Clock clock;
    private final DataStreamLifecycleErrorStore errorStore;
    private volatile boolean isMaster = false;
    private volatile TimeValue pollInterval;
    private volatile RolloverConfiguration rolloverConfiguration;
    private SchedulerEngine.Job scheduledJob;
    private final SetOnce<SchedulerEngine> scheduler = new SetOnce();
    private final MasterServiceTaskQueue<UpdateForceMergeCompleteTask> forceMergeClusterStateUpdateTaskQueue;
    private volatile ByteSizeValue targetMergePolicyFloorSegment;
    private volatile int targetMergePolicyFactor;
    private static final SimpleBatchedExecutor<UpdateForceMergeCompleteTask, Void> FORCE_MERGE_STATE_UPDATE_TASK_EXECUTOR = new SimpleBatchedExecutor<UpdateForceMergeCompleteTask, Void>(){

        public Tuple<ClusterState, Void> executeTask(UpdateForceMergeCompleteTask task, ClusterState clusterState) throws Exception {
            return Tuple.tuple((Object)task.execute(clusterState), null);
        }

        public void taskSucceeded(UpdateForceMergeCompleteTask task, Void unused) {
            logger.trace("Updated cluster state for force merge of index [{}]", (Object)task.targetIndex);
            task.listener.onResponse(null);
        }
    };

    public DataStreamLifecycleService(Settings settings, Client client, ClusterService clusterService, Clock clock, ThreadPool threadPool, LongSupplier nowSupplier, DataStreamLifecycleErrorStore errorStore) {
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.clock = clock;
        this.threadPool = threadPool;
        this.transportActionsDeduplicator = new ResultDeduplicator(threadPool.getThreadContext());
        this.nowSupplier = nowSupplier;
        this.errorStore = errorStore;
        this.scheduledJob = null;
        this.pollInterval = (TimeValue)DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING.get(settings);
        this.targetMergePolicyFloorSegment = (ByteSizeValue)DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING.get(settings);
        this.targetMergePolicyFactor = (Integer)DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING.get(settings);
        this.rolloverConfiguration = (RolloverConfiguration)clusterService.getClusterSettings().get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING);
        this.forceMergeClusterStateUpdateTaskQueue = clusterService.createTaskQueue("data-stream-lifecycle-forcemerge-state-update", Priority.LOW, FORCE_MERGE_STATE_UPDATE_TASK_EXECUTOR);
    }

    public void init() {
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING, this::updatePollInterval);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING, this::updateRolloverConfiguration);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING, this::updateMergePolicyFactor);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING, this::updateMergePolicyFloorSegment);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.maybeScheduleJob();
            } else {
                this.cancelJob();
                this.transportActionsDeduplicator.clear();
                this.errorStore.clearStore();
            }
        }
    }

    @Override
    public void close() {
        SchedulerEngine engine = (SchedulerEngine)this.scheduler.get();
        if (engine != null) {
            engine.stop();
        }
        this.errorStore.clearStore();
    }

    public void triggered(SchedulerEngine.Event event) {
        if (event.getJobName().equals("data_stream_lifecycle") && this.isMaster) {
            logger.trace("Data stream lifecycle job triggered: {}, {}, {}", (Object)event.getJobName(), (Object)event.getScheduledTime(), (Object)event.getTriggeredTime());
            this.run(this.clusterService.state());
        }
    }

    void run(ClusterState state) {
        for (DataStream dataStream : state.metadata().dataStreams().values()) {
            Set<Object> indicesBeingRemoved;
            Index currentRunWriteIndex;
            block7: {
                this.clearErrorStoreForUnmanagedIndices(dataStream);
                if (dataStream.getLifecycle() == null) continue;
                currentRunWriteIndex = dataStream.getWriteIndex();
                try {
                    this.maybeExecuteRollover(state, dataStream);
                }
                catch (Exception e) {
                    logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle failed to rollover data stream [%s]", dataStream.getName()), (Throwable)e);
                    DataStream latestDataStream = (DataStream)this.clusterService.state().metadata().dataStreams().get(dataStream.getName());
                    if (latestDataStream == null || !latestDataStream.getWriteIndex().getName().equals(currentRunWriteIndex.getName())) break block7;
                    this.errorStore.recordError(currentRunWriteIndex.getName(), e);
                }
            }
            try {
                indicesBeingRemoved = this.maybeExecuteRetention(state, dataStream);
            }
            catch (Exception e) {
                indicesBeingRemoved = Set.of();
                logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle failed to execute retention for data stream [%s]", dataStream.getName()), (Throwable)e);
            }
            try {
                HashSet<Object> indicesToExclude = new HashSet<Object>();
                indicesToExclude.add(currentRunWriteIndex);
                indicesToExclude.addAll(indicesBeingRemoved);
                List<Index> potentialForceMergeIndices = dataStream.getIndices().stream().filter(index -> !indicesToExclude.contains(index)).toList();
                this.maybeExecuteForceMerge(state, dataStream, potentialForceMergeIndices);
            }
            catch (Exception e) {
                logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle failed to execute force merge for data stream [%s]", dataStream.getName()), (Throwable)e);
            }
        }
    }

    private void clearErrorStoreForUnmanagedIndices(DataStream dataStream) {
        Metadata metadata = this.clusterService.state().metadata();
        for (String indexName : this.errorStore.getAllIndices()) {
            IndexMetadata indexMeta = metadata.index(indexName);
            if (indexMeta == null) {
                this.errorStore.clearRecordedError(indexName);
                continue;
            }
            if (dataStream.isIndexManagedByDataStreamLifecycle(indexMeta.getIndex(), arg_0 -> ((Metadata)metadata).index(arg_0))) continue;
            this.errorStore.clearRecordedError(indexName);
        }
    }

    private void maybeExecuteRollover(ClusterState state, DataStream dataStream) {
        Index writeIndex = dataStream.getWriteIndex();
        if (dataStream.isIndexManagedByDataStreamLifecycle(writeIndex, arg_0 -> ((Metadata)state.metadata()).index(arg_0))) {
            RolloverRequest rolloverRequest = DataStreamLifecycleService.getDefaultRolloverRequest(this.rolloverConfiguration, dataStream.getName(), dataStream.getLifecycle().getEffectiveDataRetention());
            this.transportActionsDeduplicator.executeOnce((Object)rolloverRequest, (ActionListener)new ErrorRecordingActionListener(writeIndex.getName(), this.errorStore), (req, reqListener) -> this.rolloverDataStream(writeIndex.getName(), rolloverRequest, (ActionListener<Void>)reqListener));
        }
    }

    private Set<Index> maybeExecuteRetention(ClusterState state, DataStream dataStream) {
        TimeValue retention = DataStreamLifecycleService.getRetentionConfiguration(dataStream);
        HashSet<Index> indicesToBeRemoved = new HashSet<Index>();
        if (retention != null) {
            Metadata metadata = state.metadata();
            List backingIndicesOlderThanRetention = dataStream.getIndicesPastRetention(arg_0 -> ((Metadata)metadata).index(arg_0), this.nowSupplier);
            for (Index index : backingIndicesOlderThanRetention) {
                indicesToBeRemoved.add(index);
                IndexMetadata backingIndex = metadata.index(index);
                assert (backingIndex != null) : "the data stream backing indices must exist";
                String indexName = backingIndex.getIndex().getName();
                DeleteIndexRequest deleteRequest = (DeleteIndexRequest)new DeleteIndexRequest(indexName).masterNodeTimeout(TimeValue.MAX_VALUE);
                this.transportActionsDeduplicator.executeOnce((Object)deleteRequest, (ActionListener)new ErrorRecordingActionListener(indexName, this.errorStore), (req, reqListener) -> this.deleteIndex(deleteRequest, retention, (ActionListener<Void>)reqListener));
            }
        }
        return indicesToBeRemoved;
    }

    private void maybeExecuteForceMerge(ClusterState state, DataStream dataStream, List<Index> indices) {
        Metadata metadata = state.metadata();
        for (Index index : indices) {
            if (!dataStream.isIndexManagedByDataStreamLifecycle(index, arg_0 -> ((Metadata)state.metadata()).index(arg_0))) continue;
            IndexMetadata backingIndex = metadata.index(index);
            assert (backingIndex != null) : "the data stream backing indices must exist";
            String indexName = index.getName();
            boolean alreadyForceMerged = this.isForceMergeComplete(backingIndex);
            if (alreadyForceMerged) {
                logger.trace("Already force merged {}", (Object)indexName);
                continue;
            }
            ByteSizeValue configuredFloorSegmentMerge = (ByteSizeValue)MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING.get(backingIndex.getSettings());
            Integer configuredMergeFactor = (Integer)MergePolicyConfig.INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING.get(backingIndex.getSettings());
            if (configuredFloorSegmentMerge == null || !configuredFloorSegmentMerge.equals((Object)this.targetMergePolicyFloorSegment) || configuredMergeFactor == null || !configuredMergeFactor.equals(this.targetMergePolicyFactor)) {
                UpdateSettingsRequest updateMergePolicySettingsRequest = new UpdateSettingsRequest();
                updateMergePolicySettingsRequest.indices(new String[]{indexName});
                updateMergePolicySettingsRequest.settings(Settings.builder().put(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING.getKey(), this.targetMergePolicyFloorSegment).put(MergePolicyConfig.INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING.getKey(), this.targetMergePolicyFactor));
                updateMergePolicySettingsRequest.masterNodeTimeout(TimeValue.MAX_VALUE);
                this.transportActionsDeduplicator.executeOnce((Object)updateMergePolicySettingsRequest, (ActionListener)new ErrorRecordingActionListener(indexName, this.errorStore), (req, reqListener) -> this.updateIndexSetting(updateMergePolicySettingsRequest, (ActionListener<Void>)reqListener));
                continue;
            }
            ForceMergeRequest forceMergeRequest = new ForceMergeRequest(new String[]{indexName});
            this.transportActionsDeduplicator.executeOnce((Object)new ForceMergeRequestWrapper(forceMergeRequest), (ActionListener)new ErrorRecordingActionListener(indexName, this.errorStore), (req, reqListener) -> this.forceMergeIndex(forceMergeRequest, (ActionListener<Void>)reqListener));
        }
    }

    private void rolloverDataStream(final String writeIndexName, RolloverRequest rolloverRequest, final ActionListener<Void> listener) {
        final String rolloverTarget = rolloverRequest.getRolloverTarget();
        logger.trace("Data stream lifecycle issues rollover request for data stream [{}]", (Object)rolloverTarget);
        this.client.admin().indices().rolloverIndex(rolloverRequest, (ActionListener)new ActionListener<RolloverResponse>(){

            public void onResponse(RolloverResponse rolloverResponse) {
                if (rolloverResponse.isRolledOver()) {
                    List<String> metConditions = rolloverResponse.getConditionStatus().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
                    logger.info("Data stream lifecycle successfully rolled over datastream [{}] due to the following met rollover conditions {}. The new index is [{}]", (Object)rolloverTarget, metConditions, (Object)rolloverResponse.getNewIndex());
                }
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                logger.error(() -> Strings.format((String)"Data stream lifecycle encountered an error trying to rollover data steam [%s]", (Object[])new Object[]{rolloverTarget}), (Throwable)e);
                DataStream dataStream = (DataStream)DataStreamLifecycleService.this.clusterService.state().metadata().dataStreams().get(rolloverTarget);
                if (dataStream == null || !dataStream.getWriteIndex().getName().equals(writeIndexName)) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    private void updateIndexSetting(final UpdateSettingsRequest updateSettingsRequest, final ActionListener<Void> listener) {
        assert (updateSettingsRequest.indices() != null && updateSettingsRequest.indices().length == 1) : "Data stream lifecycle service updates the settings for one index at a time";
        final String targetIndex = updateSettingsRequest.indices()[0];
        logger.trace("Data stream lifecycle service issues request to update settings [{}] for index [{}]", (Object)updateSettingsRequest.settings().keySet(), (Object)targetIndex);
        this.client.admin().indices().updateSettings(updateSettingsRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                logger.info("Data stream lifecycle service successfully updated settings [{}] for index index [{}]", (Object)updateSettingsRequest.settings().keySet(), (Object)targetIndex);
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    DataStreamLifecycleService.this.errorStore.clearRecordedError(targetIndex);
                    listener.onResponse(null);
                    return;
                }
                listener.onFailure(e);
            }
        });
    }

    private void deleteIndex(DeleteIndexRequest deleteIndexRequest, final TimeValue retention, final ActionListener<Void> listener) {
        assert (deleteIndexRequest.indices() != null && deleteIndexRequest.indices().length == 1) : "Data stream lifecycle deletes one index at a time";
        final String targetIndex = deleteIndexRequest.indices()[0];
        logger.trace("Data stream lifecycle issues request to delete index [{}]", (Object)targetIndex);
        this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                logger.info("Data stream lifecycle successfully deleted index [{}] due to the lapsed [{}] retention period", (Object)targetIndex, (Object)retention);
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    DataStreamLifecycleService.this.errorStore.clearRecordedError(targetIndex);
                    listener.onResponse(null);
                    return;
                }
                if (e instanceof SnapshotInProgressException) {
                    logger.info("Data stream lifecycle was unable to delete index [{}] because it's currently being snapshot. Retrying on the next data stream lifecycle run", (Object)targetIndex);
                } else {
                    logger.error(() -> Strings.format((String)"Data stream lifecycle encountered an error trying to delete index [%s]", (Object[])new Object[]{targetIndex}), (Throwable)e);
                }
                listener.onFailure(e);
            }
        });
    }

    private void forceMergeIndex(ForceMergeRequest forceMergeRequest, final ActionListener<Void> listener) {
        assert (forceMergeRequest.indices() != null && forceMergeRequest.indices().length == 1) : "Data stream lifecycle force merges one index at a time";
        final String targetIndex = forceMergeRequest.indices()[0];
        logger.info("Data stream lifecycle is issuing a request to force merge index [{}]", (Object)targetIndex);
        this.client.admin().indices().forceMerge(forceMergeRequest, (ActionListener)new ActionListener<ForceMergeResponse>(){

            public void onResponse(ForceMergeResponse forceMergeResponse) {
                if (forceMergeResponse.getFailedShards() > 0) {
                    DefaultShardOperationFailedException[] failures = forceMergeResponse.getShardFailures();
                    String message = Strings.format((String)"Data stream lifecycle failed to forcemerge %d shards for index [%s] due to failures [%s]", (Object[])new Object[]{forceMergeResponse.getFailedShards(), targetIndex, failures == null ? "unknown" : Arrays.stream(failures).map(DefaultShardOperationFailedException::toString).collect(Collectors.joining(","))});
                    this.onFailure((Exception)new ElasticsearchException(message, new Object[0]));
                } else if (forceMergeResponse.getTotalShards() != forceMergeResponse.getSuccessfulShards()) {
                    String message = Strings.format((String)"Force merge request only had %d successful shards out of a total of %d", (Object[])new Object[]{forceMergeResponse.getSuccessfulShards(), forceMergeResponse.getTotalShards()});
                    this.onFailure((Exception)new ElasticsearchException(message, new Object[0]));
                } else {
                    logger.info("Data stream lifecycle successfully force merged index [{}]", (Object)targetIndex);
                    DataStreamLifecycleService.this.setForceMergeCompletedTimestamp(targetIndex, (ActionListener<Void>)listener);
                }
            }

            public void onFailure(Exception e) {
                String previousError = DataStreamLifecycleService.this.errorStore.getError(targetIndex);
                listener.onFailure(e);
                if (previousError == null || !previousError.equals(DataStreamLifecycleService.this.errorStore.getError(targetIndex))) {
                    logger.warn(() -> Strings.format((String)"Data stream lifecycle encountered an error trying to force merge index [%s]. Data stream lifecycle will attempt to force merge the index on its next run.", (Object[])new Object[]{targetIndex}), (Throwable)e);
                }
            }
        });
    }

    private void setForceMergeCompletedTimestamp(String targetIndex, ActionListener<Void> listener) {
        this.forceMergeClusterStateUpdateTaskQueue.submitTask(Strings.format((String)"Adding force merge complete marker to cluster state for [%s]", (Object[])new Object[]{targetIndex}), (ClusterStateTaskListener)new UpdateForceMergeCompleteTask(listener, targetIndex, this.threadPool), null);
    }

    private boolean isForceMergeComplete(IndexMetadata backingIndex) {
        Map customMetadata = backingIndex.getCustomData("data_stream_lifecycle");
        return customMetadata != null && customMetadata.containsKey(FORCE_MERGE_COMPLETED_TIMESTAMP_METADATA_KEY);
    }

    @Nullable
    static TimeValue getRetentionConfiguration(DataStream dataStream) {
        if (dataStream.getLifecycle() == null) {
            return null;
        }
        return dataStream.getLifecycle().getEffectiveDataRetention();
    }

    static RolloverRequest getDefaultRolloverRequest(RolloverConfiguration rolloverConfiguration, String dataStream, TimeValue dataRetention) {
        RolloverRequest rolloverRequest = (RolloverRequest)new RolloverRequest(dataStream, null).masterNodeTimeout(TimeValue.MAX_VALUE);
        rolloverRequest.setConditions(rolloverConfiguration.resolveRolloverConditions(dataRetention));
        return rolloverRequest;
    }

    private void updatePollInterval(TimeValue newInterval) {
        this.pollInterval = newInterval;
        this.maybeScheduleJob();
    }

    private void updateRolloverConfiguration(RolloverConfiguration newRolloverConfiguration) {
        this.rolloverConfiguration = newRolloverConfiguration;
    }

    private void updateMergePolicyFloorSegment(ByteSizeValue newFloorSegment) {
        this.targetMergePolicyFloorSegment = newFloorSegment;
    }

    private void updateMergePolicyFactor(int newFactor) {
        this.targetMergePolicyFactor = newFactor;
    }

    private void cancelJob() {
        if (this.scheduler.get() != null) {
            ((SchedulerEngine)this.scheduler.get()).remove("data_stream_lifecycle");
            this.scheduledJob = null;
        }
    }

    private boolean isClusterServiceStoppedOrClosed() {
        Lifecycle.State state = this.clusterService.lifecycleState();
        return state == Lifecycle.State.STOPPED || state == Lifecycle.State.CLOSED;
    }

    private void maybeScheduleJob() {
        if (!this.isMaster) {
            return;
        }
        if (this.isClusterServiceStoppedOrClosed()) {
            logger.trace("Skipping scheduling a data stream lifecycle job due to the cluster lifecycle state being: [{}] ", (Object)this.clusterService.lifecycleState());
            return;
        }
        if (this.scheduler.get() == null) {
            this.scheduler.set((Object)new SchedulerEngine(this.settings, this.clock));
            ((SchedulerEngine)this.scheduler.get()).register((SchedulerEngine.Listener)this);
        }
        assert (this.scheduler.get() != null) : "scheduler should be available";
        this.scheduledJob = new SchedulerEngine.Job("data_stream_lifecycle", (SchedulerEngine.Schedule)new TimeValueSchedule(this.pollInterval));
        ((SchedulerEngine)this.scheduler.get()).add(this.scheduledJob);
    }

    public DataStreamLifecycleErrorStore getErrorStore() {
        return this.errorStore;
    }

    static class ErrorRecordingActionListener
    implements ActionListener<Void> {
        private final String targetIndex;
        private final DataStreamLifecycleErrorStore errorStore;

        ErrorRecordingActionListener(String targetIndex, DataStreamLifecycleErrorStore errorStore) {
            this.targetIndex = targetIndex;
            this.errorStore = errorStore;
        }

        public void onResponse(Void unused) {
            this.errorStore.clearRecordedError(this.targetIndex);
        }

        public void onFailure(Exception e) {
            this.errorStore.recordError(this.targetIndex, e);
        }
    }

    static final class ForceMergeRequestWrapper
    extends ForceMergeRequest {
        ForceMergeRequestWrapper(ForceMergeRequest original) {
            super(original.indices());
            this.maxNumSegments(original.maxNumSegments());
            this.onlyExpungeDeletes(original.onlyExpungeDeletes());
            this.flush(original.flush());
            this.indicesOptions(original.indicesOptions());
            this.setShouldStoreResult(original.getShouldStoreResult());
            this.setRequestId(original.getRequestId());
            this.timeout(original.timeout());
            this.setParentTask(original.getParentTask());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ForceMergeRequest that = (ForceMergeRequest)o;
            return Arrays.equals(this.indices, that.indices()) && this.maxNumSegments() == that.maxNumSegments() && this.onlyExpungeDeletes() == that.onlyExpungeDeletes() && this.flush() == that.flush() && Objects.equals(this.indicesOptions(), that.indicesOptions()) && this.getShouldStoreResult() == that.getShouldStoreResult() && this.getRequestId() == that.getRequestId() && Objects.equals(this.timeout(), that.timeout()) && Objects.equals(this.getParentTask(), that.getParentTask());
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.maxNumSegments(), this.onlyExpungeDeletes(), this.flush(), this.indicesOptions(), this.getShouldStoreResult(), this.getRequestId(), this.timeout(), this.getParentTask());
        }
    }

    static class UpdateForceMergeCompleteTask
    implements ClusterStateTaskListener {
        private final ActionListener<Void> listener;
        private final String targetIndex;
        private final ThreadPool threadPool;

        UpdateForceMergeCompleteTask(ActionListener<Void> listener, String targetIndex, ThreadPool threadPool) {
            this.listener = listener;
            this.targetIndex = targetIndex;
            this.threadPool = threadPool;
        }

        ClusterState execute(ClusterState currentState) throws Exception {
            logger.debug("Updating cluster state with force merge complete marker for {}", (Object)this.targetIndex);
            IndexMetadata indexMetadata = currentState.metadata().index(this.targetIndex);
            Map customMetadata = indexMetadata.getCustomData("data_stream_lifecycle");
            HashMap<String, String> newCustomMetadata = new HashMap<String, String>();
            if (customMetadata != null) {
                newCustomMetadata.putAll(customMetadata);
            }
            newCustomMetadata.put(DataStreamLifecycleService.FORCE_MERGE_COMPLETED_TIMESTAMP_METADATA_KEY, Long.toString(this.threadPool.absoluteTimeInMillis()));
            IndexMetadata updatededIndexMetadata = new IndexMetadata.Builder(indexMetadata).putCustom("data_stream_lifecycle", newCustomMetadata).build();
            Metadata metadata = Metadata.builder((Metadata)currentState.metadata()).put(updatededIndexMetadata, true).build();
            return ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

