/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.datastreams.DataStreamsPlugin;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class UpdateTimeSeriesRangeService
extends AbstractLifecycleComponent
implements LocalNodeMasterListener {
    private static final Logger LOGGER = LogManager.getLogger(UpdateTimeSeriesRangeService.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    volatile TimeValue pollInterval;
    volatile Scheduler.Cancellable job;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final MasterServiceTaskQueue<UpdateTimeSeriesTask> taskQueue;

    UpdateTimeSeriesRangeService(Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        this.pollInterval = (TimeValue)DataStreamsPlugin.TIME_SERIES_POLL_INTERVAL.get(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DataStreamsPlugin.TIME_SERIES_POLL_INTERVAL, this::setPollInterval);
        this.taskQueue = clusterService.createTaskQueue("update-time-series-range", Priority.URGENT, (ClusterStateTaskExecutor)new UpdateTimeSeriesExecutor());
    }

    void perform(Runnable onComplete) {
        if (this.running.compareAndSet(false, true)) {
            LOGGER.debug("starting tsdb update task");
            UpdateTimeSeriesTask task = new UpdateTimeSeriesTask(e -> {
                if (e != null) {
                    LOGGER.warn("failed to update tsdb data stream end times", (Throwable)e);
                }
                this.running.set(false);
                onComplete.run();
            });
            this.taskQueue.submitTask("update_tsdb_data_stream_end_times", (ClusterStateTaskListener)task, null);
        } else {
            LOGGER.debug("not starting tsdb update task, because another execution is still running");
        }
    }

    void setPollInterval(TimeValue newValue) {
        LOGGER.info("updating [{}] setting from [{}] to [{}]", (Object)DataStreamsPlugin.TIME_SERIES_POLL_INTERVAL.getKey(), (Object)this.pollInterval, (Object)newValue);
        this.pollInterval = newValue;
        if (this.job != null) {
            this.unschedule();
            this.scheduleTask();
        }
    }

    ClusterState updateTimeSeriesTemporalRange(ClusterState current, Instant now) {
        Metadata.Builder mBuilder = null;
        for (DataStream dataStream : current.metadata().dataStreams().values()) {
            if (dataStream.getIndexMode() != IndexMode.TIME_SERIES || dataStream.isReplicated()) continue;
            Index head = dataStream.getWriteIndex();
            IndexMetadata im = current.metadata().getIndexSafe(head);
            Instant currentEnd = (Instant)IndexSettings.TIME_SERIES_END_TIME.get(im.getSettings());
            TimeValue lookAheadTime = (TimeValue)DataStreamsPlugin.LOOK_AHEAD_TIME.get(im.getSettings());
            Instant newEnd = DataStream.getCanonicalTimestampBound((Instant)now.plus(lookAheadTime.getMillis(), ChronoUnit.MILLIS).plus(this.pollInterval.getMillis(), ChronoUnit.MILLIS));
            if (!newEnd.isAfter(currentEnd)) continue;
            try {
                Settings settings = Settings.builder().put(IndexSettings.TIME_SERIES_END_TIME.getKey(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format((TemporalAccessor)newEnd)).build();
                LOGGER.debug("updating [{}] setting from [{}] to [{}] for data stream [{}]", (Object)IndexSettings.TIME_SERIES_END_TIME.getKey(), (Object)currentEnd, (Object)newEnd, (Object)dataStream.getName());
                if (mBuilder == null) {
                    mBuilder = Metadata.builder((Metadata)current.metadata());
                }
                mBuilder.updateSettings(settings, new String[]{head.getName()});
                dataStream.validate(arg_0 -> ((Metadata.Builder)mBuilder).get(arg_0));
            }
            catch (Exception e) {
                LOGGER.error(() -> Strings.format((String)"unable to update [%s] for data stream [%s] and backing index [%s]", (Object[])new Object[]{IndexSettings.TIME_SERIES_END_TIME.getKey(), dataStream.getName(), head.getName()}), (Throwable)e);
            }
        }
        if (mBuilder != null) {
            return ClusterState.builder((ClusterState)current).metadata(mBuilder).build();
        }
        return current;
    }

    void scheduleTask() {
        if (this.job == null) {
            LOGGER.debug("schedule tsdb update task");
            this.job = this.threadPool.scheduleWithFixedDelay(() -> this.perform(() -> LOGGER.debug("completed tsdb update task")), this.pollInterval, "same");
        }
    }

    void unschedule() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    protected void doStart() {
        this.clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
    }

    protected void doStop() {
        this.unschedule();
    }

    protected void doClose() throws IOException {
        this.unschedule();
    }

    public void onMaster() {
        this.scheduleTask();
    }

    public void offMaster() {
        this.unschedule();
    }

    private class UpdateTimeSeriesExecutor
    implements ClusterStateTaskExecutor<UpdateTimeSeriesTask> {
        private UpdateTimeSeriesExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<UpdateTimeSeriesTask> batchExecutionContext) throws Exception {
            ClusterState result;
            try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                result = UpdateTimeSeriesRangeService.this.updateTimeSeriesTemporalRange(batchExecutionContext.initialState(), Instant.now());
            }
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                taskContext.success(() -> ((UpdateTimeSeriesTask)taskContext.getTask()).listener().accept(null));
            }
            return result;
        }

        public String describeTasks(List<UpdateTimeSeriesTask> tasks) {
            return "";
        }
    }

    private record UpdateTimeSeriesTask(Consumer<Exception> listener) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            this.listener.accept(e);
        }
    }
}

