/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.datastreams.DataStreamsPlugin;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingParserContext;

public class DataStreamIndexSettingsProvider
implements IndexSettingProvider {
    static final DateFormatter FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
    private final CheckedFunction<IndexMetadata, MapperService, IOException> mapperServiceFactory;

    DataStreamIndexSettingsProvider(CheckedFunction<IndexMetadata, MapperService, IOException> mapperServiceFactory) {
        this.mapperServiceFactory = mapperServiceFactory;
    }

    public Settings getAdditionalIndexSettings(String indexName, String dataStreamName, boolean timeSeries, Metadata metadata, Instant resolvedAt, Settings allSettings, List<CompressedXContent> combinedTemplateMappings) {
        if (dataStreamName != null) {
            boolean migrating;
            DataStream dataStream = (DataStream)metadata.dataStreams().get(dataStreamName);
            boolean bl = migrating = dataStream != null && (dataStream.getIndexMode() == null || dataStream.getIndexMode() == IndexMode.STANDARD) && timeSeries;
            Object indexMode = migrating ? IndexMode.TIME_SERIES : (dataStream != null ? (timeSeries ? dataStream.getIndexMode() : null) : (timeSeries ? IndexMode.TIME_SERIES : null));
            if (indexMode != null && indexMode == IndexMode.TIME_SERIES) {
                List<String> routingPaths;
                Instant end;
                Instant start;
                Settings.Builder builder = Settings.builder();
                TimeValue lookAheadTime = (TimeValue)DataStreamsPlugin.LOOK_AHEAD_TIME.get(allSettings);
                if (dataStream == null || migrating) {
                    start = DataStream.getCanonicalTimestampBound((Instant)resolvedAt.minusMillis(lookAheadTime.getMillis()));
                    end = DataStream.getCanonicalTimestampBound((Instant)resolvedAt.plusMillis(lookAheadTime.getMillis()));
                } else {
                    IndexMetadata currentLatestBackingIndex = metadata.index(dataStream.getWriteIndex());
                    if (!currentLatestBackingIndex.getSettings().hasValue(IndexSettings.TIME_SERIES_END_TIME.getKey())) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "backing index [%s] in tsdb mode doesn't have the [%s] index setting", currentLatestBackingIndex.getIndex().getName(), IndexSettings.TIME_SERIES_END_TIME.getKey()));
                    }
                    start = (Instant)IndexSettings.TIME_SERIES_END_TIME.get(currentLatestBackingIndex.getSettings());
                    end = start.isAfter(resolvedAt) ? DataStream.getCanonicalTimestampBound((Instant)start.plusMillis(lookAheadTime.getMillis())) : DataStream.getCanonicalTimestampBound((Instant)resolvedAt.plusMillis(lookAheadTime.getMillis()));
                }
                assert (start.isBefore(end)) : "data stream backing index's start time is not before end time";
                builder.put(IndexSettings.TIME_SERIES_START_TIME.getKey(), FORMATTER.format((TemporalAccessor)start));
                builder.put(IndexSettings.TIME_SERIES_END_TIME.getKey(), FORMATTER.format((TemporalAccessor)end));
                if (!(allSettings.hasValue(IndexMetadata.INDEX_ROUTING_PATH.getKey()) || combinedTemplateMappings.isEmpty() || (routingPaths = this.findRoutingPaths(indexName, allSettings, combinedTemplateMappings)).isEmpty())) {
                    builder.putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), routingPaths);
                }
                return builder.build();
            }
        }
        return Settings.EMPTY;
    }

    private List<String> findRoutingPaths(String indexName, Settings allSettings, List<CompressedXContent> combinedTemplateMappings) {
        ArrayList<String> arrayList;
        block12: {
            IndexMetadata.Builder tmpIndexMetadata = IndexMetadata.builder((String)indexName);
            int dummyPartitionSize = (Integer)IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(allSettings);
            int dummyShards = allSettings.getAsInt("index.number_of_shards", Integer.valueOf(dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1));
            int shardReplicas = allSettings.getAsInt("index.number_of_replicas", Integer.valueOf(0));
            Settings finalResolvedSettings = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).put(allSettings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", shardReplicas).put("index.uuid", UUIDs.randomBase64UUID()).put(IndexSettings.MODE.getKey(), (Enum)IndexMode.STANDARD).build();
            tmpIndexMetadata.settings(finalResolvedSettings);
            MapperService mapperService = (MapperService)this.mapperServiceFactory.apply((Object)tmpIndexMetadata.build());
            try {
                for (CompressedXContent object : combinedTemplateMappings) {
                    mapperService.merge("_doc", object, MapperService.MergeReason.INDEX_TEMPLATE);
                }
                ArrayList<String> routingPaths = new ArrayList<String>();
                for (Mapper fieldMapper : mapperService.documentMapper().mappers().fieldMappers()) {
                    DataStreamIndexSettingsProvider.extractPath(routingPaths, fieldMapper);
                }
                for (DynamicTemplate template : mapperService.getAllDynamicTemplates()) {
                    String templateName;
                    Map mappingSnippet;
                    String mappingSnippetType;
                    if (template.pathMatch().isEmpty() || (mappingSnippetType = (String)(mappingSnippet = template.mappingForName(templateName = "__dynamic__" + template.name(), "keyword")).get("type")) == null) continue;
                    MappingParserContext parserContext = mapperService.parserContext();
                    for (String pathMatch : template.pathMatch()) {
                        Mapper mapper = parserContext.typeParser(mappingSnippetType).parse(pathMatch, new HashMap(mappingSnippet), parserContext).build(MapperBuilderContext.root((boolean)false));
                        DataStreamIndexSettingsProvider.extractPath(routingPaths, mapper);
                    }
                }
                arrayList = routingPaths;
                if (mapperService == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (mapperService != null) {
                        try {
                            mapperService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            mapperService.close();
        }
        return arrayList;
    }

    private static void extractPath(List<String> routingPaths, Mapper mapper) {
        KeywordFieldMapper keywordFieldMapper;
        if (mapper instanceof KeywordFieldMapper && (keywordFieldMapper = (KeywordFieldMapper)mapper).fieldType().isDimension()) {
            routingPaths.add(mapper.name());
        }
    }
}

