/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class KeyValueProcessor
extends AbstractProcessor {
    private static final Logger logger = LogManager.getLogger(KeyValueProcessor.class);
    public static final String TYPE = "kv";
    private static final Pattern STRIP_BRACKETS = Pattern.compile("(^[\\(\\[<\"'])|([\\]\\)>\"']$)");
    private final TemplateScript.Factory field;
    private final String fieldSplit;
    private final String valueSplit;
    private final Set<String> includeKeys;
    private final Set<String> excludeKeys;
    private final TemplateScript.Factory targetField;
    private final boolean ignoreMissing;
    private final Consumer<IngestDocument> execution;

    KeyValueProcessor(String tag, String description, TemplateScript.Factory field, String fieldSplit, String valueSplit, Set<String> includeKeys, Set<String> excludeKeys, TemplateScript.Factory targetField, boolean ignoreMissing, String trimKey, String trimValue, boolean stripBrackets, String prefix) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.fieldSplit = fieldSplit;
        this.valueSplit = valueSplit;
        this.includeKeys = includeKeys;
        this.excludeKeys = excludeKeys;
        this.ignoreMissing = ignoreMissing;
        this.execution = KeyValueProcessor.buildExecution(fieldSplit, valueSplit, field, includeKeys, excludeKeys, targetField, ignoreMissing, trimKey, trimValue, stripBrackets, prefix);
    }

    private static Consumer<IngestDocument> buildExecution(String fieldSplit, String valueSplit, TemplateScript.Factory field, Set<String> includeKeys, Set<String> excludeKeys, TemplateScript.Factory targetField, boolean ignoreMissing, String trimKey, String trimValue, boolean stripBrackets, String prefix) {
        Predicate<String> keyFilter = includeKeys == null ? (excludeKeys == null ? key -> true : key -> !excludeKeys.contains(key)) : (excludeKeys == null ? includeKeys::contains : key -> includeKeys.contains(key) && !excludeKeys.contains(key));
        Function<String, String[]> fieldSplitter = KeyValueProcessor.buildSplitter(fieldSplit, true);
        Function<String, String[]> valueSplitter = KeyValueProcessor.buildSplitter(valueSplit, false);
        Function<String, String> keyTrimmer = KeyValueProcessor.buildTrimmer(trimKey);
        Function<String, String> bracketStrip = stripBrackets ? val -> STRIP_BRACKETS.matcher((CharSequence)val).replaceAll("") : val -> val;
        Function<String, String> valueTrimmer = KeyValueProcessor.buildTrimmer(trimValue);
        return document -> {
            String target = "";
            if (targetField != null) {
                target = document.renderTemplate(targetField);
            }
            String keyPrefix = prefix == null ? "" : prefix;
            Object fieldPathPrefix = target.isEmpty() ? keyPrefix : target + "." + keyPrefix;
            Function<String, String> keyPrefixer = ((String)fieldPathPrefix).isEmpty() ? val -> val : arg_0 -> KeyValueProcessor.lambda$buildExecution$6((String)fieldPathPrefix, arg_0);
            String path = document.renderTemplate(field);
            if (path.isEmpty() || !document.hasField(path, true)) {
                if (ignoreMissing) {
                    return;
                }
                throw new IllegalArgumentException("field [" + path + "] doesn't exist");
            }
            String value = (String)document.getFieldValue(path, String.class, ignoreMissing);
            if (value == null) {
                if (ignoreMissing) {
                    return;
                }
                throw new IllegalArgumentException("field [" + path + "] is null, cannot extract key-value pairs.");
            }
            for (String part : (String[])fieldSplitter.apply(value)) {
                String[] kv = (String[])valueSplitter.apply(part);
                if (kv.length != 2) {
                    throw new IllegalArgumentException("field [" + path + "] does not contain value_split [" + valueSplit + "]");
                }
                String key = (String)keyTrimmer.apply(kv[0]);
                if (!keyFilter.test(key)) continue;
                KeyValueProcessor.append(document, keyPrefixer.apply(key), (String)valueTrimmer.apply((String)bracketStrip.apply(kv[1])));
            }
        };
    }

    private static ElasticsearchException logAndBuildException(String message, Throwable error) {
        Object cause = error.getClass().getName();
        if (error.getMessage() != null) {
            cause = (String)cause + ": " + error.getMessage();
        }
        String longMessage = message + ": " + (String)cause;
        if (logger.isTraceEnabled()) {
            logger.trace(message, error);
        } else {
            logger.warn(longMessage);
        }
        return new ElasticsearchException(longMessage, new Object[0]);
    }

    private static Function<String, String> buildTrimmer(String trim) {
        if (trim == null) {
            return val -> val;
        }
        Pattern pattern = Pattern.compile("(^([" + trim + "]+))|([" + trim + "]+$)");
        return val -> {
            try {
                return pattern.matcher((CharSequence)val).replaceAll("");
            }
            catch (Exception | StackOverflowError error) {
                throw KeyValueProcessor.logAndBuildException("Error trimming [" + val + "] using pattern [" + trim + "]", error);
            }
        };
    }

    private static Function<String, String[]> buildSplitter(String split, boolean fields) {
        int limit;
        int n = limit = fields ? 0 : 2;
        if (split.length() > 2 || split.length() == 2 && split.charAt(0) != '\\') {
            Pattern splitPattern = Pattern.compile(split);
            return val -> {
                try {
                    return splitPattern.split((CharSequence)val, limit);
                }
                catch (Exception | StackOverflowError error) {
                    throw KeyValueProcessor.logAndBuildException("Error splitting [" + val + "] using pattern [" + split + "]", error);
                }
            };
        }
        return val -> val.split(split, limit);
    }

    TemplateScript.Factory getField() {
        return this.field;
    }

    String getFieldSplit() {
        return this.fieldSplit;
    }

    String getValueSplit() {
        return this.valueSplit;
    }

    Set<String> getIncludeKeys() {
        return this.includeKeys;
    }

    Set<String> getExcludeKeys() {
        return this.excludeKeys;
    }

    TemplateScript.Factory getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    private static void append(IngestDocument document, String targetField, String value) {
        if (document.hasField(targetField)) {
            document.appendFieldValue(targetField, (Object)value);
        } else {
            document.setFieldValue(targetField, (Object)value);
        }
    }

    public IngestDocument execute(IngestDocument document) {
        this.execution.accept(document);
        return document;
    }

    public String getType() {
        return TYPE;
    }

    private static /* synthetic */ String lambda$buildExecution$6(String fieldPathPrefix, String val) {
        return fieldPathPrefix + val;
    }

    public static class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public KeyValueProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            List excludeKeysList;
            String field = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"field");
            TemplateScript.Factory fieldTemplate = ConfigurationUtils.compileTemplate((String)KeyValueProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            TemplateScript.Factory targetFieldTemplate = null;
            if (targetField != null) {
                targetFieldTemplate = ConfigurationUtils.compileTemplate((String)KeyValueProcessor.TYPE, (String)processorTag, (String)"target_field", (String)targetField, (ScriptService)this.scriptService);
            }
            String fieldSplit = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"field_split");
            String valueSplit = ConfigurationUtils.readStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"value_split");
            String trimKey = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"trim_key");
            String trimValue = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"trim_value");
            String prefix = ConfigurationUtils.readOptionalStringProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"prefix");
            boolean stripBrackets = ConfigurationUtils.readBooleanProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"strip_brackets", (boolean)false);
            Set<String> includeKeys = null;
            Set<String> excludeKeys = null;
            List includeKeysList = ConfigurationUtils.readOptionalList((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"include_keys");
            if (includeKeysList != null) {
                includeKeys = Set.copyOf(includeKeysList);
            }
            if ((excludeKeysList = ConfigurationUtils.readOptionalList((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"exclude_keys")) != null) {
                excludeKeys = Set.copyOf(excludeKeysList);
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)KeyValueProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new KeyValueProcessor(processorTag, description, fieldTemplate, fieldSplit, valueSplit, includeKeys, excludeKeys, targetFieldTemplate, ignoreMissing, trimKey, trimValue, stripBrackets, prefix);
        }
    }
}

