/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class SearchTemplateResponse
extends ActionResponse
implements StatusToXContentObject {
    public static ParseField TEMPLATE_OUTPUT_FIELD = new ParseField("template_output", new String[0]);
    private BytesReference source;
    private SearchResponse response;

    SearchTemplateResponse() {
    }

    SearchTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.source = in.readOptionalBytesReference();
        this.response = (SearchResponse)in.readOptionalWriteable(SearchResponse::new);
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public SearchResponse getResponse() {
        return this.response;
    }

    public void setResponse(SearchResponse searchResponse) {
        this.response = searchResponse;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public String toString() {
        return "SearchTemplateResponse [source=" + this.source + ", response=" + this.response + "]";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBytesReference(this.source);
        out.writeOptionalWriteable((Writeable)this.response);
    }

    public static SearchTemplateResponse fromXContent(XContentParser parser) throws IOException {
        SearchTemplateResponse searchTemplateResponse = new SearchTemplateResponse();
        Map contentAsMap = parser.map();
        if (contentAsMap.containsKey(TEMPLATE_OUTPUT_FIELD.getPreferredName())) {
            Object source = contentAsMap.get(TEMPLATE_OUTPUT_FIELD.getPreferredName());
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).value(source);
            searchTemplateResponse.setSource(BytesReference.bytes((XContentBuilder)builder));
        } else {
            XContentType contentType = parser.contentType();
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType).map(contentAsMap);
            XContentParser searchResponseParser = contentType.xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), (InputStream)BytesReference.bytes((XContentBuilder)builder).streamInput());
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)searchResponseParser);
            searchTemplateResponse.setResponse(searchResponse);
        }
        return searchTemplateResponse;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasResponse()) {
            ChunkedToXContent.wrapAsToXContent(p -> this.response.innerToXContentChunked(p)).toXContent(builder, params);
        } else {
            try (StreamInput stream = this.source.streamInput();){
                builder.rawField(TEMPLATE_OUTPUT_FIELD.getPreferredName(), (InputStream)stream, XContentType.JSON);
            }
        }
    }

    public RestStatus status() {
        if (this.hasResponse()) {
            return this.response.status();
        }
        return RestStatus.OK;
    }
}

