/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.shutdown.SingleNodeShutdownStatus;

public class GetShutdownStatusAction
extends ActionType<Response> {
    public static final GetShutdownStatusAction INSTANCE = new GetShutdownStatusAction();
    public static final String NAME = "cluster:admin/shutdown/get";

    public GetShutdownStatusAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        final List<SingleNodeShutdownStatus> shutdownStatuses;

        public Response(List<SingleNodeShutdownStatus> shutdownStatuses) {
            this.shutdownStatuses = Objects.requireNonNull(shutdownStatuses, "shutdown statuses must not be null");
        }

        public Response(StreamInput in) throws IOException {
            this.shutdownStatuses = in.readList(SingleNodeShutdownStatus::new);
        }

        public List<SingleNodeShutdownStatus> getShutdownStatuses() {
            return this.shutdownStatuses;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("nodes");
            for (SingleNodeShutdownStatus nodeShutdownStatus : this.shutdownStatuses) {
                nodeShutdownStatus.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.shutdownStatuses);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.shutdownStatuses.equals(response.shutdownStatuses);
        }

        public int hashCode() {
            return Objects.hash(this.shutdownStatuses);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String[] nodeIds;

        public Request(String ... nodeIds) {
            this.nodeIds = nodeIds;
        }

        public static Request readFrom(StreamInput in) throws IOException {
            return new Request(in.readStringArray());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.nodeIds);
        }

        public String[] getNodeIds() {
            return this.nodeIds;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.nodeIds, request.nodeIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this.nodeIds);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }
    }
}

