/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobContainerUtils;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.blobstore.ChunkedBlobOutputStream;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3RetryingInputStream;
import org.elasticsearch.repositories.s3.SocketAccess;
import org.elasticsearch.threadpool.ThreadPool;

class S3BlobContainer
extends AbstractBlobContainer {
    private static final Logger logger = LogManager.getLogger(S3BlobContainer.class);
    private static final int MAX_BULK_DELETES = 1000;
    private final S3BlobStore blobStore;
    private final String keyPath;

    S3BlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
    }

    public boolean blobExists(String blobName) {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        try {
            boolean bl = SocketAccess.doPrivileged(() -> clientReference.client().doesObjectExist(this.blobStore.bucket(), this.buildKey(blobName)));
            if (clientReference != null) {
                clientReference.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (clientReference != null) {
                    try {
                        clientReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
            }
        }
    }

    public InputStream readBlob(String blobName) throws IOException {
        return new S3RetryingInputStream(this.blobStore, this.buildKey(blobName));
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new S3RetryingInputStream(this.blobStore, this.buildKey(blobName), position, Math.addExact(position, length - 1L));
    }

    public long readBlobPreferredLength() {
        return new ByteSizeValue(32L, ByteSizeUnit.MB).getBytes();
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        assert (inputStream.markSupported()) : "No mark support on inputStream breaks the S3 SDK's ability to retry requests";
        SocketAccess.doPrivilegedIOException(() -> {
            if (blobSize <= this.getLargeBlobThresholdInBytes()) {
                this.executeSingleUpload(this.blobStore, this.buildKey(blobName), inputStream, blobSize);
            } else {
                this.executeMultipartUpload(this.blobStore, this.buildKey(blobName), inputStream, blobSize);
            }
            return null;
        });
    }

    public void writeMetadataBlob(final String blobName, final boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        final String absoluteBlobKey = this.buildKey(blobName);
        try (final AmazonS3Reference clientReference = this.blobStore.clientReference();
             ChunkedBlobOutputStream<PartETag> out = new ChunkedBlobOutputStream<PartETag>(this.blobStore.bigArrays(), this.blobStore.bufferSizeInBytes()){
            private final SetOnce<String> uploadId;
            {
                super(arg0, arg1);
                this.uploadId = new SetOnce();
            }

            protected void flushBuffer() throws IOException {
                this.flushBuffer(false);
            }

            private void flushBuffer(boolean lastPart) throws IOException {
                if (this.buffer.size() == 0) {
                    return;
                }
                if (this.flushedBytes == 0L) {
                    assert (!lastPart) : "use single part upload if there's only a single part";
                    this.uploadId.set((Object)SocketAccess.doPrivileged(() -> clientReference.client().initiateMultipartUpload(S3BlobContainer.this.initiateMultiPartUpload(absoluteBlobKey)).getUploadId()));
                    if (org.elasticsearch.common.Strings.isEmpty((CharSequence)((CharSequence)this.uploadId.get()))) {
                        throw new IOException("Failed to initialize multipart upload " + absoluteBlobKey);
                    }
                }
                assert (!lastPart || this.successful) : "must only write last part if successful";
                UploadPartRequest uploadRequest = S3BlobContainer.this.createPartUploadRequest((InputStream)this.buffer.bytes().streamInput(), (String)this.uploadId.get(), this.parts.size() + 1, absoluteBlobKey, this.buffer.size(), lastPart);
                UploadPartResult uploadResponse = SocketAccess.doPrivileged(() -> clientReference.client().uploadPart(uploadRequest));
                this.finishPart(uploadResponse.getPartETag());
            }

            protected void onCompletion() throws IOException {
                if (this.flushedBytes == 0L) {
                    S3BlobContainer.this.writeBlob(blobName, this.buffer.bytes(), failIfAlreadyExists);
                } else {
                    this.flushBuffer(true);
                    CompleteMultipartUploadRequest complRequest = new CompleteMultipartUploadRequest(S3BlobContainer.this.blobStore.bucket(), absoluteBlobKey, (String)this.uploadId.get(), this.parts);
                    complRequest.setRequestMetricCollector(S3BlobContainer.this.blobStore.multiPartUploadMetricCollector);
                    SocketAccess.doPrivilegedVoid(() -> clientReference.client().completeMultipartUpload(complRequest));
                }
            }

            protected void onFailure() {
                if (org.elasticsearch.common.Strings.hasText((String)((String)this.uploadId.get()))) {
                    S3BlobContainer.this.abortMultiPartUpload((String)this.uploadId.get(), absoluteBlobKey);
                }
            }
        };){
            writer.accept((Object)out);
            out.markSuccess();
        }
    }

    private UploadPartRequest createPartUploadRequest(InputStream stream, String uploadId, int number, String blobName, long size, boolean lastPart) {
        UploadPartRequest uploadRequest = new UploadPartRequest();
        uploadRequest.setBucketName(this.blobStore.bucket());
        uploadRequest.setKey(blobName);
        uploadRequest.setUploadId(uploadId);
        uploadRequest.setPartNumber(number);
        uploadRequest.setInputStream(stream);
        uploadRequest.setRequestMetricCollector(this.blobStore.multiPartUploadMetricCollector);
        uploadRequest.setPartSize(size);
        uploadRequest.setLastPart(lastPart);
        return uploadRequest;
    }

    private void abortMultiPartUpload(String uploadId, String blobName) {
        AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(this.blobStore.bucket(), blobName, uploadId);
        abortRequest.setRequestMetricCollector(this.blobStore.abortPartUploadMetricCollector);
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            SocketAccess.doPrivilegedVoid(() -> clientReference.client().abortMultipartUpload(abortRequest));
        }
    }

    private InitiateMultipartUploadRequest initiateMultiPartUpload(String blobName) {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.blobStore.bucket(), blobName);
        initRequest.setStorageClass(this.blobStore.getStorageClass());
        initRequest.setCannedACL(this.blobStore.getCannedACL());
        initRequest.setRequestMetricCollector(this.blobStore.multiPartUploadMetricCollector);
        if (this.blobStore.serverSideEncryption()) {
            ObjectMetadata md = new ObjectMetadata();
            md.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            initRequest.setObjectMetadata(md);
        }
        return initRequest;
    }

    long getLargeBlobThresholdInBytes() {
        return this.blobStore.bufferSizeInBytes();
    }

    public void writeBlobAtomic(String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, bytes, failIfAlreadyExists);
    }

    public DeleteResult delete() throws IOException {
        final AtomicLong deletedBlobs = new AtomicLong();
        final AtomicLong deletedBytes = new AtomicLong();
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            Iterator<String> blobNameIterator;
            ObjectListing prevListing = null;
            while (true) {
                ObjectListing list;
                if (prevListing != null) {
                    ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest = new ListNextBatchOfObjectsRequest(prevListing);
                    listNextBatchOfObjectsRequest.setRequestMetricCollector(this.blobStore.listMetricCollector);
                    list = SocketAccess.doPrivileged(() -> clientReference.client().listNextBatchOfObjects(listNextBatchOfObjectsRequest));
                } else {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
                    listObjectsRequest.setBucketName(this.blobStore.bucket());
                    listObjectsRequest.setPrefix(this.keyPath);
                    listObjectsRequest.setRequestMetricCollector(this.blobStore.listMetricCollector);
                    list = SocketAccess.doPrivileged(() -> clientReference.client().listObjects(listObjectsRequest));
                }
                final Iterator objectSummaryIterator = list.getObjectSummaries().iterator();
                blobNameIterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return objectSummaryIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        S3ObjectSummary summary = (S3ObjectSummary)objectSummaryIterator.next();
                        deletedBlobs.incrementAndGet();
                        deletedBytes.addAndGet(summary.getSize());
                        return summary.getKey();
                    }
                };
                if (!list.isTruncated()) break;
                this.doDeleteBlobs(blobNameIterator, false);
                prevListing = list;
            }
            this.doDeleteBlobs(Iterators.concat((Iterator[])new Iterator[]{blobNameIterator, Collections.singletonList(this.keyPath).iterator()}), false);
        }
        catch (AmazonClientException e) {
            throw new IOException("Exception when deleting blob container [" + this.keyPath + "]", e);
        }
        return new DeleteResult(deletedBlobs.get(), deletedBytes.get());
    }

    public void deleteBlobsIgnoringIfNotExists(Iterator<String> blobNames) throws IOException {
        this.doDeleteBlobs(blobNames, true);
    }

    private void doDeleteBlobs(final Iterator<String> blobNames, boolean relative) throws IOException {
        if (!blobNames.hasNext()) {
            return;
        }
        Iterator<String> outstanding = relative ? new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return blobNames.hasNext();
            }

            @Override
            public String next() {
                return S3BlobContainer.this.buildKey((String)blobNames.next());
            }
        } : blobNames;
        ArrayList partition = new ArrayList();
        try (AmazonS3Reference clientReference = this.blobStore.clientReference();){
            AtomicReference aex = new AtomicReference();
            SocketAccess.doPrivilegedVoid(() -> {
                outstanding.forEachRemaining(key -> {
                    partition.add(key);
                    if (partition.size() == 1000) {
                        this.deletePartition(clientReference, partition, aex);
                        partition.clear();
                    }
                });
                if (!partition.isEmpty()) {
                    this.deletePartition(clientReference, partition, aex);
                }
            });
            if (aex.get() != null) {
                throw (Exception)aex.get();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to delete blobs " + partition.stream().limit(10L).toList(), e);
        }
    }

    private void deletePartition(AmazonS3Reference clientReference, List<String> partition, AtomicReference<Exception> aex) {
        try {
            clientReference.client().deleteObjects(S3BlobContainer.bulkDelete(this.blobStore, partition));
        }
        catch (MultiObjectDeleteException e) {
            logger.warn(() -> Strings.format((String)"Failed to delete some blobs %s", (Object[])new Object[]{e.getErrors().stream().map(err -> "[" + err.getKey() + "][" + err.getCode() + "][" + err.getMessage() + "]").toList()}), (Throwable)e);
            aex.set((Exception)ExceptionsHelper.useOrSuppress((Throwable)aex.get(), (Throwable)e));
        }
        catch (AmazonClientException e) {
            aex.set((Exception)ExceptionsHelper.useOrSuppress((Throwable)aex.get(), (Throwable)e));
        }
    }

    private static DeleteObjectsRequest bulkDelete(S3BlobStore blobStore, List<String> blobs) {
        return (DeleteObjectsRequest)new DeleteObjectsRequest(blobStore.bucket()).withKeys(blobs.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY)).withQuiet(true).withRequestMetricCollector(blobStore.deleteMetricCollector);
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(@Nullable String blobNamePrefix) throws IOException {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        try {
            Map<String, BlobMetadata> map = this.executeListing(clientReference, this.listObjectsRequest(blobNamePrefix == null ? this.keyPath : this.buildKey(blobNamePrefix))).stream().flatMap(listing -> listing.getObjectSummaries().stream()).map(summary -> new BlobMetadata(summary.getKey().substring(this.keyPath.length()), summary.getSize())).collect(Collectors.toMap(BlobMetadata::name, Function.identity()));
            if (clientReference != null) {
                clientReference.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (clientReference != null) {
                    try {
                        clientReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AmazonClientException e) {
                throw new IOException("Exception when listing blobs by prefix [" + blobNamePrefix + "]", e);
            }
        }
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    public Map<String, BlobContainer> children() throws IOException {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        try {
            Map<String, BlobContainer> map = this.executeListing(clientReference, this.listObjectsRequest(this.keyPath)).stream().flatMap(listing -> {
                assert (listing.getObjectSummaries().stream().noneMatch(s -> {
                    for (String commonPrefix : listing.getCommonPrefixes()) {
                        if (!s.getKey().substring(this.keyPath.length()).startsWith(commonPrefix)) continue;
                        return true;
                    }
                    return false;
                })) : "Response contained children for listed common prefixes.";
                return listing.getCommonPrefixes().stream();
            }).map(prefix -> prefix.substring(this.keyPath.length())).filter(name -> !name.isEmpty()).map(name -> name.substring(0, name.length() - 1)).collect(Collectors.toMap(Function.identity(), name -> this.blobStore.blobContainer(this.path().add(name))));
            if (clientReference != null) {
                clientReference.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (clientReference != null) {
                    try {
                        clientReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AmazonClientException e) {
                throw new IOException("Exception when listing children of [" + this.path().buildAsString() + "]", e);
            }
        }
    }

    private List<ObjectListing> executeListing(AmazonS3Reference clientReference, ListObjectsRequest listObjectsRequest) {
        ArrayList<ObjectListing> results = new ArrayList<ObjectListing>();
        ObjectListing prevListing = null;
        while (true) {
            ObjectListing list;
            if (prevListing != null) {
                ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest = new ListNextBatchOfObjectsRequest(prevListing);
                listNextBatchOfObjectsRequest.setRequestMetricCollector(this.blobStore.listMetricCollector);
                list = SocketAccess.doPrivileged(() -> clientReference.client().listNextBatchOfObjects(listNextBatchOfObjectsRequest));
            } else {
                list = SocketAccess.doPrivileged(() -> clientReference.client().listObjects(listObjectsRequest));
            }
            results.add(list);
            if (!list.isTruncated()) break;
            prevListing = list;
        }
        return results;
    }

    private ListObjectsRequest listObjectsRequest(String pathPrefix) {
        return (ListObjectsRequest)new ListObjectsRequest().withBucketName(this.blobStore.bucket()).withPrefix(pathPrefix).withDelimiter("/").withRequestMetricCollector(this.blobStore.listMetricCollector);
    }

    private String buildKey(String blobName) {
        return this.keyPath + blobName;
    }

    void executeSingleUpload(S3BlobStore s3BlobStore, String blobName, InputStream input, long blobSize) throws IOException {
        if (blobSize > S3Repository.MAX_FILE_SIZE.getBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than " + S3Repository.MAX_FILE_SIZE);
        }
        if (blobSize > s3BlobStore.bufferSizeInBytes()) {
            throw new IllegalArgumentException("Upload request size [" + blobSize + "] can't be larger than buffer size");
        }
        ObjectMetadata md = new ObjectMetadata();
        md.setContentLength(blobSize);
        if (s3BlobStore.serverSideEncryption()) {
            md.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        PutObjectRequest putRequest = new PutObjectRequest(s3BlobStore.bucket(), blobName, input, md);
        putRequest.setStorageClass(s3BlobStore.getStorageClass());
        putRequest.setCannedAcl(s3BlobStore.getCannedACL());
        putRequest.setRequestMetricCollector(s3BlobStore.putMetricCollector);
        try (AmazonS3Reference clientReference = s3BlobStore.clientReference();){
            SocketAccess.doPrivilegedVoid(() -> clientReference.client().putObject(putRequest));
        }
        catch (AmazonClientException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using a single upload", e);
        }
    }

    void executeMultipartUpload(S3BlobStore s3BlobStore, String blobName, InputStream input, long blobSize) throws IOException {
        this.ensureMultiPartUploadSize(blobSize);
        long partSize = s3BlobStore.bufferSizeInBytes();
        Tuple<Long, Long> multiparts = S3BlobContainer.numberOfMultiparts(blobSize, partSize);
        if ((Long)multiparts.v1() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many multipart upload requests, maybe try a larger buffer size?");
        }
        int nbParts = ((Long)multiparts.v1()).intValue();
        long lastPartSize = (Long)multiparts.v2();
        assert (blobSize == (long)(nbParts - 1) * partSize + lastPartSize) : "blobSize does not match multipart sizes";
        SetOnce uploadId = new SetOnce();
        String bucketName = s3BlobStore.bucket();
        boolean success = false;
        try (AmazonS3Reference clientReference = s3BlobStore.clientReference();){
            uploadId.set((Object)SocketAccess.doPrivileged(() -> clientReference.client().initiateMultipartUpload(this.initiateMultiPartUpload(blobName)).getUploadId()));
            if (org.elasticsearch.common.Strings.isEmpty((CharSequence)((CharSequence)uploadId.get()))) {
                throw new IOException("Failed to initialize multipart upload " + blobName);
            }
            ArrayList<PartETag> parts = new ArrayList<PartETag>();
            long bytesCount = 0L;
            for (int i = 1; i <= nbParts; ++i) {
                boolean lastPart = i == nbParts;
                UploadPartRequest uploadRequest = this.createPartUploadRequest(input, (String)uploadId.get(), i, blobName, lastPart ? lastPartSize : partSize, lastPart);
                bytesCount += uploadRequest.getPartSize();
                UploadPartResult uploadResponse = SocketAccess.doPrivileged(() -> clientReference.client().uploadPart(uploadRequest));
                parts.add(uploadResponse.getPartETag());
            }
            if (bytesCount != blobSize) {
                throw new IOException("Failed to execute multipart upload for [" + blobName + "], expected " + blobSize + "bytes sent but got " + bytesCount);
            }
            CompleteMultipartUploadRequest complRequest = new CompleteMultipartUploadRequest(bucketName, blobName, (String)uploadId.get(), parts);
            complRequest.setRequestMetricCollector(s3BlobStore.multiPartUploadMetricCollector);
            SocketAccess.doPrivilegedVoid(() -> clientReference.client().completeMultipartUpload(complRequest));
            success = true;
        }
        catch (AmazonClientException e) {
            throw new IOException("Unable to upload object [" + blobName + "] using multipart upload", e);
        }
        finally {
            if (!success && org.elasticsearch.common.Strings.hasLength((String)((String)uploadId.get()))) {
                this.abortMultiPartUpload((String)uploadId.get(), blobName);
            }
        }
    }

    void ensureMultiPartUploadSize(long blobSize) {
        if (blobSize > S3Repository.MAX_FILE_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be larger than " + S3Repository.MAX_FILE_SIZE_USING_MULTIPART);
        }
        if (blobSize < S3Repository.MIN_PART_SIZE_USING_MULTIPART.getBytes()) {
            throw new IllegalArgumentException("Multipart upload request size [" + blobSize + "] can't be smaller than " + S3Repository.MIN_PART_SIZE_USING_MULTIPART);
        }
    }

    static Tuple<Long, Long> numberOfMultiparts(long totalSize, long partSize) {
        if (partSize <= 0L) {
            throw new IllegalArgumentException("Part size must be greater than zero");
        }
        if (totalSize == 0L || totalSize <= partSize) {
            return Tuple.tuple((Object)1L, (Object)totalSize);
        }
        long parts = totalSize / partSize;
        long remaining = totalSize % partSize;
        if (remaining == 0L) {
            return Tuple.tuple((Object)parts, (Object)partSize);
        }
        return Tuple.tuple((Object)(parts + 1L), (Object)remaining);
    }

    public void compareAndExchangeRegister(String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        AmazonS3Reference clientReference = this.blobStore.clientReference();
        ActionListener.run((ActionListener)ActionListener.releaseAfter((ActionListener)listener.delegateResponse((delegate, e) -> {
            AmazonS3Exception amazonS3Exception;
            if (e instanceof AmazonS3Exception && (amazonS3Exception = (AmazonS3Exception)((Object)((Object)e))).getStatusCode() == 404) {
                delegate.onResponse((Object)OptionalBytesReference.MISSING);
            } else {
                delegate.onFailure(e);
            }
        }), (Releasable)clientReference), l -> new CompareAndExchangeOperation(clientReference.client(), this.blobStore.bucket(), key, this.blobStore.getThreadPool()).run(expected, updated, (ActionListener<OptionalBytesReference>)l));
    }

    public void getRegister(String key, ActionListener<OptionalBytesReference> listener) {
        ActionListener.completeWith(listener, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private static /* synthetic */ S3Object lambda$getRegister$25(AmazonS3Reference clientReference, GetObjectRequest getObjectRequest) {
        return clientReference.client().getObject(getObjectRequest);
    }

    private class CompareAndExchangeOperation {
        private final AmazonS3 client;
        private final String bucket;
        private final String rawKey;
        private final String blobKey;
        private final ThreadPool threadPool;

        CompareAndExchangeOperation(AmazonS3 client, String bucket, String key, ThreadPool threadPool) {
            this.client = client;
            this.bucket = bucket;
            this.rawKey = key;
            this.blobKey = S3BlobContainer.this.buildKey(key);
            this.threadPool = threadPool;
        }

        private List<MultipartUpload> listMultipartUploads() {
            ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(this.bucket);
            listRequest.setPrefix(this.blobKey);
            listRequest.setRequestMetricCollector(S3BlobContainer.this.blobStore.listMetricCollector);
            try {
                return SocketAccess.doPrivileged(() -> this.client.listMultipartUploads(listRequest)).getMultipartUploads();
            }
            catch (AmazonS3Exception e) {
                if (e.getStatusCode() == 404) {
                    return List.of();
                }
                throw e;
            }
        }

        private int getUploadIndex(String targetUploadId, List<MultipartUpload> multipartUploads) {
            int uploadIndex = 0;
            boolean found = false;
            for (MultipartUpload multipartUpload : multipartUploads) {
                String observedUploadId = multipartUpload.getUploadId();
                if (observedUploadId.equals(targetUploadId)) {
                    found = true;
                    continue;
                }
                if (observedUploadId.compareTo(targetUploadId) >= 0) continue;
                ++uploadIndex;
            }
            return found ? uploadIndex : -1;
        }

        void run(BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) throws Exception {
            BlobContainerUtils.ensureValidRegisterContent((BytesReference)updated);
            if (!this.listMultipartUploads().isEmpty()) {
                listener.onResponse((Object)OptionalBytesReference.MISSING);
                return;
            }
            InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(this.bucket, this.blobKey);
            initiateRequest.setRequestMetricCollector(S3BlobContainer.this.blobStore.multiPartUploadMetricCollector);
            String uploadId = SocketAccess.doPrivileged(() -> this.client.initiateMultipartUpload(initiateRequest)).getUploadId();
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(this.bucket);
            uploadPartRequest.setKey(this.blobKey);
            uploadPartRequest.setUploadId(uploadId);
            uploadPartRequest.setPartNumber(1);
            uploadPartRequest.setLastPart(true);
            uploadPartRequest.setInputStream((InputStream)updated.streamInput());
            uploadPartRequest.setPartSize((long)updated.length());
            uploadPartRequest.setRequestMetricCollector(S3BlobContainer.this.blobStore.multiPartUploadMetricCollector);
            PartETag partETag = SocketAccess.doPrivileged(() -> this.client.uploadPart(uploadPartRequest)).getPartETag();
            List<MultipartUpload> currentUploads = this.listMultipartUploads();
            int uploadIndex = this.getUploadIndex(uploadId, currentUploads);
            if (uploadIndex < 0) {
                listener.onResponse((Object)OptionalBytesReference.MISSING);
                return;
            }
            AtomicBoolean isComplete = new AtomicBoolean();
            Runnable doCleanup = () -> {
                block3: {
                    if (isComplete.compareAndSet(false, true)) {
                        try {
                            this.abortMultipartUploadIfExists(uploadId);
                        }
                        catch (Exception e) {
                            logger.error("unexpected error cleaning up upload [" + uploadId + "] of [" + this.blobKey + "]", (Throwable)e);
                            if ($assertionsDisabled) break block3;
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            };
            try (RefCountingListener listeners = new RefCountingListener(ActionListener.runAfter((ActionListener)listener.delegateFailure((delegate1, ignored) -> S3BlobContainer.this.getRegister(this.rawKey, (ActionListener<OptionalBytesReference>)delegate1.delegateFailure((delegate2, currentValue) -> ActionListener.completeWith((ActionListener)delegate2, () -> {
                if (currentValue.isPresent() && currentValue.bytesReference().equals(expected)) {
                    CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucket, this.blobKey, uploadId, List.of(partETag));
                    completeMultipartUploadRequest.setRequestMetricCollector(S3BlobContainer.this.blobStore.multiPartUploadMetricCollector);
                    SocketAccess.doPrivilegedVoid(() -> this.client.completeMultipartUpload(completeMultipartUploadRequest));
                    isComplete.set(true);
                }
                return currentValue;
            })))), (Runnable)doCleanup));){
                if (currentUploads.size() > 1) {
                    ActionListener delayListener = listeners.acquire();
                    Runnable cancelConcurrentUpdates = () -> {
                        try {
                            for (MultipartUpload currentUpload : currentUploads) {
                                String currentUploadId = currentUpload.getUploadId();
                                if (uploadId.equals(currentUploadId)) continue;
                                this.threadPool.executor("snapshot").execute((Runnable)ActionRunnable.run((ActionListener)listeners.acquire(), () -> this.abortMultipartUploadIfExists(currentUploadId)));
                            }
                        }
                        finally {
                            delayListener.onResponse(null);
                        }
                    };
                    if (uploadIndex > 0) {
                        this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueMillis((long)(TimeValue.timeValueSeconds((long)uploadIndex).millis() + (long)Randomness.get().nextInt(50))), "snapshot", cancelConcurrentUpdates);
                    } else {
                        cancelConcurrentUpdates.run();
                    }
                }
            }
        }

        private void abortMultipartUploadIfExists(String uploadId) {
            block2: {
                try {
                    AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(this.bucket, this.blobKey, uploadId);
                    request.setRequestMetricCollector(S3BlobContainer.this.blobStore.abortPartUploadMetricCollector);
                    SocketAccess.doPrivilegedVoid(() -> this.client.abortMultipartUpload(request));
                }
                catch (AmazonS3Exception e) {
                    if (e.getStatusCode() == 404) break block2;
                    throw e;
                }
            }
        }
    }
}

