/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.action.GetSearchApplicationAction;

public class TransportGetSearchApplicationAction
extends HandledTransportAction<GetSearchApplicationAction.Request, GetSearchApplicationAction.Response> {
    protected final SearchApplicationIndexService systemIndexService;

    @Inject
    public TransportGetSearchApplicationAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, BigArrays bigArrays) {
        super("cluster:admin/xpack/application/search_application/get", transportService, actionFilters, GetSearchApplicationAction.Request::new);
        this.systemIndexService = new SearchApplicationIndexService(client, clusterService, namedWriteableRegistry, bigArrays);
    }

    protected void doExecute(Task task, GetSearchApplicationAction.Request request, ActionListener<GetSearchApplicationAction.Response> listener) {
        this.systemIndexService.getSearchApplication(request.getName(), (ActionListener<SearchApplication>)listener.map(searchApplication -> {
            if (!searchApplication.hasStoredTemplate()) {
                HeaderWarning.addWarning((String)"Using default search application template which is subject to change. We recommend storing a template to avoid breaking changes.", (Object[])new Object[0]);
            }
            return new GetSearchApplicationAction.Response(searchApplication.name(), searchApplication.indices(), searchApplication.analyticsCollectionName(), searchApplication.updatedAtMillis(), searchApplication.searchApplicationTemplateOrDefault());
        }));
    }
}

